/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.common.CardTemplate;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.TemplateContainer;
import org.eclipse.higgins.icard.common.TemplateValue;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;

public class PersonalCardTemplateHelper {
    public static final String CARD_TEMPLATE_ID = "PersonalCardTemplate";
    public static final String CARD_NAME = "cardName";
    public static final String CARD_PICTURE = "cardPicture";
    public static final String CLAIM_LIST = "claimList";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static CardTemplate getCardTemplate(ICardProvider provider) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.IPersonalInformationCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CardTemplate cardTemplate = new CardTemplate(CARD_TEMPLATE_ID, "Personal card template", "Personal card template", provider, (Class)clazz);
        cardTemplate.addTemplateElement((ITemplateElement)TemplateValue.createTextFieldTemplate((String)CARD_NAME, (String)"Selfish", null, (String)"Card name", (String)"Card name", null, (boolean)false));
        cardTemplate.addTemplateElement((ITemplateElement)TemplateValue.createFileTemplate((String)CARD_PICTURE, null, (String)"Card picture", (String)"Card picture", (boolean)false));
        TemplateContainer claims = new TemplateContainer(CLAIM_LIST, "Information that will be sent with this card", "Claim list");
        ArrayList claimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = claimTypes.size();
        int i = 0;
        while (i < size) {
            ClaimType ct = (ClaimType)claimTypes.get(i);
            String type = ct.getType();
            if (!"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
                TemplateValue val = null;
                if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type)) {
                    val = TemplateValue.createComboBoxTemplate((String)ct.getType(), (String)"", (List)SelfIssuedCardClaims.getGenderValuesList_TEST(), (String)ct.getDescription(), (String)ct.getDisplayName(), (boolean)false);
                } else if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth".equals(type)) {
                    val = TemplateValue.createTextFieldTemplate((String)ct.getType(), (String)"", null, (String)ct.getDescription(), (String)ct.getDisplayName(), null, (boolean)false);
                } else {
                    String pattern = null;
                    if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress".equals(type)) {
                        pattern = "^\\w+\\S*@\\S+\\.[a-zA-Z]+$";
                    }
                    val = TemplateValue.createTextFieldTemplate((String)ct.getType(), (String)"", (String)pattern, (String)ct.getDescription(), (String)ct.getDisplayName(), null, (boolean)false);
                }
                claims.addTemplateElement((ITemplateElement)val);
            }
            ++i;
        }
        cardTemplate.addTemplateElement((ITemplateElement)claims);
        return cardTemplate;
    }

    public static HashMap getDirtyClaimsFromCardTemplate(ICardTemplate template) throws CardException {
        if (template == null) {
            throw new CardException("Parameter \"template\" is null.");
        }
        if (!CARD_TEMPLATE_ID.equals(template.getID())) {
            throw new CardException("Unexpected template ID : " + template.getID());
        }
        ITemplateElement te = template.getTemplateElementByID(CLAIM_LIST);
        if (te == null) {
            throw new CardException("Claim list template container was not found.");
        }
        if (!(te instanceof ITemplateContainer)) {
            StringBuffer stringBuffer = new StringBuffer("Claim list expected to be an instance of ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.higgins.icard.ITemplateContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new CardException(stringBuffer.append(clazz.getName()).toString());
        }
        ITemplateContainer claimContainer = (ITemplateContainer)te;
        ArrayList supportedClaimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        HashMap<String, String> res = new HashMap<String, String>();
        int size = supportedClaimTypes.size();
        int i = 0;
        while (i < size) {
            String val;
            ITemplateValue value;
            ClaimType claimType = (ClaimType)supportedClaimTypes.get(i);
            String type = claimType.getType();
            if (!"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type) && (value = claimContainer.getTemplateValueByID(type)) != null && (val = value.getValue()) != null && val.trim().length() > 0) {
                if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth".equals(type)) {
                    val = SelfIssuedCardClaims.convertICMDate_TEST(val);
                } else if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type)) {
                    val = SelfIssuedCardClaims.getGenderCode_TEST(val);
                }
                res.put(type, val);
            }
            ++i;
        }
        return res;
    }
}

