/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    abhi shelat (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.icard.provider.cardspace.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class CardspaceDisplayMappings {

	private static final Log log = LogFactory.getLog(CardspaceDisplayMappings.class);
	
	private static final String BUNDLE_NAME = "org.eclipse.higgins.icard.provider.cardspace.common.cardspacedisplaymapping"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private CardspaceDisplayMappings() {
	}

	public static String getString(String key) {
		String k=key;
		try {
			k = key.replace(':', '-');
			return RESOURCE_BUNDLE.getString(k);
		} catch (MissingResourceException e) {
			log.error(e, e);
			return key;
		}
	}
}
