/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.sts.api.IFault;

/**
 * This exception throws by the reason of STS fault.
 */
public class STSFaultException extends CardException {
	private static final long serialVersionUID = 0L;
	private IFault fault;

	public STSFaultException(IFault fault) {
		super();
		this.fault = fault;
	}

	public IFault getFault() {
		return fault;
	}

	public STSFaultException(String message, IFault fault) {
		super(message);
		this.fault = fault;
	}

	public STSFaultException(String message, Throwable cause, IFault fault) {
		super(message, cause);
		this.fault = fault;
	}

}
