/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderConfiguration implements IConfiguration {
	
	private static final Log log = LogFactory.getLog(ProviderConfiguration.class);
	
	private String id = null;
	
	private Properties defaults = null;
	
	private Properties properties = null;

	/**
	 * 
	 */
	public ProviderConfiguration(String id) {
		this.id = id;
		loadDefaults();
		properties = new Properties(defaults);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#load(java.io.File)
	 */
	public void load(File config) {
		FileInputStream in = null;
		try {
			in = new FileInputStream(config);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			Document doc = null;
			DocumentBuilder db = dbf.newDocumentBuilder();
			doc = db.parse(new InputSource(in));
			Element root = doc.getDocumentElement();
			String id = root.getAttribute("id");
			if (id != null) {
				if (!id.equals(this.id)) {
					log.warn("Warning: provider id doesn't match - " + this.id + "!=" + id);
				}
			}
			setProperties(loadProperties(root));
		} catch (Exception e) {
			log.error(e, e);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (Exception e) {
					log.error(e, e);
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#save(java.io.File)
	 */
	public void save(File config) {
		// TODO Auto-generated method stub
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getPropertyNames()
	 */
	public Iterator getPropertyNames() {
		List list = new ArrayList();
		for (Enumeration e = defaults.propertyNames(); e.hasMoreElements();) {
			String s = (String) e.nextElement();
			list.add(s);
		}
		return list.iterator();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String)
	 */
	public String getProperty(String key) {
		return properties.getProperty(key);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String, java.lang.String)
	 */
	public String getProperty(String key, String defaultValue) {
		return properties.getProperty(key, defaultValue);
	}

	private void loadDefaults() {
		defaults = new Properties();
		InputStream is = null;
		try {
			is = Thread.currentThread().getContextClassLoader().getResourceAsStream(id + ".properties");
			defaults.load(is);
		} catch (Exception e) {
			log.error(e, e);
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					log.error(e, e);
				}
			}
		}
	}
	
	private Properties loadProperties(Element e) {
		Properties props = new Properties();
		NodeList nl = e.getChildNodes();
		for (int i = 0; i < nl.getLength(); i++) {
			Node node = nl.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("parameter")) {
				Element el = (Element) node;
				String name = el.getAttribute("name");
				if (name.length() > 0) {
					String value = el.getAttribute("value");
					props.put(name, value);
				}
			}
		}
		return props;
	}
	
	private void setProperties(Properties properties) {
		this.properties = new Properties(defaults);
		Iterator itr = properties.keySet().iterator();
		while (itr.hasNext()) {
			Object o = itr.next();
			String k = (String) o;
			this.properties.setProperty(k, properties.getProperty(k));
		}
	}
}
