/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.security.auth.callback.PasswordCallback;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRDSInputProcessor implements IInputProcessor {
	private Log log = LogFactory.getLog(CRDSInputProcessor.class);

	public IFormatDescriptor checkInput(InputStream is) {
		IFormatDescriptor res = null;
		if (CardCryptography.isEncriptedStore(is)) {
			res = CRDSFormatProvider.formatDescriptor; 
		}
		return res;
	}

	public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
		IElement[] res = null;
		Document cardBackup;
		try {
			PasswordCallback pc = (PasswordCallback) credential.getCallbacks()[0];
			String password = new String(pc.getPassword());
			cardBackup = CardCryptography.decrypt(is, password);
		} catch (Exception e) {
			log.error(e,e);
			throw new CardIOException(e);
		}
		
		/*try {
			writeDoc(cardBackup, new FileOutputStream("D:/temp/b/test2.xml"));
		} catch (FileNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}*/
		
		List cardsList = new ArrayList();
		NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
		for (int i = 0; i < newCards.getLength(); i++) {
			Node nd = newCards.item(i);
			if (nd.getNodeType() == Node.ELEMENT_NODE) {
				Element card = (Element) nd;
				try {
					IElement e = new IOICardElement();
					e.set(card);
					cardsList.add(e);
				} catch (Exception e) {
					log.error(e,e);
				}
			}
		}

		res = new IElement[cardsList.size()];
		for (int i = 0; i < res.length; i++) {
			res[i] = (IElement) cardsList.get(i);
		}
		
		return res;
	}
	
	private void writeDoc(Document doc, OutputStream os) {
		try {
			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.METHOD, "xml"); //$NON-NLS-1$
			transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
			DOMSource source = new DOMSource(doc);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);
			os.flush();
		} catch (Exception ex) {
			log.error(ex, ex);
		}
	}
}
