package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.common.CardTemplate;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.TemplateContainer;
import org.eclipse.higgins.icard.common.TemplateValue;

public class PersonalCardTemplateHelper {

	public static final String CARD_TEMPLATE_ID = "PersonalCardTemplate";

	public static final String CARD_NAME = "cardName";

	public static final String CARD_PICTURE = "cardPicture";

	public static final String CLAIM_LIST = "claimList";

	/**
	 * @param provider
	 * @return
	 */
	public static CardTemplate getCardTemplate(ICardProvider provider) {
		CardTemplate cardTemplate = new CardTemplate(CARD_TEMPLATE_ID, "Personal card template", 
				"Personal card template", provider,
				IPersonalInformationCard.class);
		cardTemplate.addTemplateElement(TemplateValue.createTextFieldTemplate(CARD_NAME, "Selfish", null, 
				"Card name", "Card name", null, false));
		cardTemplate.addTemplateElement(TemplateValue.createFileTemplate(CARD_PICTURE, null, "Card picture", 
				"Card picture", false));
		TemplateContainer claims = new TemplateContainer(CLAIM_LIST, "Information that will be sent with this card", 
				"Claim list");
		ArrayList claimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
		int size = claimTypes.size();
		for (int i = 0; i < size; i++) {
			ClaimType ct = (ClaimType) claimTypes.get(i);
			String type = ct.getType();
			if (SelfIssuedCardClaims.PPID_TYPE.equals(type)) {
				continue;
			}
			ITemplateValue val = null;
			if (SelfIssuedCardClaims.GENDER_TYPE.equals(type)) {
				val = TemplateValue.createComboBoxTemplate(ct.getType(), "", SelfIssuedCardClaims.getGenderValuesList_TEST(),
						ct.getDescription(), ct.getDisplayName(), false);
			} else if (SelfIssuedCardClaims.DATE_OF_BIRTH_TYPE.equals(type)) {
				val = TemplateValue.createTextFieldTemplate(ct.getType(), "", null, ct.getDescription(), 
						ct.getDisplayName(), null, false);
			
			} else {
				String pattern = null;
				if (SelfIssuedCardClaims.EMAIL_ADDRESS_TYPE.equals(type)) {
					pattern = "^\\w+\\S*@\\S+\\.[a-zA-Z]+$";
				}
				val = TemplateValue.createTextFieldTemplate(ct.getType(), "", pattern, ct.getDescription(), 
						ct.getDisplayName(), null, false);
			}
			claims.addTemplateElement(val);
		}
		cardTemplate.addTemplateElement(claims);
		return cardTemplate;
	}

	/**
	 * @param template
	 * @return <code>ArrayList</code>
	 */
	public static HashMap getDirtyClaimsFromCardTemplate(ICardTemplate template) throws CardException {
		if (template == null)
			throw new CardException("Parameter \"template\" is null.");
		if (CARD_TEMPLATE_ID.equals(template.getID()) == false)
			throw new CardException("Unexpected template ID : " + template.getID());
		ITemplateElement te = template.getTemplateElementByID(CLAIM_LIST);
		if (te == null)
			throw new CardException("Claim list template container was not found.");
		if (te instanceof ITemplateContainer == false)
			throw new CardException("Claim list expected to be an instance of " + ITemplateContainer.class.getName());
		ITemplateContainer claimContainer = (ITemplateContainer) te;
		ArrayList supportedClaimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
		HashMap res = new HashMap();
		int size = supportedClaimTypes.size();
		for (int i = 0; i < size; i++) {
			ClaimType claimType = (ClaimType) supportedClaimTypes.get(i);
			String type = claimType.getType();
			if (SelfIssuedCardClaims.PPID_TYPE.equals(type))
				continue;
			ITemplateValue value = claimContainer.getTemplateValueByID(type);
			if (value != null) {
				String val = value.getValue();
				if (val != null && val.trim().length() > 0) {
					// dateOfBirth claim should be in xsd:date format (yyyy-mm-dd)
					if (SelfIssuedCardClaims.DATE_OF_BIRTH_TYPE.equals(type)) {
						val = SelfIssuedCardClaims.convertICMDate_TEST(val);
					}
					// gender claim should be 1 (male), 2 (female), 0 (undefined)
					else if (SelfIssuedCardClaims.GENDER_TYPE.equals(type)) {
						val = SelfIssuedCardClaims.getGenderCode_TEST(val);
					}
					res.put(type, val);
				}
			}
		}
		return res;
	}

}
