/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.db.DAOStoredEvent;
import org.eclipse.higgins.icard.provider.cardspace.db.ICardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.IConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAO;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoMCard;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCard;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.ConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoMCard;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard;

public class CardContext
implements ICardContext {
    private Log log_ = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$CardContext == null ? (class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$CardContext = CardContext.class$("org.eclipse.higgins.icard.provider.cardspace.db.mysql.CardContext")) : class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$CardContext));
    public static final String JNDI_CONTEXT = "jndi.context";
    public static final String SOURCE_NAME = "source.name";
    public static final String DRIVER_CLASS_NAME = "driver.classname";
    public static final String DB_USER_NAME = "db.username";
    public static final String DB_PASSWORD = "db.password";
    public static final String DB_URL = "db.url";
    public static final String USE_POOL = "db.pool";
    protected boolean isPoolUsed_;
    protected String driverName_;
    protected String dbUserName_;
    protected String dbPassword_;
    protected String dbURL_;
    protected String jndiContext_;
    protected String sourceName_;
    protected ConnectionFactory connectionFactory_ = null;
    private static ICache cardCache = CacheProviderFactory.getCacheProvider().getCache("cardcontext.mysql");
    private static boolean isNoCache = cardCache instanceof NOCache;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$CardContext;

    public void init(Map config) throws CardException {
        String useConnectionPool = config.containsKey(USE_POOL) ? (String)config.get(USE_POOL) : null;
        boolean bl = this.isPoolUsed_ = "yes".equalsIgnoreCase(useConnectionPool);
        if (this.isPoolUsed_) {
            this.jndiContext_ = config.containsKey(JNDI_CONTEXT) ? (String)config.get(JNDI_CONTEXT) : null;
            String string = this.sourceName_ = config.containsKey(SOURCE_NAME) ? (String)config.get(SOURCE_NAME) : null;
            if (this.jndiContext_ == null) {
                throw new CardException("Property \"jndi.context\" not found.");
            }
            if (this.sourceName_ == null) {
                throw new CardException("Property \"source.name\" not found.");
            }
            this.connectionFactory_ = new ConnectionFactory(this.jndiContext_, this.sourceName_);
        } else {
            this.driverName_ = config.containsKey(DRIVER_CLASS_NAME) ? (String)config.get(DRIVER_CLASS_NAME) : "com.mysql.jdbc.Driver";
            this.dbUserName_ = config.containsKey(DB_USER_NAME) ? (String)config.get(DB_USER_NAME) : null;
            this.dbPassword_ = config.containsKey(DB_PASSWORD) ? (String)config.get(DB_PASSWORD) : "";
            String string = this.dbURL_ = config.containsKey(DB_URL) ? (String)config.get(DB_URL) : null;
            if (this.dbUserName_ == null) {
                throw new CardException("Property \"db.username\" not found.");
            }
            if (this.dbURL_ == null) {
                throw new CardException("Property \"db.url\" not found.");
            }
            this.connectionFactory_ = new ConnectionFactory(this.driverName_, this.dbUserName_, this.dbPassword_, this.dbURL_);
        }
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory_;
    }

    public IDaoMCard createMCard(String userID) {
        DaoMCard card = new DaoMCard(this, userID);
        return card;
    }

    public IDaoPCard createPCard(String userID) {
        DaoPCard card = new DaoPCard(this, userID);
        return card;
    }

    public IDaoMCard getMCard(String cardID, String userID) throws CardException {
        IDaoMCard card = null;
        if (isNoCache) {
            card = this.getMCardFromDB(cardID, userID);
        } else {
            this.ensureInCache(userID);
            card = this.getMCardFromCache(userID, cardID);
        }
        return card;
    }

    /*
     * Loose catch block
     */
    private IDaoMCard getMCardFromDB(String cardID, String userID) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block28: {
            if (cardID == null || cardID.trim().length() == 0) {
                throw new CardException("Can not return a card for null or empty card ID.");
            }
            if (userID == null || userID.trim().length() == 0) {
                throw new CardException("Can not return a card for null or empty user ID.");
            }
            String query = "SELECT * FROM ManagedCard WHERE cardID_ = ? AND userID_ = ?";
            con = null;
            ps = null;
            rs = null;
            con = this.connectionFactory_.getConnection();
            ps = con.prepareStatement(query);
            ps.setString(1, cardID);
            ps.setString(2, userID);
            rs = ps.executeQuery();
            if (!rs.next()) break block28;
            DaoMCard daoMCard = new DaoMCard(this, userID, rs, con);
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                    con = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            return daoMCard;
        }
        IDaoMCard iDaoMCard = null;
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        return iDaoMCard;
        catch (Exception e) {
            try {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                throw throwable;
            }
        }
    }

    public ArrayList getMCards(String userID) throws CardException {
        if (isNoCache) {
            return this.getMCardsFromDB(userID);
        }
        this.ensureInCache(userID);
        CachedCards cards = this.getCachedCards(userID);
        return new ArrayList(cards.getMCards().values());
    }

    /*
     * Loose catch block
     */
    private ArrayList getMCardsFromDB(String userID) throws CardException {
        Object card;
        if (userID == null || userID.trim().length() == 0) {
            throw new CardException("Can not return a card for null or empty user ID.");
        }
        String query = "SELECT * FROM ManagedCard WHERE userID_ = ? ORDER BY id_";
        ArrayList<Object> list = new ArrayList<Object>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        con = this.connectionFactory_.getConnection();
        ps = con.prepareStatement(query);
        ps.setString(1, userID);
        rs = ps.executeQuery();
        while (rs.next()) {
            card = new DaoMCard(this, userID, rs, con);
            list.add(card);
        }
        card = list;
        Object var9_9 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        return card;
        catch (Exception e) {
            try {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                throw throwable;
            }
        }
    }

    public IDaoPCard getPCard(String cardID, String userID) throws CardException {
        IDaoPCard card = null;
        if (isNoCache) {
            card = this.getPCardFromDB(cardID, userID);
        } else {
            this.ensureInCache(userID);
            card = this.getPCardFromCache(userID, cardID);
        }
        return card;
    }

    /*
     * Loose catch block
     */
    private IDaoPCard getPCardFromDB(String cardID, String userID) throws CardException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block28: {
            if (cardID == null || cardID.trim().length() == 0) {
                throw new CardException("Can not return a card for null or empty card ID.");
            }
            if (userID == null || userID.trim().length() == 0) {
                throw new CardException("Can not return a card for null or empty user ID.");
            }
            String query = "SELECT * FROM PersonalCard WHERE cardID_ = ? AND userID_ = ?";
            con = null;
            ps = null;
            rs = null;
            con = this.connectionFactory_.getConnection();
            ps = con.prepareStatement(query);
            ps.setString(1, cardID);
            ps.setString(2, userID);
            rs = ps.executeQuery();
            if (!rs.next()) break block28;
            DaoPCard daoPCard = new DaoPCard(this, userID, rs, con);
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                    con = null;
                }
            }
            catch (SQLException e2) {
                this.log_.error((Object)e2);
            }
            return daoPCard;
        }
        IDaoPCard iDaoPCard = null;
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        return iDaoPCard;
        catch (Exception e) {
            try {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                throw throwable;
            }
        }
    }

    public ArrayList getPCards(String userID) throws CardException {
        if (isNoCache) {
            return this.getPCardsFromDB(userID);
        }
        this.ensureInCache(userID);
        CachedCards cards = this.getCachedCards(userID);
        return new ArrayList(cards.getPCards().values());
    }

    /*
     * Loose catch block
     */
    private ArrayList getPCardsFromDB(String userID) throws CardException {
        Object card;
        if (userID == null || userID.trim().length() == 0) {
            throw new CardException("Can not return a card for null or empty user ID.");
        }
        String query = "SELECT * FROM PersonalCard WHERE userID_ = ? ORDER BY id_";
        ArrayList<Object> list = new ArrayList<Object>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        con = this.connectionFactory_.getConnection();
        ps = con.prepareStatement(query);
        ps.setString(1, userID);
        rs = ps.executeQuery();
        while (rs.next()) {
            card = new DaoPCard(this, userID, rs, con);
            list.add(card);
        }
        card = list;
        Object var9_9 = null;
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                con = null;
            }
        }
        catch (SQLException e2) {
            this.log_.error((Object)e2);
        }
        return card;
        catch (Exception e) {
            try {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e2) {
                    this.log_.error((Object)e2);
                }
                throw throwable;
            }
        }
    }

    public void objectStored(DAOStoredEvent event) {
        IDAO obj = event.getObject();
        if (obj.getState() == 5 && !isNoCache) {
            if (obj instanceof IDaoPCard) {
                this.removeDeletedPCardsFromCache((IDaoPCard)obj);
            } else if (obj instanceof IDaoMCard) {
                this.removeDeletedMCardsFromCache((IDaoMCard)obj);
            }
        }
        if (obj.getState() == 1 && !isNoCache) {
            if (obj instanceof DaoPCard) {
                DaoPCard card = (DaoPCard)obj;
                String userID = card.getUserID();
                try {
                    this.ensureInCache(userID);
                    this.updateCache(card, userID);
                }
                catch (CardException e) {
                    this.log_.error((Object)e);
                }
            } else if (obj instanceof DaoMCard) {
                try {
                    DaoMCard card = (DaoMCard)obj;
                    String userID = card.getUserID();
                    this.ensureInCache(userID);
                    this.updateCache(card, userID);
                }
                catch (CardException e) {
                    this.log_.error((Object)e);
                }
            }
        }
    }

    private void removeDeletedMCardsFromCache(IDaoMCard card) {
        try {
            String userID = card.getUserID();
            this.ensureInCache(userID);
            CachedCards cards = this.getCachedCards(userID);
            Object removedCard = cards.getMCards().remove(card.getCardID());
            if (removedCard != null) {
                this.log_.debug((Object)"M-card has been removed from cache");
                this.updateCache(cards, userID);
            }
        }
        catch (CardException e) {
            this.log_.error((Object)e);
        }
    }

    private void removeDeletedPCardsFromCache(IDaoPCard card) {
        try {
            String userID = card.getUserID();
            this.ensureInCache(userID);
            CachedCards cards = this.getCachedCards(userID);
            Object removedCard = cards.getPCards().remove(card.getCardID());
            if (removedCard != null) {
                this.log_.debug((Object)"M-card has been removed from cache");
                this.updateCache(cards, userID);
            }
        }
        catch (CardException e) {
            this.log_.error((Object)e);
        }
    }

    private void ensureInCache(String userID) throws CardException {
        UserCacheKey key = new UserCacheKey(userID);
        if (!cardCache.isKeyInCache((ICacheKey)key)) {
            DAO card;
            this.log_.info((Object)("Load all managed ICards by userID:" + key.getKey().toString()));
            ArrayList lstMCards = this.getMCardsFromDB(userID);
            this.log_.info((Object)("Load all personal ICards by userID:" + key.getKey().toString()));
            ArrayList lstPCards = this.getPCardsFromDB(userID);
            CachedCards cachedCards = new CachedCards();
            Map m = cachedCards.getMCards();
            Iterator iterator = lstMCards.iterator();
            while (iterator.hasNext()) {
                card = (DaoMCard)iterator.next();
                m.put(((DaoMCard)card).getCardID(), card);
            }
            m = cachedCards.getPCards();
            iterator = lstPCards.iterator();
            while (iterator.hasNext()) {
                card = (DaoPCard)iterator.next();
                m.put(((DaoPCard)card).getCardID(), card);
            }
            cardCache.put((ICacheKey)key, (Object)cachedCards);
            this.log_.info((Object)(key.getKey().toString() + " cards cached."));
        }
    }

    private CachedCards getCachedCards(String userId) {
        UserCacheKey key = new UserCacheKey(userId);
        if (cardCache.isKeyInCache((ICacheKey)key)) {
            return (CachedCards)cardCache.get((ICacheKey)key);
        }
        throw new CacheException("Card Cache for user " + userId + " was not inited!");
    }

    private IDaoMCard getMCardFromCache(String userId, String cardID) {
        CachedCards cachedCards = this.getCachedCards(userId);
        return (DaoMCard)cachedCards.getMCards().get(cardID);
    }

    private IDaoPCard getPCardFromCache(String userId, String cardID) {
        CachedCards cachedCards = this.getCachedCards(userId);
        return (DaoPCard)cachedCards.getPCards().get(cardID);
    }

    private void updateCache(CachedCards cards, String userId) {
        UserCacheKey key = new UserCacheKey(userId);
        cardCache.put((ICacheKey)key, (Object)cards);
    }

    private void updateCache(DaoMCard crd, String userId) {
        CachedCards cards = this.getCachedCards(userId);
        cards.getMCards().put(crd.getCardID(), crd);
        this.updateCache(cards, userId);
    }

    private void updateCache(DaoPCard crd, String userId) {
        CachedCards cards = this.getCachedCards(userId);
        cards.getPCards().put(crd.getCardID(), crd);
        this.updateCache(cards, userId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CachedCards {
        private Map mCards = new HashMap();
        private Map pCards = new HashMap();

        public Map getMCards() {
            return this.mCards;
        }

        public Map getPCards() {
            return this.pCards;
        }
    }
}

