/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.db.DAOStoredEvent;
import org.eclipse.higgins.icard.provider.cardspace.db.IConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAO;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAOListener;

public abstract class DAO
implements IDAO {
    private Log log_ = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DAO == null ? (class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DAO = DAO.class$("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO")) : class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DAO));
    private static final long maxMySQLDate_ = 253402253999000L;
    protected int state_ = 0;
    protected int id_ = -1;
    protected IConnectionFactory connectionFactory_ = null;
    protected Vector listeners_ = new Vector();
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DAO;

    private void commitChildrenState() {
        ArrayList children = this.getChildren();
        if (children != null) {
            int j = children.size();
            for (int i = 0; i < j; ++i) {
                DAO obj = (DAO)children.get(i);
                obj.commitState();
            }
        }
    }

    protected void commitState() {
        switch (this.state_) {
            case 0: {
                if (this.id_ == -1) break;
                this.state_ = 1;
                break;
            }
            case 2: {
                this.state_ = 1;
                break;
            }
            case 4: {
                this.state_ = 5;
                break;
            }
            case 3: {
                this.state_ = 5;
            }
        }
        this.commitChildrenState();
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory_;
    }

    public int getID() {
        return this.id_;
    }

    public int getState() {
        return this.state_;
    }

    public boolean isChanged() {
        return this.state_ == 0 || this.state_ == 2 || this.state_ == 3;
    }

    protected void setChanged() throws CardException {
        if (this.state_ == 4 || this.state_ == 3) {
            throw new CardException("Can not change data for predeleted object.");
        }
        if (this.state_ == 5) {
            throw new CardException("Can not change data for deleted object.");
        }
        if (this.state_ == 1) {
            this.state_ = 2;
        }
    }

    public void setDeleteState() {
        ArrayList children;
        if (this.state_ == 0) {
            this.state_ = 4;
        }
        if (this.state_ == 1 || this.state_ == 2) {
            this.state_ = 3;
        }
        if ((children = this.getChildren()) != null) {
            int j = children.size();
            for (int i = 0; i < j; ++i) {
                DAO obj = (DAO)children.get(i);
                obj.setDeleteState();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void store() throws CardException {
        block12: {
            Connection con = null;
            con = this.getConnectionFactory().getConnection();
            this.updateState(con);
            if (!con.getAutoCommit()) {
                con.commit();
            }
            this.commitState();
            this.sentStoredEvent();
            Object var5_2 = null;
            try {
                if (con != null) {
                    con.close();
                    con = null;
                }
                break block12;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            break block12;
            {
                catch (Exception e) {
                    this.log_.error((Object)e);
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex) {
                        this.log_.error((Object)ex);
                        throw new CardException((Throwable)ex);
                    }
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                try {
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw throwable;
            }
        }
    }

    private void sentStoredEvent() {
        int size = this.listeners_.size();
        if (size == 0) {
            return;
        }
        DAOStoredEvent event = new DAOStoredEvent((IDAO)this);
        for (int i = 0; i < size; ++i) {
            IDAOListener lst = (IDAOListener)this.listeners_.get(i);
            lst.objectStored(event);
        }
    }

    private void updateChildrenState(Connection con) throws Exception {
        ArrayList children = this.getChildren();
        if (children != null) {
            int j = children.size();
            for (int i = 0; i < j; ++i) {
                DAO obj = (DAO)children.get(i);
                obj.updateState(con);
            }
        }
    }

    protected void updateState(Connection con) throws Exception {
        if (this.state_ == 0) {
            this.insert(con);
        } else if (this.state_ == 2) {
            this.update(con);
        } else if (this.state_ == 3) {
            this.delete(con);
        }
        this.updateChildrenState(con);
    }

    protected Date checkMaxSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date.getTime() > 253402253999000L) {
            return new Date(253402253999000L);
        }
        return date;
    }

    protected abstract void insert(Connection var1) throws Exception;

    protected abstract void update(Connection var1) throws Exception;

    protected abstract void delete(Connection var1) throws Exception;

    protected abstract ArrayList getChildren();

    public synchronized void addListener(IDAOListener listener) {
        if (!this.listeners_.contains(listener)) {
            this.listeners_.add(listener);
        }
    }

    public void removeListener(IDAOListener listener) {
        this.listeners_.remove(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

