/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCardClaim;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard;

public class DaoPCardClaim
extends DAO
implements IDaoPCardClaim {
    private Log log_ = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DaoPCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DaoPCard = DaoPCardClaim.class$("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard")) : class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DaoPCard));
    private static final Hashtable typeToId_ = SelfIssuedCardClaims.getSupportedTypesHash();
    private static final Hashtable idToType_ = new Hashtable();
    private int typeIndex_ = -1;
    private String type_ = null;
    private String value_ = null;
    private DaoPCard card_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$db$mysql$DaoPCard;

    public DaoPCardClaim(DaoPCard card) {
        this.state_ = 0;
        this.connectionFactory_ = card.getConnectionFactory();
        this.card_ = card;
    }

    public DaoPCardClaim(DaoPCard card, ResultSet rs, Connection con) throws SQLException, CardException {
        this.state_ = 1;
        this.connectionFactory_ = card.getConnectionFactory();
        this.card_ = card;
        this.init(rs, con);
    }

    private void init(ResultSet rs, Connection con) throws SQLException, CardException {
        this.id_ = rs.getInt("id_");
        this.typeIndex_ = rs.getInt("claimTypeID_");
        this.value_ = rs.getString("claimValue_");
        String id = String.valueOf(this.typeIndex_);
        if (!idToType_.containsKey(id)) {
            throw new CardException("Can not find claim type in dictionary by id = " + id);
        }
        this.type_ = (String)idToType_.get(id);
    }

    protected ArrayList getChildren() {
        return null;
    }

    public int getCardID() {
        return this.card_.getID();
    }

    public String getType() {
        return this.type_;
    }

    public int getTypeID() {
        return this.typeIndex_;
    }

    public String getValue() {
        return this.value_;
    }

    public void setType(String type) throws CardException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        if (typeToId_.containsKey(type)) {
            String id = (String)typeToId_.get(type);
            try {
                this.typeIndex_ = Integer.parseInt(id);
            }
            catch (NumberFormatException e) {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
        } else {
            throw new CardException("SelfSigned card does not support claim value type = " + type);
        }
        this.type_ = type;
    }

    public void setValue(String value) throws CardException {
        this.value_ = value;
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(Connection con) throws Exception {
        String query = "DELETE FROM PersonalCardClaim WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, this.id_);
            ps.execute();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e) {
            this.log_.error((Object)e);
        }
    }

    /*
     * Loose catch block
     */
    protected void insert(Connection con) throws Exception {
        block19: {
            if (this.typeIndex_ == -1) {
                throw new CardException("Can not store PersonalCardClaim because its type of claim undefined.");
            }
            if (this.value_ == null || this.value_.trim().length() == 0) {
                this.log_.info((Object)("Claim value with type = " + this.type_ + " was skipped because its value is empty."));
                return;
            }
            int cardID = this.card_.getID();
            if (cardID == -1) {
                throw new CardException("Can not store PersonalCardClaim for non-stored ICard.");
            }
            String query = "INSERT INTO PersonalCardClaim (cardID_, claimTypeID_, claimValue_) VALUES (?, ?, ?)";
            PreparedStatement ps = null;
            ResultSet rs = null;
            ps = con.prepareStatement(query, 1);
            ps.setInt(1, cardID);
            ps.setInt(2, this.typeIndex_);
            ps.setString(3, this.value_);
            ps.execute();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new CardException("Prepared statement did not return primary key for inserted row.");
            }
            this.id_ = rs.getInt(1);
            Object var8_6 = null;
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                break block19;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            break block19;
            {
                catch (SQLException e) {
                    this.log_.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                try {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Connection con) throws Exception {
        String query = "UPDATE PersonalCardClaim SET claimValue_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, this.value_);
            ps.setInt(2, this.id_);
            ps.execute();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
        catch (SQLException e) {
            this.log_.error((Object)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Enumeration keys = typeToId_.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = typeToId_.get(key);
            idToType_.put(val, key);
        }
    }
}

