/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.db.DAOStoredEvent;
import org.eclipse.higgins.icard.provider.cardspace.db.IConnectionFactory;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAO;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAOListener;

public abstract class DAO
implements IDAO {
    private Log log_;
    private static final long maxMySQLDate_ = 253402253999000L;
    protected int state_;
    protected int id_;
    protected IConnectionFactory connectionFactory_;
    protected Vector listeners_;
    static /* synthetic */ Class class$0;

    public DAO() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log_ = LogFactory.getLog((Class)clazz);
        this.state_ = 0;
        this.id_ = -1;
        this.connectionFactory_ = null;
        this.listeners_ = new Vector();
    }

    private void commitChildrenState() {
        ArrayList children = this.getChildren();
        if (children != null) {
            int i = 0;
            int j = children.size();
            while (i < j) {
                DAO obj = (DAO)children.get(i);
                obj.commitState();
                ++i;
            }
        }
    }

    protected void commitState() {
        switch (this.state_) {
            case 0: {
                if (this.id_ == -1) break;
                this.state_ = 1;
                break;
            }
            case 2: {
                this.state_ = 1;
                break;
            }
            case 4: {
                this.state_ = 5;
                break;
            }
            case 3: {
                this.state_ = 5;
            }
        }
        this.commitChildrenState();
    }

    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory_;
    }

    public int getID() {
        return this.id_;
    }

    public int getState() {
        return this.state_;
    }

    public boolean isChanged() {
        return this.state_ == 0 || this.state_ == 2 || this.state_ == 3;
    }

    protected void setChanged() throws CardException {
        if (this.state_ == 4 || this.state_ == 3) {
            throw new CardException("Can not change data for predeleted object.");
        }
        if (this.state_ == 5) {
            throw new CardException("Can not change data for deleted object.");
        }
        if (this.state_ == 1) {
            this.state_ = 2;
        }
    }

    public void setDeleteState() {
        ArrayList children;
        if (this.state_ == 0) {
            this.state_ = 4;
        }
        if (this.state_ == 1 || this.state_ == 2) {
            this.state_ = 3;
        }
        if ((children = this.getChildren()) != null) {
            int i = 0;
            int j = children.size();
            while (i < j) {
                DAO obj = (DAO)children.get(i);
                obj.setDeleteState();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store() throws CardException {
        Connection con = null;
        try {
            try {
                con = this.getConnectionFactory().getConnection();
                this.updateState(con);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
                this.commitState();
                this.sentStoredEvent();
            }
            catch (Exception e) {
                this.log_.error((Object)e);
                try {
                    con.rollback();
                    throw new CardException((Throwable)e);
                }
                catch (SQLException ex) {
                    this.log_.error((Object)ex);
                    throw new CardException((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (con == null) throw throwable;
                con.close();
                con = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (con == null) return;
        con.close();
    }

    private void sentStoredEvent() {
        int size = this.listeners_.size();
        if (size == 0) {
            return;
        }
        DAOStoredEvent event = new DAOStoredEvent((IDAO)this);
        int i = 0;
        while (i < size) {
            IDAOListener lst = (IDAOListener)this.listeners_.get(i);
            lst.objectStored(event);
            ++i;
        }
    }

    private void updateChildrenState(Connection con) throws Exception {
        ArrayList children = this.getChildren();
        if (children != null) {
            int i = 0;
            int j = children.size();
            while (i < j) {
                DAO obj = (DAO)children.get(i);
                obj.updateState(con);
                ++i;
            }
        }
    }

    protected void updateState(Connection con) throws Exception {
        if (this.state_ == 0) {
            this.insert(con);
        } else if (this.state_ == 2) {
            this.update(con);
        } else if (this.state_ == 3) {
            this.delete(con);
        }
        this.updateChildrenState(con);
    }

    protected Date checkMaxSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date.getTime() > 253402253999000L) {
            return new Date(253402253999000L);
        }
        return date;
    }

    protected abstract void insert(Connection var1) throws Exception;

    protected abstract void update(Connection var1) throws Exception;

    protected abstract void delete(Connection var1) throws Exception;

    protected abstract ArrayList getChildren();

    public synchronized void addListener(IDAOListener listener) {
        if (!this.listeners_.contains(listener)) {
            this.listeners_.add(listener);
        }
    }

    public void removeListener(IDAOListener listener) {
        this.listeners_.remove(listener);
    }
}

