/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAO;
import org.eclipse.higgins.icard.provider.cardspace.db.IDAOListener;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoInformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCard;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCardClaim;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.CardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoInformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCardClaim;

public class DaoPCard
extends DAO
implements IDaoPCard {
    private Log log_;
    protected CardContext context_;
    protected String userID_;
    protected String cardID_;
    protected String language_;
    protected String name_;
    protected int version_;
    protected byte[] image_;
    protected byte[] issuerID_;
    protected String imageType_;
    protected Date timeIssued_;
    protected Date timeExpires_;
    protected Date timeLastUpdated_;
    protected byte[] hashSalt_;
    protected byte[] masterKey_;
    protected byte[] pinDigest_;
    protected byte[] initialImage_;
    protected String initialName_;
    protected String initialImageType_;
    protected byte[] initialMasterKey_;
    protected byte[] initialPinDigest_;
    protected ArrayList claimValues_;
    protected Hashtable claimValuesHash_;
    protected ArrayList extensionList_;
    static /* synthetic */ Class class$0;

    public DaoPCard(CardContext context, String userID) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log_ = LogFactory.getLog((Class)clazz);
        this.cardID_ = null;
        this.language_ = null;
        this.name_ = null;
        this.version_ = 0;
        this.image_ = null;
        this.issuerID_ = null;
        this.imageType_ = null;
        this.timeIssued_ = null;
        this.timeExpires_ = null;
        this.timeLastUpdated_ = null;
        this.hashSalt_ = null;
        this.masterKey_ = null;
        this.pinDigest_ = null;
        this.initialImage_ = null;
        this.initialName_ = null;
        this.initialImageType_ = null;
        this.initialMasterKey_ = null;
        this.initialPinDigest_ = null;
        this.claimValues_ = new ArrayList();
        this.claimValuesHash_ = new Hashtable();
        this.extensionList_ = new ArrayList();
        this.state_ = 0;
        this.userID_ = userID;
        this.context_ = context;
        this.connectionFactory_ = context.getConnectionFactory();
        this.addListener((IDAOListener)context);
    }

    public DaoPCard(CardContext context, String userID, ResultSet rs, Connection con) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log_ = LogFactory.getLog((Class)clazz);
        this.cardID_ = null;
        this.language_ = null;
        this.name_ = null;
        this.version_ = 0;
        this.image_ = null;
        this.issuerID_ = null;
        this.imageType_ = null;
        this.timeIssued_ = null;
        this.timeExpires_ = null;
        this.timeLastUpdated_ = null;
        this.hashSalt_ = null;
        this.masterKey_ = null;
        this.pinDigest_ = null;
        this.initialImage_ = null;
        this.initialName_ = null;
        this.initialImageType_ = null;
        this.initialMasterKey_ = null;
        this.initialPinDigest_ = null;
        this.claimValues_ = new ArrayList();
        this.claimValuesHash_ = new Hashtable();
        this.extensionList_ = new ArrayList();
        this.state_ = 1;
        this.userID_ = userID;
        this.context_ = context;
        this.connectionFactory_ = context.getConnectionFactory();
        this.addListener((IDAOListener)context);
        this.init(rs, con);
    }

    public void init(ResultSet rs, Connection con) throws Exception {
        this.id_ = rs.getInt("id_");
        this.cardID_ = rs.getString("cardID_");
        this.language_ = rs.getString("language_");
        this.initialName_ = this.name_ = rs.getString("name_");
        this.version_ = rs.getInt("version_");
        this.image_ = rs.getBytes("image_");
        this.initialImage_ = this.image_;
        this.initialImageType_ = this.imageType_ = rs.getString("imageType_");
        this.timeIssued_ = rs.getDate("timeIssued_");
        this.timeExpires_ = rs.getDate("timeExpires_");
        this.timeLastUpdated_ = rs.getDate("timeLastUpdated_");
        this.hashSalt_ = rs.getBytes("hashSalt_");
        this.masterKey_ = rs.getBytes("masterKey_");
        this.initialMasterKey_ = this.masterKey_;
        this.pinDigest_ = rs.getBytes("pinDigest_");
        this.initialPinDigest_ = this.pinDigest_;
        this.issuerID_ = rs.getBytes("issuerID_");
        this.updateInitialValues();
        this.initClaimValueList(con);
        this.initExtensionList(con);
    }

    public int getState() {
        return this.state_;
    }

    public String getCardID() {
        return this.cardID_;
    }

    public byte[] getHashSalt() {
        return this.hashSalt_;
    }

    public int getID() {
        return this.id_;
    }

    public byte[] getImage() {
        return this.image_;
    }

    public String getImageType() {
        return this.imageType_;
    }

    public String getLanguage() {
        return this.language_;
    }

    public byte[] getMasterKey() {
        return this.masterKey_;
    }

    public String getName() {
        return this.name_;
    }

    public Date getTimeExpires() {
        return this.timeExpires_;
    }

    public Date getTimeIssued() {
        return this.timeIssued_;
    }

    public Date getTimeLastUpdated() {
        return this.timeLastUpdated_;
    }

    public byte[] getPinDigest() {
        return this.pinDigest_;
    }

    public int getVersion() {
        return this.version_;
    }

    public void setCardID(String cardID) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.cardID_ = cardID;
    }

    public void setHashSalt(byte[] hashSalt) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.hashSalt_ = hashSalt;
    }

    public void setImage(byte[] image) throws CardException {
        this.image_ = image;
        this.setChanged();
    }

    public void setImageType(String imageType) throws CardException {
        this.imageType_ = imageType;
        this.setChanged();
    }

    public void setLanguage(String language) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.language_ = language;
    }

    public void setMasterKey(byte[] masterKey) throws CardException {
        this.masterKey_ = masterKey;
        this.setChanged();
    }

    public void setName(String name) throws CardException {
        this.name_ = name;
        this.setChanged();
    }

    public void setTimeExpires(Date timeExpires) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.timeExpires_ = this.checkMaxSQLDate(timeExpires);
    }

    public void setTimeIssued(Date timeIssued) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.timeIssued_ = timeIssued;
    }

    public void setTimeLastUpdated(Date timeLastUpdated) throws InvalidStateException {
        this.timeLastUpdated_ = timeLastUpdated;
    }

    public void setPinDigest(byte[] pinDigest) throws CardException {
        this.pinDigest_ = pinDigest;
        this.setChanged();
    }

    public void setVersion(int version) throws InvalidStateException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.version_ = version;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insert(Connection con) throws Exception {
        block14: {
            query = "INSERT INTO PersonalCard (cardID_, language_, name_, version_, image_, imageType_, timeIssued_, timeExpires_, timeLastUpdated_, hashSalt_, masterKey_, pinDigest_, userID_, issuerID_) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query, 1);
                    ps.setString(1, this.cardID_);
                    ps.setString(2, this.language_);
                    ps.setString(3, this.name_);
                    ps.setInt(4, this.version_);
                    ps.setBytes(5, this.image_);
                    ps.setString(6, this.imageType_);
                    ps.setDate(7, this.timeIssued_);
                    ps.setDate(8, this.timeExpires_);
                    ps.setDate(9, this.timeLastUpdated_);
                    ps.setBytes(10, this.hashSalt_);
                    ps.setBytes(11, this.masterKey_);
                    ps.setBytes(12, this.pinDigest_);
                    ps.setString(13, this.userID_);
                    ps.setBytes(14, this.issuerID_);
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                    this.id_ = rs.getInt(1);
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                try {
                    if (ps == null) throw var7_6;
                    ps.close();
                    ps = null;
                    throw var7_6;
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 265->283)] { 
lbl51:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block14;
lbl55:
            // 1 sources

            catch (SQLException e) {
                this.log_.error((Object)e);
            }
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    protected void update(Connection con) throws SQLException {
        this.updateName(con);
        this.updateImage(con);
        this.updateImageType(con);
        this.updatePinDigest(con);
        this.updateMasterKey(con);
        this.updateTimeLastUpdated(con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateName(Connection con) throws SQLException {
        if (this.initialName_ == null && this.name_ == null) {
            return;
        }
        String n1 = this.initialName_ == null ? "" : this.initialName_;
        String n2 = this.name_ == null ? "" : this.name_;
        if (n1.equals(n2)) return;
        String query = "UPDATE PersonalCard SET name_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, this.name_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateImage(Connection con) throws SQLException {
        if (Arrays.equals(this.initialImage_, this.image_)) {
            return;
        }
        String query = "UPDATE PersonalCard SET image_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, this.image_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateImageType(Connection con) throws SQLException {
        if (this.initialImageType_ == null && this.imageType_ == null) {
            return;
        }
        String n1 = this.initialImageType_ == null ? "" : this.initialImageType_;
        String n2 = this.imageType_ == null ? "" : this.imageType_;
        if (n1.equals(n2)) return;
        String query = "UPDATE PersonalCard SET imageType_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, this.imageType_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateTimeLastUpdated(Connection con) throws SQLException {
        String query = "UPDATE PersonalCard SET timeLastUpdated_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setDate(1, this.timeLastUpdated_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateMasterKey(Connection con) throws SQLException {
        if (Arrays.equals(this.masterKey_, this.initialMasterKey_)) {
            return;
        }
        String query = "UPDATE PersonalCard SET masterKey_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, this.masterKey_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updatePinDigest(Connection con) throws SQLException {
        if (Arrays.equals(this.pinDigest_, this.initialPinDigest_)) {
            return;
        }
        String query = "UPDATE PersonalCard SET pinDigest_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setBytes(1, this.pinDigest_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete(Connection con) throws SQLException {
        String query = "DELETE FROM PersonalCard WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    public ArrayList getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.claimValues_);
        children.addAll(this.extensionList_);
        return children;
    }

    public void addPersonalCardClaim(IDaoPCardClaim personalCardClaim) throws CardException {
        if (personalCardClaim == null) {
            throw new CardException("Parameter \"personalCardClaim\" is null.");
        }
        String type = personalCardClaim.getType();
        if (this.claimValuesHash_.containsKey(type)) {
            throw new CardException("There already exists claim value with type = " + type);
        }
        this.claimValues_.add(personalCardClaim);
        this.claimValuesHash_.put(type, personalCardClaim);
        this.setChanged();
    }

    public IDaoPCardClaim createPersonalCardClaim() {
        return new DaoPCardClaim(this);
    }

    public IDaoPCardClaim getPersonalCardClaim(String type) {
        if (type == null) {
            return null;
        }
        if (this.claimValuesHash_.containsKey(type)) {
            return (IDaoPCardClaim)this.claimValuesHash_.get(type);
        }
        return null;
    }

    public ArrayList getPersonalCardClaimList() {
        return this.claimValues_;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initClaimValueList(Connection con) throws SQLException, CardException {
        block13: {
            this.claimValues_.clear();
            this.claimValuesHash_.clear();
            query = "SELECT * FROM PersonalCardClaim WHERE cardID_ = ?";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, this.id_);
                rs = ps.executeQuery();
                while (rs.next()) {
                    cc = new DaoPCardClaim(this, rs, con);
                    this.claimValues_.add(cc);
                    this.claimValuesHash_.put(cc.getType(), cc);
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                try {
                    if (ps == null) throw var7_6;
                    ps.close();
                    ps = null;
                    throw var7_6;
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 114->132)] { 
lbl39:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl43:
            // 1 sources

            catch (SQLException e) {
                this.log_.error((Object)e);
            }
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initExtensionList(Connection con) throws SQLException {
        block13: {
            this.extensionList_.clear();
            query = "SELECT * FROM PCardExtension WHERE cardID_ = ?";
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement(query);
                ps.setInt(1, this.id_);
                rs = ps.executeQuery();
                while (rs.next()) {
                    ts = new DaoInformationCardExtension(this, rs, con);
                    this.extensionList_.add(ts);
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                try {
                    if (ps == null) throw var7_6;
                    ps.close();
                    ps = null;
                    throw var7_6;
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 92->110)] { 
lbl36:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block13;
lbl40:
            // 1 sources

            catch (SQLException e) {
                this.log_.error((Object)e);
            }
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    private void removeDeletedExtensions() {
        ArrayList<IDAO> deleted = new ArrayList<IDAO>();
        int i = 0;
        int j = this.extensionList_.size();
        while (i < j) {
            IDAO obj = (IDAO)this.extensionList_.get(i);
            if (obj.getState() == 5) {
                deleted.add(obj);
            }
            ++i;
        }
        this.extensionList_.removeAll(deleted);
    }

    private void removeDeletedClaims() {
        ArrayList<IDaoPCardClaim> deletedClaims = new ArrayList<IDaoPCardClaim>();
        int i = 0;
        int j = this.claimValues_.size();
        while (i < j) {
            IDaoPCardClaim claim = (IDaoPCardClaim)this.claimValues_.get(i);
            if (claim.getState() == 5) {
                deletedClaims.add(claim);
                this.claimValuesHash_.remove(claim.getType());
            }
            ++i;
        }
        this.claimValues_.removeAll(deletedClaims);
    }

    private void updateInitialValues() {
        this.initialName_ = this.name_;
        this.initialImage_ = this.image_;
        this.initialImageType_ = this.imageType_;
        this.initialMasterKey_ = this.masterKey_;
        this.initialPinDigest_ = this.pinDigest_;
    }

    public void commitState() {
        super.commitState();
        this.removeDeletedClaims();
        this.removeDeletedExtensions();
        this.updateInitialValues();
    }

    public String getUserID() {
        return this.userID_;
    }

    public byte[] getIssuerID() {
        return this.issuerID_;
    }

    public void setIssuerID(byte[] issuerID) throws CardException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        this.issuerID_ = issuerID;
    }

    public void addInformationCardExtension(IDaoInformationCardExtension extension) throws CardException {
        if (extension == null) {
            throw new CardException("Parameter \"extension\" is null.");
        }
        this.extensionList_.add(extension);
        this.setChanged();
    }

    public IDaoInformationCardExtension createInformationCardExtension() {
        return new DaoInformationCardExtension(this);
    }

    public ArrayList getExtensions() {
        return this.extensionList_;
    }
}

