/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCardClaim;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DAO;
import org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard;

public class DaoPCardClaim
extends DAO
implements IDaoPCardClaim {
    private Log log_;
    private static final Hashtable typeToId_ = SelfIssuedCardClaims.getSupportedTypesHash();
    private static final Hashtable idToType_ = new Hashtable();
    private int typeIndex_;
    private String type_;
    private String value_;
    private DaoPCard card_;
    static /* synthetic */ Class class$0;

    static {
        Enumeration keys = typeToId_.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = typeToId_.get(key);
            idToType_.put(val, key);
        }
    }

    public DaoPCardClaim(DaoPCard card) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log_ = LogFactory.getLog((Class)clazz);
        this.typeIndex_ = -1;
        this.type_ = null;
        this.value_ = null;
        this.card_ = null;
        this.state_ = 0;
        this.connectionFactory_ = card.getConnectionFactory();
        this.card_ = card;
    }

    public DaoPCardClaim(DaoPCard card, ResultSet rs, Connection con) throws SQLException, CardException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.db.mysql.DaoPCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log_ = LogFactory.getLog((Class)clazz);
        this.typeIndex_ = -1;
        this.type_ = null;
        this.value_ = null;
        this.card_ = null;
        this.state_ = 1;
        this.connectionFactory_ = card.getConnectionFactory();
        this.card_ = card;
        this.init(rs, con);
    }

    private void init(ResultSet rs, Connection con) throws SQLException, CardException {
        this.id_ = rs.getInt("id_");
        this.typeIndex_ = rs.getInt("claimTypeID_");
        this.value_ = rs.getString("claimValue_");
        String id = String.valueOf(this.typeIndex_);
        if (!idToType_.containsKey(id)) {
            throw new CardException("Can not find claim type in dictionary by id = " + id);
        }
        this.type_ = (String)idToType_.get(id);
    }

    protected ArrayList getChildren() {
        return null;
    }

    public int getCardID() {
        return this.card_.getID();
    }

    public String getType() {
        return this.type_;
    }

    public int getTypeID() {
        return this.typeIndex_;
    }

    public String getValue() {
        return this.value_;
    }

    public void setType(String type) throws CardException {
        if (this.id_ != -1) {
            throw new InvalidStateException("Unsupported operation for existent card");
        }
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        if (typeToId_.containsKey(type)) {
            String id = (String)typeToId_.get(type);
            try {
                this.typeIndex_ = Integer.parseInt(id);
            }
            catch (NumberFormatException e) {
                this.log_.error((Object)e);
                throw new CardException((Throwable)e);
            }
        } else {
            throw new CardException("SelfSigned card does not support claim value type = " + type);
        }
        this.type_ = type;
    }

    public void setValue(String value) throws CardException {
        this.value_ = value;
        this.setChanged();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete(Connection con) throws Exception {
        String query = "DELETE FROM PersonalCardClaim WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setInt(1, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insert(Connection con) throws Exception {
        block17: {
            if (this.typeIndex_ == -1) {
                throw new CardException("Can not store PersonalCardClaim because its type of claim undefined.");
            }
            if (this.value_ == null || this.value_.trim().length() == 0) {
                this.log_.info((Object)("Claim value with type = " + this.type_ + " was skipped because its value is empty."));
                return;
            }
            cardID = this.card_.getID();
            if (cardID == -1) {
                throw new CardException("Can not store PersonalCardClaim for non-stored ICard.");
            }
            query = "INSERT INTO PersonalCardClaim (cardID_, claimTypeID_, claimValue_) VALUES (?, ?, ?)";
            ps = null;
            rs = null;
            try {
                try {
                    ps = con.prepareStatement(query, 1);
                    ps.setInt(1, cardID);
                    ps.setInt(2, this.typeIndex_);
                    ps.setString(3, this.value_);
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    if (rs.next() == false) throw new CardException("Prepared statement did not return primary key for inserted row.");
                    this.id_ = rs.getInt(1);
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                try {
                    if (ps == null) throw var8_7;
                    ps.close();
                    ps = null;
                    throw var8_7;
                }
                catch (SQLException e) {
                    this.log_.error((Object)e);
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 237->255)] { 
lbl48:
            // 1 sources

            if (rs != null) {
                rs.close();
                rs = null;
            }
            break block17;
lbl52:
            // 1 sources

            catch (SQLException e) {
                this.log_.error((Object)e);
            }
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(Connection con) throws Exception {
        String query = "UPDATE PersonalCardClaim SET claimValue_ = ? WHERE id_ = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(query);
            ps.setString(1, this.value_);
            ps.setInt(2, this.id_);
            ps.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                ps = null;
                throw throwable;
            }
            catch (SQLException e) {
                this.log_.error((Object)e);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException e) {
            this.log_.error((Object)e);
            return;
        }
        if (ps == null) return;
        ps.close();
    }
}

