/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoCard;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoInformationCardExtension;

public class DaoInformationCardExtension extends DAO implements IDaoInformationCardExtension {

	public static final String PCARD_EXTENSION_TABLE_NAME = "PCardExtension";

	public static final String MCARD_EXTENSION_TABLE_NAME = "MCardExtension";

	private String tableName = null;

	private Log log_ = LogFactory.getLog(DaoInformationCardExtension.class);

	private String element_ = null;

	private boolean enabled_ = true;

	private IDaoCard card_ = null;


	public DaoInformationCardExtension(DaoPCard card) {
		tableName = PCARD_EXTENSION_TABLE_NAME;
		state_ = NEW_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
	}

	public DaoInformationCardExtension(DaoPCard card, ResultSet rs, Connection con) throws SQLException {
		tableName = PCARD_EXTENSION_TABLE_NAME;
		state_ = STORED_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
		init(rs, con);
	}

	public DaoInformationCardExtension(DaoMCard card) {
		tableName = MCARD_EXTENSION_TABLE_NAME;
		state_ = NEW_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
	}

	public DaoInformationCardExtension(DaoMCard card, ResultSet rs, Connection con) throws SQLException {
		tableName = MCARD_EXTENSION_TABLE_NAME;
		state_ = STORED_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
		init(rs, con);
	}

	private void init(ResultSet rs, Connection con) throws SQLException {
		id_ = rs.getInt("id_");
		element_ = rs.getString("element_");
		enabled_ = rs.getBoolean("enabled_");
	}

	public int getCardID() {
		return card_.getID();
	}

	public String getElement() {
		return element_;
	}

	public void setElement(String element) throws CardException {
		element_ = element;
		setChanged();
	}

	public boolean isEnabled() {
		return enabled_;
	}

	public void setEnabled(boolean enabled) throws CardException {
		enabled_ = enabled;
		setChanged();
	}

	protected void delete(Connection con) throws Exception {
		String query = "DELETE FROM " + tableName + " WHERE id_ = ?";
		PreparedStatement ps = null;
		try {
			ps = con.prepareStatement(query);
			ps.setInt(1, id_);
			ps.execute();
		} finally {
			try {
				if (ps != null) {
					ps.close();
					ps = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
		}
	}

	protected void insert(Connection con) throws Exception {
		if (element_ == null || element_.length() == 0) {
			log_.info("Extension was skipped because its element is null.");
			return;
		}
		int cardID = card_.getID();
		if (cardID == -1)
			throw new CardException("Can not store " + this.getClass().getName() + " for non-stored ICard.");
		String query = "INSERT INTO " + tableName + " (cardID_, element_, enabled_) VALUES (?, ?, ?)";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = con.prepareStatement(query, Statement.RETURN_GENERATED_KEYS);
			ps.setInt(1, cardID);
			ps.setString(2, element_);
			ps.setBoolean(3, enabled_);
			ps.execute();
			rs = ps.getGeneratedKeys();
			if (rs.next()) {
				id_ = rs.getInt(1);
			} else
				throw new CardException("Prepared statement did not return primary key for inserted row.");
		} catch (SQLException e) {
			log_.error(e);
			throw new CardException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
			try {
				if (ps != null) {
					ps.close();
					ps = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
		}
	}

	protected void update(Connection con) throws Exception {
		String query = "UPDATE " + tableName + " SET element_ = ?, enabled_ = ? WHERE id_ = ?";
		PreparedStatement ps = null;
		try {
			ps = con.prepareStatement(query);
			ps.setString(1, element_);
			ps.setBoolean(2, enabled_);
			ps.setInt(3, id_);
			ps.execute();
		} finally {
			try {
				if (ps != null) {
					ps.close();
					ps = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
		}
	}

	protected ArrayList getChildren() {
		return null;
	}

}
