/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.db.IConnectionFactory;

public class ConnectionFactory implements IConnectionFactory {
	protected Log log_ = LogFactory.getLog(ConnectionFactory.class);

	protected boolean isPoolUsed_;

	protected DataSource dataSource_;

	protected String driverName_;

	protected String userName_;

	protected String password_;

	protected String url_;

	protected String contextName_;

	protected String sourceName_;

	/**
	 * Factory for direct (non-pooled) connections
	 * 
	 * @param driverName
	 * @param userName
	 * @param password
	 * @param url
	 * @throws CardException
	 * @throws ClassNotFoundException
	 */
	public ConnectionFactory(String driverName, String userName, String password, String url) throws CardException {
		log_.trace("org.eclipse.higgins.icard.provider.cardspace.managed.db.dao.ConnectionFactory() (no pool)");
		log_.debug("driverName = " + driverName + ", userName = " + userName + ", password = " + password + ", url = "
		        + url);
		isPoolUsed_ = false;
		driverName_ = driverName;
		userName_ = userName;
		password_ = password;
		url_ = url;
		try {
			Class.forName(driverName_);
		} catch (ClassNotFoundException e) {
			log_.error(e);
			throw new CardException(e);
		}
	}

	/**
	 * Factory for pooled connections
	 * 
	 * @param driverName
	 * @param userName
	 * @param password
	 * @param url
	 * @param contextName
	 * @param sourceName
	 * @throws NamingException
	 * @throws CardException
	 */
	public ConnectionFactory(String contextName, String sourceName) throws CardException {
		log_.trace("org.eclipse.higgins.icard.provider.cardspace.managed.db.dao.ConnectionFactory() (pool)");
		log_.debug("context name = " + contextName + ",dataSource name " + sourceName);
		isPoolUsed_ = true;
		contextName_ = contextName;
		sourceName_ = sourceName;
		try {
			Context init = new InitialContext();
			Context ctx = (Context) init.lookup(contextName);
			if (ctx == null)
				throw new CardException("Can not find context by name = " + contextName_);
			dataSource_ = (DataSource) ctx.lookup(sourceName);
			if (dataSource_ == null)
				throw new CardException("Can not find DataSource by name = " + sourceName_);
		} catch (NamingException e) {
			log_.error(e);
			throw new CardException(e);
		}
	}

	public Connection getConnection() throws SQLException {
		Connection con = null;
		if (isPoolUsed_)
			con = dataSource_.getConnection();
		else
			con = DriverManager.getConnection(url_, userName_, password_);
		con.setAutoCommit(false);
		return con;
	}

}
