/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoTokenService;

public class TokenService extends DAO implements IDaoTokenService {
	private Log log_ = LogFactory.getLog(TokenService.class);

	protected DaoMCard card_ = null;

	protected String endpointAddress_ = null;

	protected String hint_ = null;

	protected String identity_ = null;

	protected String credential_ = null;

	protected String metadata_ = null;

	
	public TokenService(DaoMCard card) {
		state_ = NEW_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
	}

	public TokenService(DaoMCard card, ResultSet rs, Connection con) throws SQLException {
		state_ = STORED_OBJ;
		connectionFactory_ = card.getConnectionFactory();
		card_ = card;
		init(rs, con);
	}

	private void init(ResultSet rs, Connection con) throws SQLException {
		id_ = rs.getInt("id_");
		endpointAddress_ = rs.getString("endpointAddress_");
		hint_ = rs.getString("hint_");
		identity_ = rs.getString("identity_");
		credential_ = rs.getString("credential_");
		metadata_ = rs.getString("metadata_");
	}

	public int getCardID() {
		return card_.getID();
	}

	public String getEndpointAddress() {
		return endpointAddress_;
	}

	public String getCredential() {
		return credential_;
	}

	public String getIdentity() {
		return identity_;
	}

	public String getMetadata() {
		return metadata_;
	}

	public String getHint() {
		return hint_;
	}

	public int getID() {
		return id_;
	}

	public void setEndpointAddress(String endpointAddress) throws CardException {
		if (id_ != -1)
			throw new InvalidStateException("Unsupported operation for existent card");
		endpointAddress_ = endpointAddress;
	}

	public void setHint(String hint) throws CardException {
		if (id_ != -1)
			throw new InvalidStateException("Unsupported operation for existent card");
		hint_ = hint;
	}

	public void setIdentity(String identity) throws CardException {
		if (id_ != -1)
			throw new InvalidStateException("Unsupported operation for existent card");
		identity_ = identity;
	}

	public void setMetadata(String metadata) throws CardException {
		if (id_ != -1)
			throw new InvalidStateException("Unsupported operation for existent card");
		metadata_ = metadata;
	}

	public void setCredential(String credential) throws CardException {
		if (id_ != -1)
			throw new InvalidStateException("Unsupported operation for existent card");
		credential_ = credential;
	}

	private void insertTokenService(int cardID, Connection con) throws Exception {
		String query = "INSERT INTO TokenService (cardID_, endpointAddress_, hint_, identity_, credential_, metadata_) VALUES (?, ?, ?, ?, ?, ?)";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = con.prepareStatement(query, Statement.RETURN_GENERATED_KEYS);
			ps.setInt(1, cardID);
			ps.setString(2, endpointAddress_);
			ps.setString(3, hint_);
			ps.setString(4, identity_);
			ps.setString(5, credential_);
			ps.setString(6, metadata_);
			ps.execute();
			rs = ps.getGeneratedKeys();
			if (rs.next())
				id_ = rs.getInt(1);
			else
				throw new CardException("Prepared statement did not return primary key for inserted row.");
		} catch (SQLException e) {
			log_.error(e);
			throw new CardException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
			try {
				if (ps != null) {
					ps.close();
					ps = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
		}

	}

	protected void delete(Connection con) throws Exception {
		String query = "DELETE FROM TokenService WHERE id_ = ?";
		PreparedStatement ps = null;
		try {
			ps = con.prepareStatement(query);
			ps.setInt(1, id_);
			ps.execute();
		} finally {
			try {
				if (ps != null) {
					ps.close();
					ps = null;
				}
			} catch (SQLException e) {
				log_.error(e);
			}
		}
	}

	protected ArrayList getChildren() {
		return null;
	}

	protected void insert(Connection con) throws Exception {
		int cardID = card_.getID();
		if (cardID == -1)
			throw new CardException("Can not store TokenService for non-stored ICard.");
		else
			insertTokenService(cardID, con);
	}

	protected void update(Connection con) throws Exception {
	}

}
