/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import java.util.ArrayList;
import java.util.Map;

import org.eclipse.higgins.icard.CardException;

/**
 * Responds for connection factory initialization and operations with cards
 * 
 */
public interface ICardContext extends IDAOListener {

	/**
	 * @param config
	 * @throws CardException
	 */
	public void init(Map config) throws CardException;

	/**
	 * @return  
	 */
	public IConnectionFactory getConnectionFactory();

	/**
	 * @param cardURI
	 * @param userID
	 * @return
	 * @throws CardException
	 */
	public IDaoMCard getMCard(String cardURI, String userID) throws CardException;

	/**
	 * @param userID
	 * @return
	 * @throws CardException
	 */
	public ArrayList getMCards(String userID) throws CardException;

	/**
	 * @param userID
	 * @return
	 */
	public IDaoMCard createMCard(String userID);

	/**
	 * @param cardURI
	 * @param userID
	 * @return
	 * @throws CardException
	 */
	public IDaoPCard getPCard(String cardURI, String userID) throws CardException;

	/**
	 * @param userID
	 * @return
	 * @throws CardException
	 */
	public ArrayList getPCards(String userID) throws CardException;

	/**
	 * @param userID
	 * @return
	 */
	public IDaoPCard createPCard(String userID);

}
