/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import java.util.ArrayList;

import org.eclipse.higgins.icard.CardException;

/**
 * DAO interface which represents data of cardspace-compatible personal card
 * (see cardspace techref)
 */
public interface IDaoPCard extends IDaoCard {

	/**
	 * @return
	 */
	public byte[] getPinDigest();

	/**
	 * @param pinDigest
	 * @throws CardException
	 */
	public void setPinDigest(byte[] pinDigest) throws CardException;

	/**
	 * @return
	 */
	public ArrayList getPersonalCardClaimList();

	/**
	 * @param claimType
	 * @return
	 */
	public IDaoPCardClaim getPersonalCardClaim(String claimType);

	/**
	 * @return
	 */
	public IDaoPCardClaim createPersonalCardClaim();

	/**
	 * @param personalCardClaim
	 * @throws CardException
	 */
	public void addPersonalCardClaim(IDaoPCardClaim personalCardClaim) throws CardException;

}
