/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.db;

import org.eclipse.higgins.icard.CardException;

/**
 * Database access object which represents token service of
 * cardspace-compatible managed card (see cardspace techref)
 * 
 */
public interface IDaoTokenService extends IDAO {

	/**
	 * ID of owner DAO card
	 * @return
	 */
	public int getCardID();

	/**
	 * @return
	 */
	public String getEndpointAddress();

	/**
	 * @return
	 */
	public String getHint();

	/**
	 * @return
	 */
	public String getIdentity();

	/**
	 * @return
	 */
	public String getCredential();

	/**
	 * @return
	 */
	public String getMetadata();

	/**
	 * @param endpointAddress
	 * @throws CardException
	 */
	public void setEndpointAddress(String endpointAddress) throws CardException;

	/**
	 * @param hint
	 * @throws CardException
	 */
	public void setHint(String hint) throws CardException;

	/**
	 * @param identity
	 * @throws CardException
	 */
	public void setIdentity(String identity) throws CardException;

	/**
	 * @param credential
	 * @throws CardException
	 */
	public void setCredential(String credential) throws CardException;

	/**
	 * @param metadata
	 * @throws CardException
	 */
	public void setMetadata(String metadata) throws CardException;

}
