/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed.db;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardExtensionEvent;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IExtensionListener;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.XMLHelper;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.db.ICardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoInformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoMCard;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoSupportedClaimType;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoSupportedTokenType;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoTokenService;
import org.eclipse.higgins.icard.provider.cardspace.managed.db.JDBCBasedManagedCardProvider;
import org.w3c.dom.Element;

public class JDBCBasedManagedCard
extends ManagedCard
implements IExtensionListener {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCard = JDBCBasedManagedCard.class$("org.eclipse.higgins.icard.provider.cardspace.managed.db.JDBCBasedManagedCard")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCard));
    private IDaoMCard card_ = null;
    private boolean editMode = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCard;
    static /* synthetic */ Class class$java$lang$String;

    public JDBCBasedManagedCard() {
    }

    public JDBCBasedManagedCard(JDBCBasedManagedCardProvider provider, IDaoMCard card) throws CardException {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.card_ = card;
        this.init();
    }

    public JDBCBasedManagedCard(JDBCBasedManagedCardProvider provider, ICardContext context, String userID, Element card) throws CardException {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.initFromXML(card);
        IDaoMCard oldCard = context.getMCard(this.id_.toString(), userID);
        if (oldCard != null) {
            oldCard.setDeleteState();
        }
        this.card_ = context.createMCard(userID);
        try {
            this.saveCard();
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        if (oldCard != null) {
            oldCard.store();
        }
        this.card_.store();
    }

    public void init() throws CardException {
        this.initIsSelfIssued();
        this.initLanguage();
        this.initCardId();
        this.initCardVersion();
        this.initCardName();
        this.initCardImage();
        this.initCardImageType();
        this.initIssuer();
        this.initIssuerID();
        this.initIssuerName();
        this.initTimeIssued();
        this.initTimeExpires();
        this.initSupportedTokenTypes();
        this.initClaimTypes();
        this.initTokenServiceList();
        this.initRequireAppliesTo();
        this.initPrivacyNotice();
        this.initHashSalt();
        this.initTimeLastUpdated();
        this.initMasterKey();
        this.initExtensions();
        this.initStandardExtensionFields();
    }

    private void initIsSelfIssued() {
        this.isSelfIssued_ = false;
    }

    private void initLanguage() {
        this.language_ = this.card_.getLanguage();
    }

    private void initCardId() throws CardException {
        String id = this.card_.getCardID();
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void initCardVersion() {
        this.version_ = String.valueOf(this.card_.getVersion());
    }

    private void initCardName() {
        this.name_ = this.card_.getName();
    }

    private void initCardImage() {
        this.image_ = this.card_.getImage();
    }

    private void initCardImageType() {
        this.imageMimeType_ = this.card_.getImageType();
    }

    private void initIssuer() {
        this.issuer_ = this.card_.getIssuer();
    }

    private void initIssuerID() {
        this.issuerID_ = this.card_.getIssuerID();
    }

    private void initIssuerName() {
        this.issuerName_ = this.card_.getIssuerName();
    }

    private void initTimeIssued() {
        this.timeIssued_ = this.card_.getTimeIssued();
    }

    private void initTimeExpires() {
        this.timeExpires_ = this.card_.getTimeExpires();
    }

    private void initSupportedTokenTypes() throws CardException {
        this.supportedTokenTypes_ = new ArrayList();
        ArrayList lst = this.card_.getSupportedTokenTypeList();
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            IDaoSupportedTokenType tt = (IDaoSupportedTokenType)lst.get(i);
            try {
                this.supportedTokenTypes_.add(new URI(tt.getType()));
                continue;
            }
            catch (URISyntaxException e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    private void initClaimTypes() throws CardException {
        this.claimTypes_ = new ArrayList();
        ArrayList lst = this.card_.getSupportedClaimTypeList();
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            IDaoSupportedClaimType ct = (IDaoSupportedClaimType)lst.get(i);
            String type = ct.getType();
            String name = ct.getDisplayName();
            String description = ct.getDescription();
            boolean isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type);
            ClaimType claimType = new ClaimType(type, name, description, !isPPID, !isPPID);
            this.claimTypes_.add(claimType);
        }
    }

    private void initTokenServiceList() throws CardException {
        this.tokenServices_ = new ArrayList();
        ArrayList lst = this.card_.getTokenServiceList();
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            CredentialDescriptor credential;
            URI epAddress;
            IDaoTokenService ts = (IDaoTokenService)lst.get(i);
            try {
                epAddress = new URI(ts.getEndpointAddress());
            }
            catch (URISyntaxException e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
            String epMetadata = ts.getMetadata();
            String epIdentity = ts.getIdentity();
            String ucHint = ts.getHint();
            String ucCredential = ts.getCredential();
            EndpointReference endpoint = new EndpointReference(epAddress, epMetadata, epIdentity);
            try {
                credential = new CredentialDescriptor(ucHint, ucCredential);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
            TokenService tc = new TokenService(endpoint, credential);
            this.tokenServices_.add(tc);
        }
    }

    private void initRequireAppliesTo() {
        this.requireAppliesTo_ = this.card_.getRequireAppliesTo();
    }

    private void initPrivacyNotice() throws CardException {
        this.privacyNotice_ = null;
        String obj = this.card_.getPrivacyNotice();
        if (obj != null) {
            this.privacyNotice_ = new STSPrivacyPolicy(obj);
        }
    }

    private void initHashSalt() {
        this.hashSalt_ = this.card_.getHashSalt();
    }

    private void initTimeLastUpdated() {
        this.timeLastUpdated_ = this.card_.getTimeLastUpdated();
    }

    private void initMasterKey() {
        this.masterKey_ = this.card_.getMasterKey();
    }

    private void initExtensions() throws CardException {
        this.extensions_ = new ArrayList();
        ArrayList lst = this.card_.getExtensions();
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            IDaoInformationCardExtension daoExt = (IDaoInformationCardExtension)lst.get(i);
            String elmStr = daoExt.getElement();
            IOElement elm = new IOElement();
            try {
                elm.set((Object)elmStr);
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
            boolean enabled = daoExt.isEnabled();
            InformationCardExtension icExt = new InformationCardExtension((IElement)elm, enabled, (Object)daoExt);
            this.extensions_.add(icExt);
        }
    }

    public void setName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name != null ? name.trim() : "";
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String oldName = this.issuerName_;
        try {
            this.issuerName_ = name.trim();
            this.saveIssuerName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.issuerName_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(java.util.Date date) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        java.util.Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws CardException, IOException {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerID();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveSupportedTokenTypes();
        this.saveClaimTypes();
        this.saveTokenServiceList();
        this.saveRequireAppliesTo();
        this.savePrivacyNotice();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
        this.saveExtensions();
    }

    private void saveIsSelfIssued() {
    }

    private void saveLanguage() throws CardException {
        this.card_.setLanguage(this.language_);
    }

    private void saveCardId() throws CardException {
        this.card_.setCardID(this.id_.toString());
    }

    private void saveCardVersion() throws CardException {
        this.card_.setVersion(Integer.parseInt(this.version_));
    }

    private void saveCardName() throws CardException {
        this.card_.setName(this.name_);
    }

    private void saveCardImage() throws CardException {
        this.card_.setImage(this.image_);
    }

    private void saveCardImageType() throws CardException {
        this.card_.setImageType(this.imageMimeType_);
    }

    private void saveIssuer() throws CardException {
        this.card_.setIssuer(this.issuer_);
    }

    private void saveIssuerID() throws CardException {
        this.card_.setIssuerID(this.issuerID_);
    }

    private void saveIssuerName() throws CardException {
        this.card_.setIssuerName(this.issuerName_);
    }

    private void saveTimeIssued() throws CardException {
        this.card_.setTimeIssued(new Date(this.timeIssued_.getTime()));
    }

    private void saveTimeExpires() throws CardException {
        Date dt = null;
        if (this.timeExpires_ != null) {
            dt = new Date(this.timeExpires_.getTime());
        }
        this.card_.setTimeExpires(dt);
    }

    private void saveSupportedTokenTypes() throws CardException {
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            IDaoSupportedTokenType tt = this.card_.createSupportedTokenType();
            URI uri = (URI)it.next();
            tt.setType(uri.toString());
            this.card_.addSupportedTokenType(tt);
        }
    }

    private void saveClaimTypes() throws CardException {
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType claimType = (IClaimType)it.next();
            IDaoSupportedClaimType ct = this.card_.createSupportedClaimType();
            ct.setType(claimType.getType());
            ct.setDescription(claimType.getDescription());
            ct.setDisplayName(claimType.getDisplayName());
            ct.setTypeLocalName(claimType.getTypeLocalName());
            this.card_.addSupportedClaimType(ct);
        }
    }

    private void saveTokenServiceList() throws CardException, IOException {
        Iterator it = this.tokenServices_.iterator();
        while (it.hasNext()) {
            ITokenService tokenService = (ITokenService)it.next();
            IDaoTokenService ts = this.card_.createTokenService();
            IEndpointReference er = tokenService.getEndpointReference();
            if (er == null) {
                throw new CardException("TokenService contains null EndpointReference.");
            }
            String metadata = XMLHelper.toString((Element)er.getMetadata());
            String identity = XMLHelper.toString((Element)er.getIdentity());
            ts.setEndpointAddress(er.getAddress().toString());
            ts.setIdentity(identity);
            ts.setMetadata(metadata);
            ICredentialDescriptor uc = tokenService.getUserCredential();
            if (uc == null) {
                throw new CardException("TokenService contains null UserCredential.");
            }
            String credential = XMLHelper.toString((Element)uc.asXML());
            ts.setCredential(credential);
            ts.setHint(uc.getDisplayCredentialHint());
            this.card_.addTokenService(ts);
        }
    }

    private void saveRequireAppliesTo() throws CardException {
        this.card_.setRequireAppliesTo(this.requireAppliesTo_);
    }

    private void savePrivacyNotice() throws CardException, IOException {
        IElement elm;
        String val = null;
        if (this.privacyNotice_ != null && (elm = this.privacyNotice_.getPrivacyElement()) != null) {
            try {
                val = (String)elm.getAs(class$java$lang$String == null ? (class$java$lang$String = JDBCBasedManagedCard.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
        }
        this.card_.setPrivacyNotice(val);
    }

    private void saveHashSalt() throws CardException {
        this.card_.setHashSalt(this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws CardException {
        this.timeLastUpdated_ = new java.util.Date();
        this.card_.setTimeLastUpdated(new Date(this.timeLastUpdated_.getTime()));
    }

    private void saveMasterKey() throws CardException {
        this.card_.setMasterKey(this.masterKey_);
    }

    private void saveExtensions() throws CardException {
        int j = this.extensions_.size();
        for (int i = 0; i < j; ++i) {
            IInformationCardExtension extension = (IInformationCardExtension)this.extensions_.get(i);
            Object id = extension.getId();
            if (id != null) continue;
            IDaoInformationCardExtension icExt = this.card_.createInformationCardExtension();
            IElement elm = extension.getElement();
            boolean enabled = extension.isEnabled();
            String data = null;
            try {
                data = (String)elm.getAs(class$java$lang$String == null ? JDBCBasedManagedCard.class$("java.lang.String") : class$java$lang$String);
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
            icExt.setEnabled(enabled);
            icExt.setElement(data);
            this.card_.addInformationCardExtension(icExt);
            extension.setId((Object)icExt);
            extension.addListener((IExtensionListener)this);
        }
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.card_.store();
        this.editMode = false;
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.editMode = false;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return false;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public boolean isClaimsRetrieved() {
        return false;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        if (extension == null) {
            throw new CardException("Parameter \"extension\" is null");
        }
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IDaoInformationCardExtension icExt = this.card_.createInformationCardExtension();
        boolean enabled = true;
        String data = null;
        try {
            data = (String)extension.getAs(class$java$lang$String == null ? (class$java$lang$String = JDBCBasedManagedCard.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        icExt.setElement(data);
        icExt.setEnabled(enabled);
        this.card_.addInformationCardExtension(icExt);
        InformationCardExtension ext = new InformationCardExtension(extension, enabled, (Object)icExt);
        ext.addListener((IExtensionListener)this);
        this.extensions_.add(ext);
        return ext;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (this.extensions_.contains(extension)) {
            Object id = extension.getId();
            if (id instanceof IDaoInformationCardExtension) {
                IDaoInformationCardExtension icExt = (IDaoInformationCardExtension)id;
                icExt.setDeleteState();
            }
        } else {
            throw new CardException("Could not remove extension because the card does not contain this extension");
        }
        this.extensions_.remove(extension);
    }

    public void extensionElementChanged(ICardExtensionEvent event) throws CardException {
        String newElement;
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IInformationCardExtension icExt = event.getExtension();
        IElement iElement = icExt.getElement();
        try {
            newElement = (String)iElement.getAs(class$java$lang$String == null ? (class$java$lang$String = JDBCBasedManagedCard.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        Object id = icExt.getId();
        if (id instanceof IDaoInformationCardExtension) {
            IDaoInformationCardExtension daoExt = (IDaoInformationCardExtension)id;
            String oldElement = daoExt.getElement();
            if (oldElement == null || !oldElement.equals(newElement)) {
                daoExt.setElement(newElement);
            }
        } else {
            throw new CardException("IInformationCardExtension.getId() should return an instnace of IDaoInformationCardExtension");
        }
    }

    public void extensionEnabledChanged(ICardExtensionEvent event) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IInformationCardExtension icExt = event.getExtension();
        boolean newEnabled = icExt.isEnabled();
        Object id = icExt.getId();
        if (id instanceof IDaoInformationCardExtension) {
            IDaoInformationCardExtension daoExt = (IDaoInformationCardExtension)id;
            boolean oldEnabled = daoExt.isEnabled();
            if (newEnabled != oldEnabled) {
                daoExt.setEnabled(newEnabled);
            }
        } else {
            throw new CardException("IInformationCardExtension.getId() should return an instnace of IDaoInformationCardExtension");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

