/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed.db;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.db.ICardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoMCard;
import org.eclipse.higgins.icard.provider.cardspace.managed.db.JDBCBasedManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.managed.db.ProviderConfiguration;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCBasedManagedCardProvider
extends ManagedCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCardProvider = JDBCBasedManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.managed.db.JDBCBasedManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCardProvider));
    private ProviderConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.cardspace.managed.db";
    private String name_ = "CardSpace-compatable JDBC-based managed I-Card Provider Plug-in";
    private ICardContext cc_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$db$JDBCBasedManagedCardProvider;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    private Hashtable getConfigurationProperties() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        IConfiguration cfg = this.getConfiguration();
        Iterator itr = cfg.getPropertyNames();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            String value = cfg.getProperty(key);
            ht.put(key, value);
        }
        return ht;
    }

    public void init() throws CardException {
        String cardContextClassName = this.getConfiguration().getProperty("cardcontext.classname");
        if (cardContextClassName == null) {
            throw new CardException("Can not find \"cardcontext.classname\" configuration property");
        }
        try {
            Class<?> cls = Class.forName(cardContextClassName);
            this.cc_ = (ICardContext)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        Hashtable cfg = this.getConfigurationProperties();
        super.init(cfg);
        this.cc_.init((Map)cfg);
    }

    private ICardContext getCardContext() throws CardException {
        if (this.cc_ == null) {
            this.init();
        }
        return this.cc_;
    }

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        ArrayList<JDBCBasedManagedCard> cards = new ArrayList<JDBCBasedManagedCard>();
        UserCredentials userCrds = this.authenticate(authHandler);
        ArrayList lst = this.getCardContext().getMCards(userCrds.getName());
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            IDaoMCard crd = (IDaoMCard)lst.get(i);
            JDBCBasedManagedCard card = new JDBCBasedManagedCard(this, crd);
            cards.add(card);
        }
        return cards.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
            UserCredentials userCrds = this.authenticate(authHandler);
            String userID = userCrds.getName();
            ICardContext cc = this.getCardContext();
            JDBCBasedManagedCard crd = new JDBCBasedManagedCard(this, cc, userID, card);
            return crd;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<JDBCBasedManagedCard> cardsList = new ArrayList<JDBCBasedManagedCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getName();
        ICardContext cc = this.getCardContext();
        int j = newCards.getLength();
        for (int i = 0; i < j; ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element elm = (Element)nd;
            try {
                JDBCBasedManagedCard crd = new JDBCBasedManagedCard(this, cc, userID, elm);
                cardsList.add(crd);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getName();
        ICardContext cc = this.getCardContext();
        IDaoMCard crd = cc.getMCard(card.getID(), userID);
        if (crd == null) {
            throw new CardException("Card not found.");
        }
        crd.setDeleteState();
        crd.store();
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("This provider can't create a card.");
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable managed I-Card provider";
    }

    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = JDBCBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card, (boolean)true, (boolean)true) : card;
            UserCredentials userCrds = this.authenticate(authHandler);
            String userID = userCrds.getName();
            ICardContext cc = this.getCardContext();
            JDBCBasedManagedCard mc = new JDBCBasedManagedCard(this, cc, userID, crd);
            return mc;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    protected ICard getICardByID(CallbackHandler authHandler, String cardID) throws CardException {
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getName();
        ICardContext cc = this.getCardContext();
        IDaoMCard crd = cc.getMCard(cardID, userID);
        if (crd != null) {
            return new JDBCBasedManagedCard(this, crd);
        }
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User id: ");
        Callback[] callbacks = new Callback[]{nc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        return new UserCredentials(userName);
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        throw new CardException("ICard provider " + this.name_ + " can not create a card.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String name_;

        public UserCredentials(String name) {
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }
    }
}

