/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed.xml;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.managed.xml.XMLBasedManagedCardProvider;
import org.w3c.dom.Element;

public class XMLBasedPersonalCard
extends PersonalCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedPersonalCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedPersonalCard = XMLBasedPersonalCard.class$("org.eclipse.higgins.icard.provider.cardspace.managed.xml.XMLBasedPersonalCard")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedPersonalCard));
    protected String user_ = null;
    protected String password_ = null;
    protected boolean editMode = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedPersonalCard;

    public XMLBasedPersonalCard(XMLBasedManagedCardProvider provider, Element card, String user, String password) throws CardException {
        this.description_ = "XML-based CardSpace-interoperable personal I-Card";
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        this.provider_ = provider;
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (user == null) {
            throw new CardException("Parameter \"user\" is null");
        }
        if (password == null) {
            throw new CardException("Parameter \"password\" is null");
        }
        this.user_ = user;
        this.password_ = password;
        try {
            this.initFromXML(card);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void setImage(byte[] newImage, String newImageType) throws CardException {
        if (newImage == null) {
            throw new CardException("Parameter \"newImage\" is null.");
        }
        if (newImageType == null) {
            throw new CardException("Parameter \"newImageType\" is null.");
        }
        this.image_ = newImage;
        this.imageMimeType_ = newImageType;
        ((XMLBasedManagedCardProvider)this.provider_).updateCard(this);
    }

    public void setName(String newName) throws CardException {
        if (newName == null || newName.trim().length() == 0) {
            throw new CardException("Parameter \"newName\" is empty string.");
        }
        this.name_ = newName.trim();
        ((XMLBasedManagedCardProvider)this.provider_).updateCard(this);
    }

    public void setTimeExpires(Date date) throws CardException {
        this.timeExpires_ = date;
        ((XMLBasedManagedCardProvider)this.provider_).updateCard(this);
    }

    public void setIssuerName(String name) throws CardException {
        this.issuerName_ = name;
        ((XMLBasedManagedCardProvider)this.provider_).updateCard(this);
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public void applyUpdates() throws InvalidStateException, CardException {
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException();
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException();
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return false;
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
        throw new CardException("Not implemented.");
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

