/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.io.RoamingStoreElementFormat;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.cardspace.managed.xml.ProviderConfiguration;
import org.eclipse.higgins.icard.provider.cardspace.managed.xml.XMLBasedManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.managed.xml.XMLBasedPersonalCard;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLBasedManagedCardProvider
extends ManagedCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedManagedCardProvider = XMLBasedManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.managed.xml.XMLBasedManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedManagedCardProvider));
    protected static final String ID = "org.eclipse.higgins.icard.provider.cardspace.managed.xml";
    private String name_;
    private String description_ = this.name_ = "Xml-based CardSpace-compatable managed I-Card Provider";
    protected ProviderConfiguration config = new ProviderConfiguration("org.eclipse.higgins.icard.provider.cardspace.managed.xml");
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$xml$XMLBasedManagedCardProvider;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IManagedInformationCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IPersonalInformationCard;

    private File getStorageFile(String username) {
        if (username == null) {
            return null;
        }
        String workDir = this.config.getWorkDir();
        File dir = new File(workDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.isFile()) {
            this.log.error((Object)("Can not create the working dirrectory. There already exists a file with such a name : " + workDir));
            return null;
        }
        return new File(workDir + File.separator + username + ".crds");
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        String password = new String(pc.getPassword());
        pc.clearPassword();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new CardException("Empty password.");
        }
        return new UserCredentials(userName, password);
    }

    private Document getCardsStore(UserCredentials credentials) throws CardException {
        Document cards;
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        File cardsFile = this.getStorageFile(credentials.getName());
        if (cardsFile.exists()) {
            if (cardsFile.isFile()) {
                FileInputStream fis;
                try {
                    fis = new FileInputStream(cardsFile);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
                try {
                    cards = CardCryptography.decrypt((InputStream)fis, (String)credentials.getPassword());
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            throw new CardException("Unable to open " + cardsFile.getAbsolutePath());
        }
        cards = db.newDocument();
        cards.appendChild(cards.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingStore"));
        return cards;
    }

    private void saveCardsStore(Document cards, UserCredentials credentials) throws Exception {
        FileOutputStream fos = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("$mc", ".tmp", new File(this.config.getWorkDir()));
            fos = new FileOutputStream(tmpFile);
            CardCryptography.encrypt((Document)cards, (OutputStream)fos, (String)credentials.getPassword());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
        File cardsFile = this.getStorageFile(credentials.getName());
        if (cardsFile.exists()) {
            File bkpFile = new File(cardsFile.getAbsolutePath() + ".bkp");
            if (bkpFile.exists()) {
                bkpFile.delete();
            }
            if (!cardsFile.renameTo(bkpFile) && !cardsFile.delete()) {
                throw new CardException("Couldn't save cards to file " + cardsFile.getAbsolutePath());
            }
        }
        if (!tmpFile.renameTo(cardsFile)) {
            throw new CardException("Couldn't save cards to file " + cardsFile.getAbsolutePath());
        }
    }

    public void setID(String id) throws Exception {
    }

    public IConfiguration getConfiguration() {
        return this.config;
    }

    public boolean isSelfIssued(Element card) throws CardException {
        if ("RoamingInformationCard".equals(card.getLocalName())) {
            Element metaData = XMLUtils.getChildElement((Element)card, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCardMetaData");
            if (metaData == null) {
                throw new CardException("Can not get \"InformationCardMetaData\" element from RoamingInformationCard.");
            }
            Element isSelfIssued = XMLUtils.getChildElement((Element)metaData, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"IsSelfIssued");
            if (isSelfIssued == null) {
                throw new CardException("Can not get \"IsSelfIssued\" element from InformationCardMetaData.");
            }
            String isSelf = XMLUtils.getTextContent((Element)isSelfIssued);
            if ("true".equalsIgnoreCase(isSelf)) {
                return true;
            }
            if ("false".equalsIgnoreCase(isSelf)) {
                return false;
            }
            throw new CardException("\"IsSelfIssued\" element contains unexpected value = " + isSelf);
        }
        if ("InformationCard".equals(card.getLocalName())) {
            return false;
        }
        throw new CardException("Unexpected element " + card.getNodeName());
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        ArrayList<XMLBasedPersonalCard> cards = new ArrayList<XMLBasedPersonalCard>();
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            Document doc = this.getCardsStore(userCrds);
            Element store = doc.getDocumentElement();
            ArrayList roamingCards = XMLUtils.getChildElements((Element)store, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"RoamingInformationCard");
            int len = roamingCards.size();
            for (int i = 0; i < len; ++i) {
                Element roamingCard = (Element)roamingCards.get(i);
                Object card = null;
                card = this.isSelfIssued(roamingCard) ? new XMLBasedPersonalCard(this, roamingCard, userCrds.name_, userCrds.password_) : new XMLBasedManagedCard(this, roamingCard, userCrds.name_, userCrds.password_);
                cards.add((XMLBasedPersonalCard)((Object)card));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cards.iterator();
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        return this.getICardByCUID(authHandler, new CUID(CUID2));
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (cuid == null) {
            throw new IllegalArgumentException("UUID parameter can't be null.");
        }
        Iterator itr = this.getICardsByPolicy(authHandler, null);
        while (itr.hasNext()) {
            ICard card = (ICard)itr.next();
            if (!cuid.equals((Object)card.getCUID())) continue;
            return card;
        }
        throw new CardException("I-Card with ID=" + cuid + " not found.");
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        Document cards = this.getCardsStore(userCrds);
        if (this.removeCardFromList(card.getID().toString(), cards)) {
            try {
                this.saveCardsStore(cards, userCrds);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException(e.getMessage());
            }
        } else {
            throw new CardException("Unable to delete card with id = " + card.getID().toString() + ".");
        }
    }

    private Element getRoamingCardByID(String cardID, Document cards) throws CardException {
        if (cardID == null) {
            throw new CardException("Parameter \"cardID\" is null");
        }
        if (cards == null) {
            throw new CardException("Parameter \"cards\" is null");
        }
        Element store = cards.getDocumentElement();
        ArrayList roamingCards = XMLUtils.getChildElements((Element)store, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"RoamingInformationCard");
        int len = roamingCards.size();
        for (int i = 0; i < len; ++i) {
            String id;
            Element cardId;
            Element cardReference;
            Element roamingCard = (Element)roamingCards.get(i);
            Element metaData = XMLUtils.getChildElement((Element)roamingCard, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCardMetaData");
            if (metaData == null || (cardReference = XMLUtils.getChildElement((Element)metaData, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCardReference")) == null || (cardId = XMLUtils.getChildElement((Element)cardReference, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"CardId")) == null || !cardID.equals(id = XMLUtils.getTextContent((Element)cardId))) continue;
            return roamingCard;
        }
        return null;
    }

    private boolean removeCardFromList(String cardID, Document cards) throws CardException {
        Element oldCard = this.getRoamingCardByID(cardID, cards);
        if (oldCard != null) {
            cards.getDocumentElement().removeChild(oldCard);
            return true;
        }
        return false;
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
            UserCredentials credentials = this.authenticate(authHandler);
            XMLBasedManagedCard mic = new XMLBasedManagedCard(this, card, credentials.name_, credentials.password_);
            Document cards = this.getCardsStore(credentials);
            Element root = cards.getDocumentElement();
            this.removeCardFromList(mic.getID().toString(), cards);
            IElement e = mic.toElement((IElementFormat)RoamingStoreElementFormat.getInstance());
            Element roamingCard = (Element)cards.importNode((Element)e.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element), true);
            root.appendChild(roamingCard);
            this.saveCardsStore(cards, credentials);
            return mic;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<XMLBasedPersonalCard> cardsList = new ArrayList<XMLBasedPersonalCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials credentials = this.authenticate(authHandler);
        Document cards = this.getCardsStore(credentials);
        Element root = cards.getDocumentElement();
        for (int i = 0; i < newCards.getLength(); ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element roamingCard = (Element)nd;
            Object card = null;
            card = this.isSelfIssued(roamingCard) ? new XMLBasedPersonalCard(this, roamingCard, credentials.name_, credentials.password_) : new XMLBasedManagedCard(this, roamingCard, credentials.name_, credentials.password_);
            cardsList.add((XMLBasedPersonalCard)((Object)card));
            this.removeCardFromList(card.getID().toString(), cards);
            Node newCard = cards.importNode(roamingCard, true);
            root.appendChild(newCard);
        }
        try {
            this.saveCardsStore(cards, credentials);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("This provider can't create a card.");
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement element) {
        boolean res = false;
        if (element == null) {
            return res;
        }
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            if (card == null) {
                return res;
            }
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card) : card;
            if (this.isSelfIssued(crd)) {
                new XMLBasedPersonalCard(this, crd, "nouser", "nopassword");
            } else {
                new XMLBasedManagedCard(this, crd, "nouser", "nopassword");
            }
            res = true;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            res = false;
        }
        return res;
    }

    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card) : card;
            UserCredentials credentials = this.authenticate(authHandler);
            Object iCard = null;
            iCard = this.isSelfIssued(crd) ? new XMLBasedPersonalCard(this, crd, "nouser", "nopassword") : new XMLBasedManagedCard(this, crd, "nouser", "nopassword");
            Document cards = this.getCardsStore(credentials);
            Element root = cards.getDocumentElement();
            this.removeCardFromList(iCard.getID().toString(), cards);
            IElement e = iCard.toElement((IElementFormat)RoamingStoreElementFormat.getInstance());
            Element roamingCard = (Element)cards.importNode((Element)e.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element), true);
            root.appendChild(roamingCard);
            this.saveCardsStore(cards, credentials);
            return iCard;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void updateCard(XMLBasedManagedCard card) throws CardException {
        try {
            UserCredentials credentials = new UserCredentials(card.user_, card.password_);
            Document cards = this.getCardsStore(credentials);
            Element root = cards.getDocumentElement();
            this.removeCardFromList(card.getID().toString(), cards);
            IElement e = card.toElement((IElementFormat)RoamingStoreElementFormat.getInstance());
            Element roamingCard = (Element)cards.importNode((Element)e.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element), true);
            root.appendChild(roamingCard);
            this.saveCardsStore(cards, credentials);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void updateCard(XMLBasedPersonalCard card) throws CardException {
        try {
            UserCredentials credentials = new UserCredentials(card.user_, card.password_);
            Document cards = this.getCardsStore(credentials);
            Element root = cards.getDocumentElement();
            this.removeCardFromList(card.getID().toString(), cards);
            IElement e = card.toElement((IElementFormat)RoamingStoreElementFormat.getInstance());
            Element roamingCard = (Element)cards.importNode((Element)e.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element), true);
            root.appendChild(roamingCard);
            this.saveCardsStore(cards, credentials);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        throw new CardException("ICard provider " + this.name_ + " can not create a card.");
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof XMLBasedPersonalCard) {
            XMLBasedPersonalCard pcard = (XMLBasedPersonalCard)card;
            ISelfIssuedCredential credentials = null;
            ICredentialDescriptor[] cds = pcard.getRequiredCredentials();
            if (cds != null && cds.length > 0) {
                credentials = (ISelfIssuedCredential)cds[0].getCredential();
            }
            pcard.retrieveClaims((ICredential)credentials);
            return pcard;
        }
        return super.getICardByCUID(authHandler, cuid, userCredential);
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IManagedInformationCard == null ? (class$org$eclipse$higgins$icard$IManagedInformationCard = XMLBasedManagedCardProvider.class$("org.eclipse.higgins.icard.IManagedInformationCard")) : class$org$eclipse$higgins$icard$IManagedInformationCard, class$org$eclipse$higgins$icard$IPersonalInformationCard == null ? (class$org$eclipse$higgins$icard$IPersonalInformationCard = XMLBasedManagedCardProvider.class$("org.eclipse.higgins.icard.IPersonalInformationCard")) : class$org$eclipse$higgins$icard$IPersonalInformationCard};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String name_;
        private String password_;

        public UserCredentials(String name, String password) {
            this.password_ = password;
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public String getPassword() {
            return this.password_;
        }
    }
}

