/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.IdASContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCardProvider;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchSubjectException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IdASBasedManagedCard
extends ManagedCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard = IdASBasedManagedCard.class$("org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCard")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard));
    IdASBasedManagedCardProvider provider_ = null;
    IDigitalSubject card_ = null;
    private boolean editMode = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard;

    public IdASBasedManagedCard() {
    }

    public IdASBasedManagedCard(IdASBasedManagedCardProvider provider, IDigitalSubject card) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.card_ = card;
        this.initFromDS(this.card_);
    }

    public IdASBasedManagedCard(IdASBasedManagedCardProvider provider, IContext context, Element card) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.initFromXML(card);
        try {
            this.card_ = context.getSubject(this.id_.toString());
        }
        catch (NoSuchSubjectException e) {
            this.card_ = context.addSubject(IdASContext.ICARD_ManagedInformationCard, this.id_.toString());
        }
        this.saveCard();
    }

    public void initFromDS(IDigitalSubject card) throws Exception {
        this.initIsSelfIssued(card);
        this.initLanguage(card);
        this.initCardId(card);
        this.initCardVersion(card);
        this.initCardName(card);
        this.initCardImage(card);
        this.initCardImageType(card);
        this.initIssuer(card);
        this.initIssuerName(card);
        this.initTimeIssued(card);
        this.initTimeExpires(card);
        this.initSupportedTokenTypes(card);
        this.initClaimTypes(card);
        this.initTokenServiceList(card);
        this.initRequireAppliesTo(card);
        this.initPrivacyNotice(card);
        this.initHashSalt(card);
        this.initTimeLastUpdated(card);
        this.initMasterKey(card);
    }

    private void initIsSelfIssued(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.isSelfIssued_ = false;
        Boolean issi = (Boolean)this.getSimpleValueData(card, IdASContext.ICARD_isSelfIssued);
        if (issi != null && issi.booleanValue()) {
            throw new CardException("Can not init managed card with DigitalSubject storing data of self-issued (Personal) card");
        }
    }

    private void initLanguage(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.language_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_language);
    }

    private void initCardId(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.id_ = (URI)this.getSimpleValueData(card, IdASContext.HIGGINS_uniqueIdentifier);
    }

    private void initCardVersion(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.version_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_version);
    }

    private void initCardName(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.name_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_name);
    }

    private void initCardImage(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.image_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_image);
    }

    private void initCardImageType(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.imageMimeType_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_imageMimeType);
    }

    private void initIssuer(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.issuer_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_issuer);
    }

    private void initIssuerName(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.issuerName_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_issuerName);
    }

    private void initTimeIssued(IDigitalSubject card) throws IdASException, CardException {
        this.timeIssued_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeIssued);
        if (obj != null) {
            this.timeIssued_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeExpires(IDigitalSubject card) throws IdASException, CardException {
        this.timeExpires_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_expiredTime);
        if (obj != null) {
            this.timeExpires_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initSupportedTokenTypes(IDigitalSubject card) throws IdASException, CardException {
        this.supportedTokenTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple()) {
                Object obj;
                ISimpleAttrValue sv = (ISimpleAttrValue)val;
                if (sv == null || (obj = sv.getData()) == null) continue;
                if (obj instanceof URI) {
                    this.supportedTokenTypes_.add(obj);
                    continue;
                }
                try {
                    this.supportedTokenTypes_.add(new URI(obj.toString()));
                    continue;
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            throw new CardException("Attribute " + IdASContext.ICARD_supportedTokenType + " contains non simple value");
        }
    }

    private void initClaimTypes(IDigitalSubject card) throws IdASException, CardException {
        this.claimTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IComplexAttrValue cv;
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple() || (cv = (IComplexAttrValue)val) == null) continue;
            String type = (String)this.getSimpleValueData(card, IdASContext.ICARD_claimTypeType);
            String name = (String)this.getSimpleValueData(card, IdASContext.ICARD_claimTypeName);
            String description = (String)this.getSimpleValueData(card, IdASContext.ICARD_claimTypeDescription);
            ClaimType ct = new ClaimType(type, name, description);
            this.claimTypes_.add(ct);
        }
    }

    private void initTokenServiceList(IDigitalSubject card) throws ClassCastException, IdASException, CardException, IllegalArgumentException, ParserConfigurationException, SAXException, IOException {
        this.tokenServices_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_tokenService);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr;
            if (val.isSimple()) continue;
            URI epAddress = (URI)this.getSimpleValueData(card, IdASContext.ICARD_endpoint_address);
            String epMetadata = (String)this.getSimpleValueData(card, IdASContext.ICARD_endpoint_metadata);
            String epIdentity = (String)this.getSimpleValueData(card, IdASContext.ICARD_endpoint_identity);
            String ucHint = (String)this.getSimpleValueData(card, IdASContext.ICARD_credential_displayCredentialHint);
            String ucCredential = (String)this.getSimpleValueData(card, IdASContext.ICARD_credential_credential);
            EndpointReference endpoint = new EndpointReference(epAddress, epMetadata, epIdentity);
            CredentialDescriptor credential = new CredentialDescriptor(ucHint, ucCredential);
            TokenService tc = new TokenService(endpoint, credential);
            this.tokenServices_.add(tc);
        }
    }

    private void initRequireAppliesTo(IDigitalSubject card) throws IdASException, CardException {
        this.requireAppliesTo_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_requireAppliesTo);
        if (obj != null) {
            this.requireAppliesTo_ = obj instanceof Boolean ? (Boolean)obj : Boolean.valueOf(obj.toString());
        }
    }

    private void initPrivacyNotice(IDigitalSubject card) throws IdASException, CardException, ParserConfigurationException, SAXException, IOException, ClassCastException {
        this.privacyNotice_ = null;
        String obj = (String)this.getSimpleValueData(card, IdASContext.ICARD_privacyNotice);
        if (obj != null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sisMetadata = new StringReader(obj);
            InputSource isMetadata = new InputSource(sisMetadata);
            Document mdDoc = db.parse(isMetadata);
            this.privacyNotice_ = mdDoc.getDocumentElement();
        }
    }

    private void initHashSalt(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.hashSalt_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_hashSalt);
    }

    private void initTimeLastUpdated(IDigitalSubject card) throws IdASException, CardException {
        this.timeLastUpdated_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeLastUpdated);
        if (obj != null) {
            this.timeLastUpdated_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initMasterKey(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.masterKey_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_masterKey);
    }

    public void setName(String name) throws CardException {
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String oldName = this.name_;
        this.name_ = name.trim();
        try {
            this.saveCardName();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (image == null) {
            throw new CardException("Couldn't set null card image.");
        }
        if (imageMimeType == null) {
            throw new CardException("Couldn't set null card image MIME type.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String oldName = this.name_;
        this.name_ = name.trim();
        try {
            this.saveIssuerName();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(Date date) throws CardException {
        Date oldDate = this.timeExpires_;
        this.timeExpires_ = date;
        try {
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws Exception {
        try {
            this.saveIsSelfIssued();
            this.saveLanguage();
            this.saveCardId();
            this.saveCardVersion();
            this.saveCardName();
            this.saveCardImage();
            this.saveCardImageType();
            this.saveIssuer();
            this.saveIssuerName();
            this.saveTimeIssued();
            this.saveTimeExpires();
            this.saveSupportedTokenTypes();
            this.saveClaimTypes();
            this.saveTokenServiceList();
            this.saveRequireAppliesTo();
            this.savePrivacyNotice();
            this.saveHashSalt();
            this.saveTimeLastUpdated();
            this.saveMasterKey();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw e;
        }
    }

    private void saveIsSelfIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_isSelfIssued);
        attr.addSimpleValue(null, (Object)false);
    }

    private void saveLanguage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_language);
        attr.addSimpleValue(null, (Object)this.language_);
    }

    private void saveCardId() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.HIGGINS_uniqueIdentifier);
        attr.addSimpleValue(null, (Object)this.id_);
    }

    private void saveCardVersion() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_version);
        attr.addSimpleValue(null, (Object)this.version_);
    }

    private void saveCardName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
        attr.addSimpleValue(null, (Object)this.name_);
    }

    private void saveCardImage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
        attr.addSimpleValue(null, (Object)this.image_);
    }

    private void saveCardImageType() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
        attr.addSimpleValue(null, (Object)this.imageMimeType_);
    }

    private void saveIssuer() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuer);
        attr.addSimpleValue(null, (Object)this.issuer_);
    }

    private void saveIssuerName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
        attr.addSimpleValue(null, (Object)this.issuerName_);
    }

    private void saveTimeIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeIssued);
        attr.addSimpleValue(null, (Object)this.timeIssued_);
    }

    private void saveTimeExpires() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
        attr.addSimpleValue(null, (Object)this.timeExpires_);
    }

    private void saveSupportedTokenTypes() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            attr.addSimpleValue(null, (Object)uri);
        }
    }

    private void saveClaimTypes() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType claimType = (IClaimType)it.next();
            IComplexAttrValue val = attr.addComplexValue(null);
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeType).addSimpleValue(null, (Object)claimType.getType());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeDescription).addSimpleValue(null, (Object)claimType.getDescription());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeName).addSimpleValue(null, (Object)claimType.getDisplayName());
        }
    }

    private void saveTokenServiceList() throws IdASException, TransformerException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_tokenService);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.tokenServices_.iterator();
        while (it.hasNext()) {
            ICredentialDescriptor uc;
            ITokenService tokenService = (ITokenService)it.next();
            IComplexAttrValue val = attr.addComplexValue(null);
            IEndpointReference er = tokenService.getEndpointReference();
            if (er != null) {
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_address).addSimpleValue(null, (Object)er.getAddress());
                String metadataStr = XMLUtils.elementToString((Element)er.getMetadata());
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_metadata).addSimpleValue(null, (Object)metadataStr);
                String identityStr = XMLUtils.elementToString((Element)er.getIdentity());
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_identity).addSimpleValue(null, (Object)identityStr);
            }
            if ((uc = tokenService.getUserCredential()) == null) continue;
            val.getSingleValuedAttribute(IdASContext.ICARD_credential_displayCredentialHint).addSimpleValue(null, (Object)uc.getDisplayCredentialHint());
            String credentialStr = XMLUtils.elementToString((Element)uc.asXML());
            val.getSingleValuedAttribute(IdASContext.ICARD_credential_credential).addSimpleValue(null, (Object)credentialStr);
        }
    }

    private void saveRequireAppliesTo() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_requireAppliesTo);
        attr.addSimpleValue(null, (Object)this.requireAppliesTo_);
    }

    private void savePrivacyNotice() throws IdASException, TransformerException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_privacyNotice);
        if (this.privacyNotice_ != null) {
            attr.addSimpleValue(null, (Object)XMLUtils.elementToString((Element)this.privacyNotice_));
        } else {
            attr.addSimpleValue(null, null);
        }
    }

    private void saveHashSalt() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_hashSalt);
        attr.addSimpleValue(null, (Object)this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws IdASException {
        this.timeLastUpdated_ = new Date();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeLastUpdated);
        attr.addSimpleValue(null, (Object)this.timeLastUpdated_);
    }

    private void saveMasterKey() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_masterKey);
        attr.addSimpleValue(null, (Object)this.masterKey_);
    }

    private Object getSimpleValueData(IDigitalSubject subj, URI attribure) throws IdASException, CardException {
        IAttributeValue v;
        ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribure);
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getAttrID() != null ? attr.getAttrID().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public IDigitalSubject getCardSubject() {
        return this.card_;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = false;
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.editMode = false;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return false;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public boolean isClaimsRetrieved() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

