/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.IdASContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.ProviderConfiguration;
import org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCard;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdASBasedManagedCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider = IdASBasedManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider));
    private static final String CONTEXT_ID = "context.id";
    private IdASRegistry reg_ = IdASRegistry.getInstance();
    private ProviderConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.cardspace.managed";
    private String name_ = "CardSpace-compatable managed I-Card Provider";
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IManagedInformationCard;

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    private IContext getContext(UserCredentials credentials) throws CardException {
        IContext ctx = null;
        if (this.config_ != null) {
            String contextID = this.config_.getProperty(CONTEXT_ID);
            if (contextID == null) {
                throw new CardException("Can not get \"context.id\" configuration property.");
            }
            try {
                ctx = this.reg_.createContext(contextID);
                AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, credentials.getName(), credentials.getPassword());
                ctx.open((Object)credential);
                return ctx;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return null;
    }

    public Iterator getICards(CallbackHandler authHandler, IPolicy policy) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        ArrayList<IdASBasedManagedCard> cards = new ArrayList<IdASBasedManagedCard>();
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                Iterator subjList = ctx.getSubjects(null);
                while (subjList.hasNext()) {
                    IDigitalSubject subj = (IDigitalSubject)subjList.next();
                    if (!IdASContext.ICARD_ManagedInformationCard.equals(subj.getType())) continue;
                    IdASBasedManagedCard card = new IdASBasedManagedCard(this, subj);
                    if (policy == null) {
                        cards.add(card);
                        continue;
                    }
                    if (!policy.isSatisfiedBy((ICard)card)) continue;
                    cards.add(card);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cards.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
            UserCredentials credentials = this.authenticate(authHandler);
            IContext ctx = this.getContext(credentials);
            if (ctx != null) {
                IdASBasedManagedCard pic = new IdASBasedManagedCard(this, ctx, card);
                return pic;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<IdASBasedManagedCard> cardsList = new ArrayList<IdASBasedManagedCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials credentials = this.authenticate(authHandler);
        IContext ctx = this.getContext(credentials);
        if (ctx != null) {
            for (int i = 0; i < newCards.getLength(); ++i) {
                Node nd = newCards.item(i);
                if (nd.getNodeType() != 1) continue;
                Element elm = (Element)nd;
                try {
                    IdASBasedManagedCard crd = new IdASBasedManagedCard(this, ctx, elm);
                    cardsList.add(crd);
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null && card instanceof IdASBasedManagedCard) {
            try {
                IdASBasedManagedCard crd = (IdASBasedManagedCard)card;
                String subjId = crd.getCardSubject().getSubjectID();
                IDigitalSubject subj = ctx.getSubject(subjId);
                subj.remove();
                ctx.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                try {
                    ctx.cancelUpdates();
                }
                catch (Exception e1) {
                    this.log.error((Object)e1);
                    throw new CardException((Throwable)e1);
                }
                throw new CardException((Throwable)e);
            }
        }
    }

    public List importFromBackup(InputStream is, String password) throws Exception {
        Document cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        ArrayList<IdASBasedManagedCard> cardsList = new ArrayList<IdASBasedManagedCard>();
        NodeList cards = cardBackup.getDocumentElement().getChildNodes();
        for (int i = 0; i < cards.getLength(); ++i) {
            Node nd = cards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element elm = (Element)nd;
            IdASBasedManagedCard crd = new IdASBasedManagedCard(this, null, elm);
            cardsList.add(crd);
        }
        return cardsList;
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("This provider can't create a card.");
    }

    public void exportCards(CallbackHandler authHandler, Iterator cards, OutputStream out) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        PasswordCallback pc = new PasswordCallback("Enter password for exported card(s) backup: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingStore");
            doc.appendChild(root);
            while (cards.hasNext()) {
                Object obj = cards.next();
                if (!(obj instanceof InformationCard)) continue;
                InformationCard card = (InformationCard)obj;
                Element roamingCard = card.toXML(doc);
                root.appendChild(roamingCard);
            }
            CardCryptography.encrypt((Document)doc, (OutputStream)out, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable managed I-Card provider";
    }

    public ICard getICardByID(CallbackHandler authHandler, String UUID) throws CardException {
        return null;
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IManagedInformationCard == null ? (class$org$eclipse$higgins$icard$IManagedInformationCard = IdASBasedManagedCardProvider.class$("org.eclipse.higgins.icard.IManagedInformationCard")) : class$org$eclipse$higgins$icard$IManagedInformationCard};
    }

    public boolean canImportICard(CallbackHandler authHandler, Element card) {
        IdASBasedManagedCard crd = new IdASBasedManagedCard();
        try {
            crd.initFromXML(card);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    public void exportICard(CallbackHandler authHandler, ICard card, Element root) throws CardException {
        Document doc = root.getOwnerDocument();
        if (!(card instanceof IInformationCard)) {
            throw new CardException("Can not export card. This card is not an instance of IInformationCard.");
        }
        IInformationCard icard = (IInformationCard)card;
        Element roamingCard = icard.toXML(doc);
        root.appendChild(roamingCard);
    }

    public ICard importICard(CallbackHandler authHandler, Element card) throws CardException {
        try {
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card) : card;
            UserCredentials credentials = this.authenticate(authHandler);
            IContext ctx = this.getContext(credentials);
            if (ctx != null) {
                IdASBasedManagedCard mic = new IdASBasedManagedCard(this, ctx, crd);
                return mic;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                IDigitalSubject subj = ctx.getSubject(CUID2);
                IdASBasedManagedCard card = new IdASBasedManagedCard(this, subj);
                return card;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByCUID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        String password = new String(pc.getPassword());
        pc.clearPassword();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new CardException("Empty password.");
        }
        return new UserCredentials(userName, password);
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        throw new CardException("ICard provider " + this.name_ + " can not create a card.");
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String name_;
        private String password_;

        public UserCredentials(String name, String password) {
            this.password_ = password;
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public String getPassword() {
            return this.password_;
        }
    }
}

