/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.IdASContext;
import org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.managed.ProviderConfiguration;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdASBasedManagedCardProvider
extends ManagedCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider = IdASBasedManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider));
    private static final String CONTEXT_ID = "context.id";
    private static final String DISCOVERY_FILE = "discovery.filename";
    private ProviderConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.cardspace.managed";
    private String name_ = "CardSpace-compatable managed I-Card Provider Plug-in";
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCardProvider;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    private IContext getContext(UserCredentials credentials) throws CardException {
        String disc = this.getConfiguration().getProperty(DISCOVERY_FILE);
        FileDiscovery factories = new FileDiscovery(new File(disc));
        IdASRegistry registry = IdASRegistry.getInstance();
        registry.setDiscovery((IDiscovery)factories);
        IContext ctx = null;
        if (this.config_ != null) {
            String contextID = this.getConfiguration().getProperty(CONTEXT_ID);
            if (contextID == null) {
                throw new CardException("Can not get \"context.id\" configuration property.");
            }
            try {
                ctx = registry.createContext(contextID);
                AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, credentials.getName(), credentials.getPassword());
                ctx.open((Object)credential);
                return ctx;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        ArrayList<IdASBasedManagedCard> cards;
        block6: {
            if (authHandler == null) {
                throw new CardException("Parameter \"authHandler\" is null");
            }
            cards = new ArrayList<IdASBasedManagedCard>();
            try {
                UserCredentials userCrds = this.authenticate(authHandler);
                IContext ctx = this.getContext(userCrds);
                if (ctx == null) break block6;
                IFilter filter = ctx.buildFilter();
                filter.setOperator("urn:eclipse.higgins.idas.OP_AND");
                IFilterEntityTypeAssertion typeAssertion = ctx.buildEntityTypeAssertion();
                typeAssertion.setAssertionValue(IdASContext.ICARD_ManagedInformationCard);
                filter.addFilter((IFilterAssertion)typeAssertion);
                Iterator subjList = ctx.getEntities(filter);
                while (subjList.hasNext()) {
                    IEntity subj = (IEntity)subjList.next();
                    if (!IdASContext.ICARD_ManagedInformationCard.equals(subj.getEntityType())) continue;
                    IdASBasedManagedCard card = new IdASBasedManagedCard(this, subj);
                    cards.add(card);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return cards.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
        UserCredentials credentials = this.authenticate(authHandler);
        IContext ctx = this.getContext(credentials);
        if (ctx == null) return null;
        try {
            IdASBasedManagedCard pic = new IdASBasedManagedCard(this, ctx, card);
            return pic;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<IdASBasedManagedCard> cardsList = new ArrayList<IdASBasedManagedCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials credentials = this.authenticate(authHandler);
        IContext ctx = this.getContext(credentials);
        if (ctx != null) {
            for (int i = 0; i < newCards.getLength(); ++i) {
                Node nd = newCards.item(i);
                if (nd.getNodeType() != 1) continue;
                Element elm = (Element)nd;
                try {
                    IdASBasedManagedCard crd = new IdASBasedManagedCard(this, ctx, elm);
                    cardsList.add(crd);
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        block9: {
            if (authHandler == null) {
                throw new CardException("Parameter \"authHandler\" is null");
            }
            if (card == null) {
                throw new CardException("Parameter \"card\" is null");
            }
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                if (!(card instanceof IdASBasedManagedCard)) break block9;
                try {
                    IdASBasedManagedCard crd = (IdASBasedManagedCard)card;
                    String subjId = crd.getCardSubject().getEntityID();
                    IEntity subj = ctx.getEntity(subjId);
                    subj.remove();
                    ctx.applyUpdates();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    try {
                        ctx.cancelUpdates();
                    }
                    catch (Exception e1) {
                        this.log.error((Object)e1);
                        throw new CardException((Throwable)e1);
                    }
                    throw new CardException((Throwable)e);
                }
            }
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("This provider can't create a card.");
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable managed I-Card provider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        block5: {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = IdASBasedManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card) : card;
            UserCredentials credentials = this.authenticate(authHandler);
            IContext ctx = this.getContext(credentials);
            if (ctx == null) break block5;
            try {
                IdASBasedManagedCard mic;
                IdASBasedManagedCard idASBasedManagedCard = mic = new IdASBasedManagedCard(this, ctx, crd);
                return idASBasedManagedCard;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new CardException(e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ICard getICardByID(CallbackHandler authHandler, String CardID) throws CardException {
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx == null) return null;
        try {
            IEntity subj = ctx.getEntity(CardID);
            IdASBasedManagedCard card = new IdASBasedManagedCard(this, subj);
            return card;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        String password = new String(pc.getPassword());
        pc.clearPassword();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new CardException("Empty password.");
        }
        return new UserCredentials(userName, password);
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        throw new CardException("ICard provider " + this.name_ + " can not create a card.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String name_;
        private String password_;

        public UserCredentials(String name, String password) {
            this.password_ = password;
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public String getPassword() {
            return this.password_;
        }
    }
}

