/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.personal.db;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.EncryptedMasterKey;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.db.ICardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCard;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCardClaim;
import org.eclipse.higgins.icard.provider.cardspace.personal.db.JDBCBasedPersonalCardProvider;
import org.w3c.dom.Element;

public class JDBCBasedPersonalCard
extends PersonalCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCard = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.provider.cardspace.personal.db.JDBCBasedPersonalCard")) : class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCard));
    private IDaoPCard card_ = null;
    private boolean editMode = false;
    private EncryptedMasterKey currentMasterKey_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ISimpleClaimType;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$ClaimType;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ISimpleClaim;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback;

    public JDBCBasedPersonalCard() {
    }

    public JDBCBasedPersonalCard(JDBCBasedPersonalCardProvider provider, ICardContext context, String userID, URI cardId, String cardName, HashMap dirtyClaims, byte[] image, String imageMimeType) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (cardId == null) {
            throw new CardException("Parameter \"cardId\" is null");
        }
        this.initPCardConstants();
        this.provider_ = provider;
        this.id_ = cardId;
        this.version_ = "1";
        this.timeIssued_ = new java.util.Date();
        this.name_ = cardName != null ? cardName : "";
        this.masterKey_ = CardCryptography.getRandomBytes((int)32);
        this.hashSalt_ = CardCryptography.getRandomBytes((int)16);
        if (image != null && imageMimeType != null) {
            this.image_ = image;
            this.imageMimeType_ = imageMimeType;
        }
        this.dirtyClaimValueMap_ = dirtyClaims;
        super.setClaims((List)this.getAllClaimsFromDirtyMap(this.dirtyClaimValueMap_));
        this.card_ = context.getPCard(this.id_.toString(), userID);
        if (this.card_ == null) {
            this.card_ = context.createPCard(userID);
        }
        this.saveCard();
        this.card_.store();
    }

    public JDBCBasedPersonalCard(JDBCBasedPersonalCardProvider provider, IDaoPCard card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.initPCardConstants();
        this.provider_ = provider;
        this.card_ = card;
        try {
            this.initFromDAO();
            if (this.pinDigest_ == null) {
                super.setClaims((List)this.getAllClaimsFromDirtyMap(this.dirtyClaimValueMap_));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    public JDBCBasedPersonalCard(JDBCBasedPersonalCardProvider provider, ICardContext context, String userID, Element card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.initPCardConstants();
        this.provider_ = provider;
        this.initFromXML(card);
        IDaoPCard oldCard = context.getPCard(this.id_.toString(), userID);
        if (oldCard != null) {
            oldCard.setDeleteState();
        }
        this.card_ = context.createPCard(userID);
        if (this.pinDigest_ == null) {
            super.setClaims((List)this.getAllClaimsFromDirtyMap(this.dirtyClaimValueMap_));
        }
        this.saveCard();
        if (oldCard != null) {
            oldCard.store();
        }
        this.card_.store();
    }

    public void initPCardConstants() {
        this.isSelfIssued_ = true;
        this.description_ = "cardspace_type";
        this.issuerName_ = "Self";
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.supportedTokenTypes_ = new ArrayList();
        this.supportedTokenTypes_.add(URI.create("urn:oasis:names:tc:SAML:1.0:assertion"));
        this.supportedTokenTypes_.add(URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        this.claimTypes_ = SelfIssuedCardClaims.getSupportedClaimTypeList();
    }

    private ArrayList getAllClaimsFromDirtyMap(HashMap dirtyClaimValueMap) throws CardException {
        ArrayList<ClaimValue> claimValueList = new ArrayList<ClaimValue>();
        ArrayList suppportedTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = suppportedTypes.size();
        for (int i = 0; i < size; ++i) {
            String value;
            Object obj = suppportedTypes.get(i);
            if (!(obj instanceof ISimpleClaimType)) {
                throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$ISimpleClaimType == null ? (class$org$eclipse$higgins$icard$ISimpleClaimType = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.ISimpleClaimType")) : class$org$eclipse$higgins$icard$ISimpleClaimType).getName() + " expected instead of " + obj.getClass().getName());
            }
            ISimpleClaimType cType = (ISimpleClaimType)obj;
            String type = cType.getType();
            String string = value = dirtyClaimValueMap.containsKey(type) ? (String)dirtyClaimValueMap.get(type) : "";
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type)) {
                value = SelfIssuedCardClaims.getGenderClaimValue_TEST((String)value);
            }
            ClaimValue cValue = new ClaimValue(cType, value, (ICard)this);
            claimValueList.add(cValue);
        }
        return claimValueList;
    }

    public void initFromDAO() throws Exception {
        this.initLanguage();
        this.initCardId();
        this.initCardVersion();
        this.initCardName();
        this.initCardImage();
        this.initCardImageType();
        this.initIssuerID();
        this.initTimeIssued();
        this.initTimeExpires();
        this.initHashSalt();
        this.initTimeLastUpdated();
        this.initMasterKey();
        this.initPinDigest();
        this.initDirtyClaims();
    }

    private void initLanguage() {
        this.language_ = this.card_.getLanguage();
    }

    private void initCardId() throws CardException {
        String id = this.card_.getCardID();
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void initCardVersion() {
        this.version_ = String.valueOf(this.card_.getVersion());
    }

    private void initCardName() {
        this.name_ = this.card_.getName();
    }

    private void initCardImage() {
        this.image_ = this.card_.getImage();
    }

    private void initCardImageType() {
        this.imageMimeType_ = this.card_.getImageType();
    }

    private void initIssuerID() {
        this.issuerID_ = this.card_.getIssuerID();
    }

    private void initTimeIssued() {
        this.timeIssued_ = this.card_.getTimeIssued();
    }

    private void initTimeExpires() {
        this.timeExpires_ = this.card_.getTimeExpires();
    }

    private void initDirtyClaims() throws CardException {
        this.dirtyClaimValueMap_ = new HashMap();
        ArrayList suppportedTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = suppportedTypes.size();
        try {
            for (int i = 0; i < size; ++i) {
                Object obj = suppportedTypes.get(i);
                if (!(obj instanceof ClaimType)) {
                    throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$common$ClaimType == null ? (class$org$eclipse$higgins$icard$common$ClaimType = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.common.ClaimType")) : class$org$eclipse$higgins$icard$common$ClaimType).getName() + " expected instead of " + obj.getClass().getName());
                }
                ClaimType cType = (ClaimType)obj;
                String type = cType.getType();
                IDaoPCardClaim daoClaim = this.card_.getPersonalCardClaim(type);
                String value = daoClaim != null ? daoClaim.getValue() : "";
                this.dirtyClaimValueMap_.put(type, value);
            }
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    private void initHashSalt() {
        this.hashSalt_ = this.card_.getHashSalt();
    }

    private void initTimeLastUpdated() {
        this.timeLastUpdated_ = this.card_.getTimeLastUpdated();
    }

    private void initMasterKey() {
        this.masterKey_ = this.card_.getMasterKey();
    }

    private void initPinDigest() {
        this.pinDigest_ = this.card_.getPinDigest();
    }

    public void setName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name != null ? name.trim() : "";
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        if (this.image_ == null) {
            this.image_ = ((JDBCBasedPersonalCardProvider)this.provider_).getDefaultImage();
            this.imageMimeType_ = ((JDBCBasedPersonalCardProvider)this.provider_).getDefaultPictureMIMEType();
        }
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(java.util.Date date) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        java.util.Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws CardException {
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveClaims();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
        this.savePinDigest();
        this.saveIssuerID();
    }

    private void saveLanguage() throws CardException {
        this.card_.setLanguage(this.language_);
    }

    private void saveCardId() throws CardException {
        this.card_.setCardID(this.id_.toString());
    }

    private void saveCardVersion() throws CardException {
        this.card_.setVersion(Integer.parseInt(this.version_));
    }

    private void saveCardName() throws CardException {
        this.card_.setName(this.name_);
    }

    private void saveCardImage() throws CardException {
        this.card_.setImage(this.image_);
    }

    private void saveCardImageType() throws CardException {
        this.card_.setImageType(this.imageMimeType_);
    }

    private void saveTimeIssued() throws CardException {
        Date dt = this.timeIssued_ != null ? new Date(this.timeIssued_.getTime()) : null;
        this.card_.setTimeIssued(dt);
    }

    private void saveTimeExpires() throws CardException {
        Date dt = this.timeExpires_ != null ? new Date(this.timeExpires_.getTime()) : null;
        this.card_.setTimeExpires(dt);
    }

    private void saveHashSalt() throws CardException {
        this.card_.setHashSalt(this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws CardException {
        this.timeLastUpdated_ = new java.util.Date();
        this.card_.setTimeLastUpdated(new Date(this.timeLastUpdated_.getTime()));
    }

    private void saveMasterKey() throws CardException {
        this.card_.setMasterKey(this.masterKey_);
    }

    private void savePinDigest() throws CardException {
        this.card_.setPinDigest(this.pinDigest_);
    }

    private void saveIssuerID() throws CardException {
        this.card_.setIssuerID(this.issuerID_);
    }

    private void saveClaims() throws CardException {
        Hashtable claims = SelfIssuedCardClaims.getSupportedTypesHash();
        Enumeration keys = claims.keys();
        while (keys.hasMoreElements()) {
            IDaoPCardClaim cc;
            String type = (String)keys.nextElement();
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) continue;
            String value = (String)this.dirtyClaimValueMap_.get(type);
            if (value == null || value.trim().length() == 0) {
                cc = this.card_.getPersonalCardClaim(type);
                if (cc == null) continue;
                cc.setDeleteState();
                continue;
            }
            cc = this.card_.getPersonalCardClaim(type);
            if (cc == null) {
                cc = this.card_.createPersonalCardClaim();
                cc.setType(type);
                this.card_.addPersonalCardClaim(cc);
            }
            cc.setValue(value);
        }
    }

    private byte[] convertUTF8ToUTF16(byte[] utf8) throws CardException {
        byte[] utf16 = null;
        if (utf8 != null) {
            try {
                String strUTF8 = new String(utf8, "UTF-8");
                utf16 = strUTF8.getBytes("UTF-16LE");
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return utf16;
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
        byte[] decryptedMasterKey;
        byte[] newInitVector;
        byte[] newSalt;
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldPinDigest = null;
        byte[] oldMasterKey = null;
        EncryptedMasterKey oldEmk = null;
        byte[] newPinCodeUTF8 = pinCodeCredential != null ? pinCodeCredential.getPinCode() : null;
        byte[] newPinCodeUTF16 = this.convertUTF8ToUTF16(newPinCodeUTF8);
        oldPinDigest = this.pinDigest_;
        if (oldPinDigest == null) {
            if (newPinCodeUTF8 == null) {
                this.log.debug((Object)"Attempt to reset pin code for unprotected card. Nothing to do.");
                return;
            }
            newSalt = CardCryptography.getRandomBytes((int)16);
            newInitVector = CardCryptography.getRandomBytes((int)16);
            decryptedMasterKey = this.masterKey_;
            oldMasterKey = this.masterKey_;
        } else {
            if (!this.isClaimsRetrieved()) {
                throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
            }
            oldEmk = this.currentMasterKey_;
            newSalt = oldEmk.getSalt();
            newInitVector = oldEmk.getInitVector();
            decryptedMasterKey = oldEmk.getDecryptedMasterKey();
            oldMasterKey = oldEmk.getEncryptedMasterKey();
        }
        try {
            this.pinDigest_ = newPinCodeUTF16 != null ? CardCryptography.getPinDigest((byte[])newPinCodeUTF16) : null;
            this.savePinDigest();
            if (newPinCodeUTF8 != null) {
                this.currentMasterKey_ = new EncryptedMasterKey(decryptedMasterKey, newSalt, newInitVector, newPinCodeUTF8);
                this.masterKey_ = this.currentMasterKey_.getEncryptedMasterKey();
            } else {
                this.currentMasterKey_ = null;
                this.masterKey_ = decryptedMasterKey;
            }
            this.saveMasterKey();
            Hashtable supportedClaimTypes = SelfIssuedCardClaims.getSupportedTypesHash();
            Enumeration claimTypes = supportedClaimTypes.keys();
            while (claimTypes.hasMoreElements()) {
                String claimType = (String)claimTypes.nextElement();
                String value = this.getClaimValue(claimType, oldEmk);
                this.setClaimValue(claimType, value, this.currentMasterKey_);
            }
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.masterKey_ = oldMasterKey;
            this.pinDigest_ = oldPinDigest;
            this.currentMasterKey_ = oldEmk;
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    public byte[] getMasterKey() throws CardException {
        if (this.pinDigest_ != null) {
            if (!this.isClaimsRetrieved()) {
                throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
            }
            if (this.currentMasterKey_ != null) {
                return this.currentMasterKey_.getDecryptedMasterKey();
            }
            throw new CardException("Claims for this pin-protected card were retrieved but currentMasterKey is null.");
        }
        return this.masterKey_;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.card_.store();
        this.editMode = false;
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.reinitCard();
        this.editMode = false;
    }

    private void reinitCard() throws InvalidStateException {
        try {
            this.initFromDAO();
            this.initClaims();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            new InvalidStateException((Throwable)e);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return true;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new UnsupportedOperationException();
    }

    public IClaim setClaim(IClaim copyFrom) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (copyFrom == null) {
            throw new InvalidClaimException("Passed claim is null.");
        }
        if (!(copyFrom instanceof ISimpleClaim)) {
            throw new InvalidClaimException("Provider \"" + this.getProvider().getName() + "\" supports only claims with type " + (class$org$eclipse$higgins$icard$ISimpleClaim == null ? (class$org$eclipse$higgins$icard$ISimpleClaim = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.ISimpleClaim")) : class$org$eclipse$higgins$icard$ISimpleClaim).getName());
        }
        ISimpleClaim simpleClaim = (ISimpleClaim)copyFrom;
        List lst = simpleClaim.getValues();
        if (lst == null) {
            throw new InvalidClaimException("Passed claim does not contain the values list.");
        }
        String obj = lst.size() != 0 ? (String)lst.get(0) : null;
        String value = obj != null ? obj.toString() : "";
        IClaimType cType = simpleClaim.getType();
        if (cType == null) {
            throw new InvalidTypeException("Claim type is null.");
        }
        String type = cType.getType();
        ClaimType newCT = SelfIssuedCardClaims.getClaimType((String)type);
        if (newCT == null) {
            throw new CardException("Personal card does not support claim type :" + type);
        }
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return new ClaimValue((ISimpleClaimType)newCT, "", (ICard)this);
        }
        SelfIssuedCardClaims.validateClaimValue_TEST((String)type, (String)value);
        byte[] pinDigest = this.getPinDigest();
        if (pinDigest != null && !this.isClaimsRetrieved()) {
            throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
        }
        ClaimValue cv = new ClaimValue((ISimpleClaimType)newCT, value, (ICard)this);
        this.setClaimValue(type, value, this.currentMasterKey_);
        ArrayList<ClaimValue> claims = new ArrayList<ClaimValue>();
        claims.add(cv);
        super.setClaims(claims);
        return cv;
    }

    private void setClaimValue(String type, String value, EncryptedMasterKey emk) throws CardException {
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth".equals(type)) {
            value = SelfIssuedCardClaims.convertICMDate_TEST((String)value);
        } else if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type)) {
            value = SelfIssuedCardClaims.getGenderCode_TEST((String)value);
        }
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return;
        }
        String val = null;
        if (value != null && value.length() != 0) {
            if (emk != null) {
                byte[] newValue;
                try {
                    newValue = CardCryptography.encryptPersonalCardField((byte[])value.getBytes("UTF-16LE"), (byte[])emk.getSalt(), (byte[])emk.getInitVector(), (byte[])emk.getPinCode());
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
                val = CardCryptography.encodeBase64((byte[])newValue, (int)1);
            } else {
                val = value;
            }
        }
        IDaoPCardClaim cc = this.card_.getPersonalCardClaim(type);
        if (val == null) {
            if (cc != null) {
                cc.setDeleteState();
            }
        } else {
            if (cc == null) {
                cc = this.card_.createPersonalCardClaim();
                cc.setType(type);
                this.card_.addPersonalCardClaim(cc);
            }
            cc.setValue(val);
        }
        this.dirtyClaimValueMap_.put(type, val);
        this.saveTimeLastUpdated();
    }

    private String getClaimValue(String type, EncryptedMasterKey emk) throws CardException {
        String dirtyVal;
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return "";
        }
        String value = null;
        IDaoPCardClaim pc = this.card_.getPersonalCardClaim(type);
        String string = dirtyVal = pc != null ? pc.getValue() : null;
        if (emk != null) {
            if (dirtyVal == null || dirtyVal.trim().length() == 0) {
                value = "";
            } else {
                byte[] encryptedData = CardCryptography.decodeBase64((String)dirtyVal);
                byte[] decryptedData = CardCryptography.decryptPersonalCardField((byte[])encryptedData, (EncryptedMasterKey)emk);
                try {
                    value = new String(decryptedData, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e, (Throwable)e);
                    throw new CardException((Throwable)e);
                }
            }
        } else {
            value = dirtyVal;
        }
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type)) {
            value = SelfIssuedCardClaims.getGenderClaimValue_TEST((String)value);
        }
        return value;
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
        this.currentMasterKey_ = this.getEncryptedMasterKey(credential);
        this.initClaims();
    }

    private void initClaims() throws CardException {
        ArrayList<ClaimValue> claimValueList = new ArrayList<ClaimValue>();
        ArrayList suppportedTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = suppportedTypes.size();
        try {
            for (int i = 0; i < size; ++i) {
                Object obj = suppportedTypes.get(i);
                if (!(obj instanceof ClaimType)) {
                    throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$common$ClaimType == null ? (class$org$eclipse$higgins$icard$common$ClaimType = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.common.ClaimType")) : class$org$eclipse$higgins$icard$common$ClaimType).getName() + " expected instead of " + obj.getClass().getName());
                }
                ClaimType cType = (ClaimType)obj;
                String type = cType.getType();
                String val = this.getClaimValue(type, this.currentMasterKey_);
                ClaimValue cValue = new ClaimValue((ISimpleClaimType)cType, val, (ICard)this);
                claimValueList.add(cValue);
            }
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        super.setClaims(claimValueList);
    }

    private EncryptedMasterKey getEncryptedMasterKey(ICredential credential) throws AuthenticationException {
        EncryptedMasterKey emk = null;
        if (this.pinDigest_ != null) {
            if (credential == null) {
                throw new AuthenticationException("Parameter \"credential\" is required for pin protected card.");
            }
            Callback[] cbacks = credential.getCallbacks();
            int size = cbacks.length;
            PinCodeCallback pcc = null;
            for (int i = 0; i < size; ++i) {
                Callback cback = cbacks[i];
                if (!(cback instanceof PinCodeCallback)) continue;
                pcc = (PinCodeCallback)cback;
                break;
            }
            if (pcc != null) {
                try {
                    byte[] pin = pcc.getPin();
                    byte[] digest = CardCryptography.getPinDigest((byte[])this.convertUTF8ToUTF16(pin));
                    if (!Arrays.equals(this.pinDigest_, digest)) {
                        throw new AuthenticationException("Wrong pin code.");
                    }
                    emk = new EncryptedMasterKey(this.masterKey_, pin);
                }
                catch (CardException e) {
                    this.log.error((Object)e);
                    throw new AuthenticationException((Throwable)e);
                }
            } else {
                throw new AuthenticationException("Passed credential does not contain pin code callback (" + (class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback == null ? (class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback = JDBCBasedPersonalCard.class$("org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback")) : class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback).getName() + ")");
            }
        }
        return emk;
    }

    public void setIssuerName(String name) throws CardException {
    }

    public void lock(IPinCodeCredential credential) throws Exception {
    }

    public void unlock(IPinCodeCredential credential) throws Exception {
    }

    public boolean validatePINCode(String pinCode) throws Exception {
        return false;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        throw new CardException("Not implemented");
    }

    public IInformationCardExtension[] getExtensions() {
        return null;
    }

    public boolean hasExtensions() {
        return false;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        throw new CardException("Not implemented");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

