/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.personal.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PersonalCardTemplateHelper;
import org.eclipse.higgins.icard.provider.cardspace.db.ICardContext;
import org.eclipse.higgins.icard.provider.cardspace.db.IDaoPCard;
import org.eclipse.higgins.icard.provider.cardspace.personal.db.JDBCBasedPersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.personal.db.ProviderConfiguration;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCBasedPersonalCardProvider
extends PersonalCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCardProvider = JDBCBasedPersonalCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.personal.db.JDBCBasedPersonalCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCardProvider));
    private static byte[] defaultImage = null;
    private static final String DEFAULT_IMAGE_FILE = "defaultImage.file";
    private static final String DEFAULT_IMAGE_TYPE = "defaultImage.mimeType";
    private ProviderConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.cardspace.personal.db";
    private String name_ = "CardSpace-compatable JDBC-based personal I-Card Provider Plug-in";
    private ICardContext cc_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$personal$db$JDBCBasedPersonalCardProvider;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    private Hashtable getConfigurationProperties() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        IConfiguration cfg = this.getConfiguration();
        Iterator itr = cfg.getPropertyNames();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            String value = cfg.getProperty(key);
            ht.put(key, value);
        }
        return ht;
    }

    public void init() throws CardException {
        String cardContextClassName = this.getConfiguration().getProperty("cardcontext.classname");
        if (cardContextClassName == null) {
            throw new CardException("Can not find \"cardcontext.classname\" configuration property");
        }
        try {
            Class<?> cls = Class.forName(cardContextClassName);
            this.cc_ = (ICardContext)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        Hashtable cfg = this.getConfigurationProperties();
        this.cc_.init((Map)cfg);
    }

    private ICardContext getCardContext() throws CardException {
        if (this.cc_ == null) {
            this.init();
        }
        return this.cc_;
    }

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        ICardContext cc = this.getCardContext();
        String userID = userCrds.getUserID();
        ArrayList<JDBCBasedPersonalCard> lst = new ArrayList<JDBCBasedPersonalCard>();
        Iterator it = cc.getPCards(userID).iterator();
        while (it.hasNext()) {
            try {
                lst.add(new JDBCBasedPersonalCard(this, (IDaoPCard)it.next()));
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return lst.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
            UserCredentials userCrds = this.authenticate(authHandler);
            ICardContext cc = this.getCardContext();
            String userID = userCrds.getUserID();
            JDBCBasedPersonalCard crd = new JDBCBasedPersonalCard(this, cc, userID, card);
            return crd;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<JDBCBasedPersonalCard> cardsList = new ArrayList<JDBCBasedPersonalCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials userCrds = this.authenticate(authHandler);
        ICardContext cc = this.getCardContext();
        String userID = userCrds.getUserID();
        int j = newCards.getLength();
        for (int i = 0; i < j; ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element elm = (Element)nd;
            try {
                JDBCBasedPersonalCard crd = new JDBCBasedPersonalCard(this, cc, userID, elm);
                cardsList.add(crd);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        ICardContext cc = this.getCardContext();
        String userID = userCrds.getUserID();
        IDaoPCard crd = cc.getPCard(card.getID(), userID);
        if (crd == null) {
            throw new CardException("Card not found.");
        }
        crd.setDeleteState();
        crd.store();
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return "JDBC-based CardSpace-interoperable personal I-Card provider";
    }

    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        JDBCBasedPersonalCard pc = null;
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = JDBCBasedPersonalCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card, (boolean)true, (boolean)true) : card;
            UserCredentials userCrds = this.authenticate(authHandler);
            ICardContext cc = this.getCardContext();
            String userID = userCrds.getUserID();
            pc = new JDBCBasedPersonalCard(this, cc, userID, crd);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return pc;
    }

    protected ICard getICardByID(CallbackHandler authHandler, String cardID) throws CardException {
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getUserID();
        ICardContext cc = this.getCardContext();
        IDaoPCard crd = cc.getPCard(cardID, userID);
        if (crd != null) {
            try {
                return new JDBCBasedPersonalCard(this, crd);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        Callback[] callbacks = new Callback[]{nc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        return new UserCredentials(userName);
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        if (authHandler == null) {
            this.log.info((Object)"Can not create card. Parameter \"authHandler\" is null.");
            return false;
        }
        if (id == null) {
            this.log.info((Object)"Can not create card. Parameter \"id\" is null.");
            return false;
        }
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            String userID = userCrds.getUserID();
            ICardContext cc = this.getCardContext();
            IDaoPCard crd = cc.getPCard(id, userID);
            if (crd != null) {
                this.log.info((Object)("Can not create card. Card with ID = " + id + " already exists."));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (id == null) {
            throw new CardException("Parameter \"id\" is null");
        }
        URI cardID = null;
        try {
            cardID = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getUserID();
        ICardContext cc = this.getCardContext();
        try {
            JDBCBasedPersonalCard card = new JDBCBasedPersonalCard(this, cc, userID, cardID, null, null, null, null);
            return card;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public String getPictureMIMEType(byte[] picure) {
        return "image/jpeg";
    }

    public String getDefaultPictureMIMEType() {
        return this.getConfiguration().getProperty(DEFAULT_IMAGE_TYPE);
    }

    public byte[] getDefaultImage() {
        if (defaultImage == null) {
            return this.readDefaultImage();
        }
        return defaultImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized byte[] readDefaultImage() {
        block14: {
            block15: {
                String fileName;
                block16: {
                    if (defaultImage != null) {
                        return defaultImage;
                    }
                    fileName = this.getConfiguration().getProperty(DEFAULT_IMAGE_FILE);
                    if (fileName == null) break block15;
                    File file = new File(fileName);
                    if (!file.exists() || !file.isFile()) break block16;
                    long fileLength = file.length();
                    if (fileLength > Integer.MAX_VALUE) {
                        this.log.error((Object)"IdASBasedPersonalCardProvider.getDefaultImage - too long default image file size.");
                        return null;
                    }
                    int size = (int)fileLength;
                    int offset = 0;
                    int len = size;
                    FileInputStream fis = null;
                    fis = new FileInputStream(file);
                    int count = 0;
                    byte[] image = new byte[size];
                    do {
                        if ((count = fis.read(image, offset, len)) == len) continue;
                        offset += count;
                        len -= count;
                    } while (count != -1);
                    defaultImage = image;
                    Object var12_11 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        this.log.error((Object)e2);
                    }
                    break block14;
                    {
                        catch (IOException e) {
                            this.log.error((Object)e);
                            Object var12_12 = null;
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                                break block14;
                            }
                            catch (IOException e2) {
                                this.log.error((Object)e2);
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e2) {
                            this.log.error((Object)e2);
                        }
                        throw throwable;
                    }
                }
                this.log.error((Object)("IdASBasedPersonalCardProvider.getDefaultImage - default image file " + fileName + " does not exist."));
                break block14;
            }
            this.log.error((Object)"IdASBasedPersonalCardProvider.getDefaultImage - can not get the name of default image.");
        }
        return defaultImage;
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        String picStr;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        String cardName = null;
        ITemplateValue nameTV = template.getTemplateValueByID("cardName");
        if (nameTV != null) {
            cardName = nameTV.getValue();
        }
        byte[] picture = null;
        String pictureType = null;
        ITemplateValue pictureTV = template.getTemplateValueByID("cardPicture");
        if (pictureTV != null && (picStr = pictureTV.getValue()) != null) {
            picture = CardCryptography.decodeBase64((String)picStr);
            pictureType = this.getPictureMIMEType(picture);
        }
        if (picture == null) {
            picture = this.getDefaultImage();
            pictureType = this.getDefaultPictureMIMEType();
        }
        HashMap dirtyClaims = PersonalCardTemplateHelper.getDirtyClaimsFromCardTemplate((ICardTemplate)template);
        UserCredentials userCrds = this.authenticate(authHandler);
        String userID = userCrds.getUserID();
        ICardContext cc = this.getCardContext();
        try {
            JDBCBasedPersonalCard card = new JDBCBasedPersonalCard(this, cc, userID, URI.create("urn:" + UUIDGenerator.getUUID()), cardName, dirtyClaims, picture, pictureType);
            return card;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return new ICardTemplate[]{PersonalCardTemplateHelper.getCardTemplate((ICardProvider)this)};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String userID_;

        public UserCredentials(String userID) {
            this.userID_ = userID;
        }

        public String getUserID() {
            return this.userID_;
        }
    }
}

