/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.personal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.EncryptedMasterKey;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.IdASContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCardProvider;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchSubjectException;
import org.w3c.dom.Element;

public class IdASBasedPersonalCard
extends PersonalCard {
    private CallbackHandler callbackHandler_ = null;
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCard")) : class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard));
    private IDigitalSubject card_ = null;
    private IDigitalSubject claimList_ = null;
    private boolean editMode = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ISimpleClaim;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$ClaimType;

    public IdASBasedPersonalCard() {
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, CallbackHandler callbackHandler, IContext ctx, URI cardId, String cardName, ArrayList claims, byte[] image, String imageMimeType) throws CardException {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (cardId == null) {
            throw new CardException("Parameter \"cardId\" is null");
        }
        if (callbackHandler == null) {
            throw new CardException("Parameter \"callbackHandler\" is null");
        }
        this.provider_ = provider;
        this.id_ = cardId;
        this.callbackHandler_ = callbackHandler;
        this.description_ = "cardspace_type";
        this.isSelfIssued_ = true;
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.issuerName_ = "Self";
        this.version_ = "1";
        this.timeIssued_ = new Date();
        this.supportedTokenTypes_ = new ArrayList();
        this.supportedTokenTypes_.add(URI.create("urn:oasis:names:tc:SAML:1.0:assertion"));
        this.supportedTokenTypes_.add(URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        this.name_ = cardName != null ? cardName : "Selfish";
        this.masterKey_ = SecureRandom.getSeed(32);
        this.hashSalt_ = SecureRandom.getSeed(32);
        if (image != null && imageMimeType != null) {
            this.image_ = image;
            this.imageMimeType_ = imageMimeType;
        }
        this.claimTypes_ = SelfIssuedCardClaims.getSupportedClaimTypeList();
        this.tmpClaimValueList_ = claims != null ? claims : new ArrayList();
        try {
            try {
                this.card_ = ctx.getSubject(this.id_.toString());
                throw new CardException("Couldn't create card. Card with id = " + cardId + " already exists.");
            }
            catch (NoSuchSubjectException e) {
                this.card_ = ctx.addSubject(IdASContext.ICARD_PersonalInformationCard, this.id_.toString());
                this.saveClaimTypes();
                this.initClaimListSubject(true);
                this.saveCard();
                ctx.applyUpdates();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                ctx.cancelUpdates();
            }
            catch (IdASException e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, CallbackHandler callbackHandler, IDigitalSubject card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (callbackHandler == null) {
            throw new CardException("Parameter \"callbackHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.provider_ = provider;
        this.callbackHandler_ = callbackHandler;
        this.card_ = card;
        this.description_ = "cardspace_type";
        this.issuerName_ = "Self";
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.initClaimListSubject(false);
        this.initFromDS(this.card_, this.claimList_);
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, CallbackHandler callbackHandler, IContext ctx, Element card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (callbackHandler == null) {
            throw new CardException("Parameter \"callbackHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.provider_ = provider;
        this.description_ = "cardspace_type";
        this.issuerName_ = "Self";
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.initFromXML(card);
        try {
            try {
                this.card_ = ctx.getSubject(this.id_.toString());
            }
            catch (NoSuchSubjectException e) {
                this.card_ = ctx.addSubject(IdASContext.ICARD_PersonalInformationCard, this.id_.toString());
                this.saveClaimTypes();
            }
            this.initClaimListSubject(true);
            this.saveCard();
            ctx.applyUpdates();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                ctx.cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException(e1.getMessage());
            }
            throw new CardException(e.getMessage());
        }
    }

    private IDigitalSubject createClaimListSubject() throws IdASException, CardException {
        if (this.card_ == null) {
            throw new CardException("Variable \"card_\" is null.");
        }
        IContext ctx = this.card_.getContext();
        String clamListSubjectID = String.valueOf(System.currentTimeMillis());
        IDigitalSubject claimList = ctx.addSubject(IdASContext.ICARD_ClaimList, clamListSubjectID);
        IComplexAttrValue cv = claimList.getSingleValuedAttribute(IdASContext.ICARD_cardReference).addComplexValue(null);
        cv.getSingleValuedAttribute(IdASContext.ICARD_subjectCardReference).addSimpleValue(null, (Object)this.card_.getSubjectID());
        cv.getSingleValuedAttribute(IdASContext.ICARD_contextCardReference).addSimpleValue(null, (Object)ctx.getContextRef());
        return claimList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initClaimListSubject(boolean createNew) throws IdASException, CardException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_claimValueListRef);
        IAttributeValue val = attr.getValue();
        if (val != null) {
            IDigitalSubject claimList;
            if (val.isSimple()) throw new CardException("Attribute " + IdASContext.ICARD_claimValueListRef + " should be complex");
            String subjID = null;
            IComplexAttrValue listRef = (IComplexAttrValue)val;
            Object subj = this.getSimpleValueData(listRef, IdASContext.ICARD_claimValueListSubject);
            if (subj != null) {
                subjID = subj.toString();
            }
            if ((claimList = this.card_.getContext().getSubject(subjID)) == null) {
                throw new CardException("Couldn't get the claim list subject reference for card with ID = " + this.card_.getSubjectID() + " .");
            }
            this.claimList_ = claimList;
            return;
        } else {
            if (!createNew) {
                throw new CardException("Couldn't get the claim list reference for card with ID = " + this.card_.getSubjectID() + ". This card doesn't have any value with type" + IdASContext.ICARD_claimValueListRef + ".");
            }
            this.claimList_ = this.createClaimListSubject();
            IComplexAttrValue cv = attr.addComplexValue(null);
            cv.getSingleValuedAttribute(IdASContext.ICARD_claimValueListSubject).addSimpleValue(null, (Object)this.claimList_.getSubjectID());
            cv.getSingleValuedAttribute(IdASContext.ICARD_claimValueListContext).addSimpleValue(null, (Object)this.claimList_.getContext().getContextRef().toString());
        }
    }

    public void initFromDS(IDigitalSubject card, IDigitalSubject claimList) throws Exception {
        this.initIsSelfIssued(card);
        this.initLanguage(card);
        this.initCardId(card);
        this.initCardVersion(card);
        this.initCardName(card);
        this.initCardImage(card);
        this.initCardImageType(card);
        this.initTimeIssued(card);
        this.initTimeExpires(card);
        this.initSupportedTokenTypes(card);
        this.initClaimTypes(card);
        this.initHashSalt(card);
        this.initTimeLastUpdated(card);
        this.initMasterKey(card);
        this.initPinDigest(card);
    }

    private void initIsSelfIssued(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.isSelfIssued_ = true;
        Boolean issi = (Boolean)this.getSimpleValueData(card, IdASContext.ICARD_isSelfIssued);
        if (issi != null && !issi.booleanValue()) {
            throw new CardException("Can not init managed card with DigitalSubject storing data of self-issued (Personal) card");
        }
    }

    private void initLanguage(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.language_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_language);
    }

    private void initCardId(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        String id = (String)this.getSimpleValueData(card, IdASContext.HIGGINS_uniqueIdentifier);
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void initCardVersion(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.version_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_version);
    }

    private void initCardName(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.name_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_name);
    }

    private void initCardImage(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.image_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_image);
    }

    private void initCardImageType(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.imageMimeType_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_imageMimeType);
    }

    private void initTimeIssued(IDigitalSubject card) throws IdASException, CardException {
        this.timeIssued_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeIssued);
        if (obj != null) {
            this.timeIssued_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeExpires(IDigitalSubject card) throws IdASException, CardException {
        this.timeExpires_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_expiredTime);
        if (obj != null) {
            this.timeExpires_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initSupportedTokenTypes(IDigitalSubject card) throws IdASException, CardException {
        this.supportedTokenTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple()) {
                Object obj;
                ISimpleAttrValue sv = (ISimpleAttrValue)val;
                if (sv == null || (obj = sv.getData()) == null) continue;
                if (obj instanceof URI) {
                    this.supportedTokenTypes_.add(obj);
                    continue;
                }
                try {
                    this.supportedTokenTypes_.add(new URI(obj.toString()));
                    continue;
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            throw new CardException("Attribute " + IdASContext.ICARD_supportedTokenType + " contains non simple value");
        }
    }

    private void initClaimTypes(IDigitalSubject card) throws IdASException, CardException {
        this.claimTypes_ = SelfIssuedCardClaims.getSupportedClaimTypeList();
    }

    private void initHashSalt(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.hashSalt_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_hashSalt);
    }

    private void initTimeLastUpdated(IDigitalSubject card) throws IdASException, CardException {
        this.timeLastUpdated_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeLastUpdated);
        if (obj != null) {
            this.timeLastUpdated_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initMasterKey(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.masterKey_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_masterKey);
    }

    private void initPinDigest(IDigitalSubject card) throws IdASException, CardException, ClassCastException {
        this.pinDigest_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_pinDigest);
    }

    public void setName(String name) throws CardException {
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String oldName = this.name_;
        this.name_ = name.trim();
        try {
            this.saveCardName();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (image == null) {
            throw new CardException("Couldn't set null card image.");
        }
        if (imageMimeType == null) {
            throw new CardException("Couldn't set null card image MIME type.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
            this.card_.getContext().applyUpdates();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public void setDisplayName(String name) throws CardException {
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String newName = name.trim();
        try {
            ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
            attr.addSimpleValue(null, (Object)newName);
            this.card_.getContext().applyUpdates();
            this.name_ = newName;
        }
        catch (IdASException e) {
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String newName = name.trim();
        try {
            ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
            attr.addSimpleValue(null, (Object)newName);
            this.card_.getContext().applyUpdates();
            this.issuerName_ = newName;
        }
        catch (IdASException e) {
            throw new CardException((Throwable)e);
        }
    }

    public void setCardImage(byte[] image, String imageMimeType) throws CardException {
        if (image == null) {
            throw new CardException("Couldn't set null card image.");
        }
        if (imageMimeType == null) {
            throw new CardException("Couldn't set null card image MIME type.");
        }
        try {
            ISingleValuedAttribute attrImg = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
            attrImg.addSimpleValue(null, (Object)image);
            ISingleValuedAttribute attrType = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
            attrType.addSimpleValue(null, (Object)imageMimeType);
            this.card_.getContext().applyUpdates();
            this.image_ = image;
            this.imageMimeType_ = imageMimeType;
        }
        catch (IdASException e) {
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(Date date) throws CardException {
        try {
            ISingleValuedAttribute attrImg = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
            attrImg.addSimpleValue(null, (Object)date);
            this.card_.getContext().applyUpdates();
            this.timeExpires_ = date;
        }
        catch (IdASException e) {
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws IdASException, CardException {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveSupportedTokenTypes();
        this.saveClaimTypes();
        this.saveClaims();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
        this.savePinDigest();
    }

    private void saveIsSelfIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_isSelfIssued);
        attr.addSimpleValue(null, (Object)this.isSelfIssued_);
    }

    private void saveLanguage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_language);
        attr.addSimpleValue(null, (Object)this.language_);
    }

    private void saveCardId() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.HIGGINS_uniqueIdentifier);
        attr.addSimpleValue(null, (Object)this.id_);
    }

    private void saveCardVersion() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_version);
        attr.addSimpleValue(null, (Object)this.version_);
    }

    private void saveCardName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
        attr.addSimpleValue(null, (Object)this.name_);
    }

    private void saveCardImage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
        attr.addSimpleValue(null, (Object)this.image_);
    }

    private void saveCardImageType() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
        attr.addSimpleValue(null, (Object)this.imageMimeType_);
    }

    private void saveIssuer() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuer);
        attr.addSimpleValue(null, (Object)this.issuer_);
    }

    private void saveIssuerName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
        attr.addSimpleValue(null, (Object)this.issuerName_);
    }

    private void saveTimeIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeIssued);
        attr.addSimpleValue(null, (Object)this.timeIssued_);
    }

    private void saveTimeExpires() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
        attr.addSimpleValue(null, (Object)this.timeExpires_);
    }

    private void saveSupportedTokenTypes() throws IdASException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            attr.addSimpleValue(null, (Object)uri);
        }
    }

    private void saveClaimTypes() throws IdASException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType claimType = (IClaimType)it.next();
            IComplexAttrValue val = attr.addComplexValue(null);
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeType).addSimpleValue(null, (Object)claimType.getType());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeDescription).addSimpleValue(null, (Object)claimType.getDescription());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeName).addSimpleValue(null, (Object)claimType.getDisplayName());
        }
    }

    private void saveHashSalt() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_hashSalt);
        attr.addSimpleValue(null, (Object)this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws IdASException {
        this.timeLastUpdated_ = new Date();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeLastUpdated);
        attr.addSimpleValue(null, (Object)this.timeLastUpdated_);
    }

    private void saveMasterKey() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_masterKey);
        attr.addSimpleValue(null, (Object)this.masterKey_);
    }

    private void savePinDigest() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_pinDigest);
        attr.addSimpleValue(null, (Object)this.pinDigest_);
    }

    private void saveClaims() throws IdASException, CardException {
        Hashtable claims = SelfIssuedCardClaims.getSupportedTypesHash();
        Iterator values = this.tmpClaimValueList_.iterator();
        while (values.hasNext()) {
            ClaimValue claimValue = (ClaimValue)values.next();
            String val = claimValue.getValue();
            String type = claimValue.getType().getType();
            if (type == null) {
                throw new CardException("Claim type is null.");
            }
            if (claims.containsKey(type)) {
                if (val == null) continue;
                claims.put(type, val);
                continue;
            }
            throw new CardException("Unsupported claim type : " + type);
        }
        Enumeration keys = claims.keys();
        while (keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            String value = (String)claims.get(type);
            URI typeURI = null;
            try {
                typeURI = new URI(type);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException("Wrong claim type URI : \n" + e.getMessage());
            }
            ISingleValuedAttribute sa = this.claimList_.getSingleValuedAttribute(typeURI);
            if (value.trim().length() == 0) {
                sa.remove();
                continue;
            }
            sa.addSimpleValue(null, (Object)value.trim());
        }
    }

    public IDigitalSubject getCardSubject() throws CardException {
        return this.card_;
    }

    public IDigitalSubject getClaimListSubject() throws CardException {
        return this.claimList_;
    }

    private byte[] askPinCode(String hint, byte[] pinDigest) throws CardException {
        PasswordCallback pc = new PasswordCallback(hint, false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            this.callbackHandler_.handle(callbacks);
            char[] pass = pc.getPassword();
            pc.clearPassword();
            if (pass == null || pass.length == 0) {
                throw new CardException("User did not enter pin code.");
            }
            String pinCode = new String(pass);
            byte[] digest = CardCryptography.getPinDigest((String)pinCode);
            if (Arrays.equals(pinDigest, digest)) {
                return pinCode.getBytes("UTF-8");
            }
            throw new CardException("User provided the wrong pin code.");
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public ICardProvider getProvider() {
        return this.provider_;
    }

    private Object getSimpleValueData(IComplexAttrValue val, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = val.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(IDigitalSubject subj, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(ISingleValuedAttribute attr) throws IdASException, CardException {
        IAttributeValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getAttrID() != null ? attr.getAttrID().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public void setPinCode(String pinCode) throws CardException {
        byte[] newInitVector;
        byte[] newSalt;
        this.log.debug((Object)("Set pincode = " + pinCode));
        byte[] oldPinCode = null;
        byte[] oldPinDigest = null;
        byte[] oldMasterKey = null;
        EncryptedMasterKey oldEmk = null;
        try {
            oldPinDigest = (byte[])this.getSimpleValueData(this.card_, IdASContext.ICARD_pinDigest);
            if (pinCode == null && oldPinDigest == null) {
                this.log.debug((Object)"");
                return;
            }
            oldMasterKey = (byte[])this.getSimpleValueData(this.card_, IdASContext.ICARD_masterKey);
        }
        catch (ClassCastException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (oldPinDigest != null) {
            oldPinCode = this.askPinCode("Enter old pin code: ", oldPinDigest);
            oldEmk = new EncryptedMasterKey(oldMasterKey, oldPinCode);
            newSalt = oldEmk.getSalt();
            newInitVector = oldEmk.getInitVector();
        } else {
            newSalt = CardCryptography.getRandomBytes((int)16);
            newInitVector = CardCryptography.getRandomBytes((int)16);
        }
        byte[] newPinDigest = null;
        try {
            if (pinCode != null) {
                newPinDigest = CardCryptography.getPinDigest((String)pinCode);
            }
            this.card_.getSingleValuedAttribute(IdASContext.ICARD_pinDigest).addSimpleValue(null, (Object)newPinDigest);
            if (oldPinDigest != null) {
                oldMasterKey = oldEmk.getDecryptedMasterKey();
            }
            byte[] newMasterKey = null;
            newMasterKey = pinCode != null ? CardCryptography.encryptMasterKey((byte[])oldMasterKey, (byte[])newSalt, (byte[])newInitVector, (byte[])pinCode.getBytes("UTF-8")) : oldMasterKey;
            this.card_.getSingleValuedAttribute(IdASContext.ICARD_masterKey).addSimpleValue(null, (Object)newMasterKey);
            IAttribute attr = this.claimList_.getAttribute(IdASContext.ICARD_claim);
            Iterator itr = attr.getValues();
            while (itr.hasNext()) {
                IComplexAttrValue cv = (IComplexAttrValue)itr.next();
                ISimpleAttrValue attrValue = (ISimpleAttrValue)cv.getSingleValuedAttribute(IdASContext.ICARD_valueOfClaim).getValue();
                String value = null;
                if (attrValue == null || (value = (String)attrValue.getData()) == null || value.length() <= 0) continue;
                if (oldPinDigest != null) {
                    byte[] encryptedData = CardCryptography.decodeBase64((String)value);
                    byte[] decryptedData = CardCryptography.decryptPersonalCardField((byte[])encryptedData, (EncryptedMasterKey)oldEmk);
                    value = new String(decryptedData, "UTF-16LE");
                }
                if (pinCode != null) {
                    byte[] newValue = CardCryptography.encryptPersonalCardField((byte[])value.getBytes("UTF-16LE"), (byte[])newSalt, (byte[])newInitVector, (byte[])pinCode.getBytes("UTF-8"));
                    value = CardCryptography.encodeBase64((byte[])newValue, (int)1);
                }
                attrValue.setData((Object)value);
            }
            this.card_.getContext().applyUpdates();
            this.pinDigest_ = newPinDigest;
            this.masterKey_ = newMasterKey;
        }
        catch (Exception e) {
            try {
                this.card_.getContext().cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException(e1.getMessage());
            }
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public byte[] getMasterKey() throws CardException {
        try {
            byte[] masterKey = (byte[])this.getSimpleValueData(this.card_, IdASContext.ICARD_masterKey);
            byte[] pinDigest = (byte[])this.getSimpleValueData(this.card_, IdASContext.ICARD_pinDigest);
            if (pinDigest != null) {
                byte[] pinCode = this.askPinCode("Enter old pin code: ", pinDigest);
                EncryptedMasterKey oldEmk = new EncryptedMasterKey(masterKey, pinCode);
                return oldEmk.getDecryptedMasterKey();
            }
            return masterKey;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        try {
            this.card_.getContext().applyUpdates();
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.editMode = false;
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().cancelUpdates();
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new InvalidStateException(e.getMessage());
        }
        this.editMode = false;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return true;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new UnsupportedOperationException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException, CardException {
        if (copyFrom == null) {
            throw new InvalidClaimException("Passed claim is null.");
        }
        if (!(copyFrom instanceof ISimpleClaim)) {
            throw new InvalidClaimException("Provider \"" + this.getProvider().getName() + "\" supports only claims with type " + (class$org$eclipse$higgins$icard$ISimpleClaim == null ? (class$org$eclipse$higgins$icard$ISimpleClaim = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.ISimpleClaim")) : class$org$eclipse$higgins$icard$ISimpleClaim).getName());
        }
        ISimpleClaim simpleClaim = (ISimpleClaim)copyFrom;
        List lst = simpleClaim.getValues();
        if (lst == null) {
            throw new InvalidClaimException("Passed claim does not contain the values list.");
        }
        String obj = lst.size() != 0 ? (String)lst.get(0) : null;
        String value = obj != null ? obj.toString() : "";
        IClaimType cType = simpleClaim.getType();
        if (cType == null) {
            throw new InvalidTypeException("Claim type is null.");
        }
        String type = cType.getType();
        ClaimType newCT = SelfIssuedCardClaims.getClaimType((String)type);
        if (newCT == null) {
            throw new CardException("Personal card does not support claim type :" + type);
        }
        byte[] pinDigest = this.getPinDigest();
        EncryptedMasterKey emk = null;
        if (pinDigest != null) {
            byte[] masterKey = this.getMasterKey();
            byte[] pinCode = pinDigest != null ? this.askPinCode("Enter pin code: ", pinDigest) : null;
            emk = new EncryptedMasterKey(masterKey, pinCode);
        }
        ClaimValue cv = new ClaimValue((ISimpleClaimType)newCT, value, (ICard)this);
        try {
            this.setClaim(type, value, emk);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cv;
    }

    private void setClaim(String type, String value, EncryptedMasterKey emk) throws CardException, UnsupportedEncodingException, IdASException {
        String val = null;
        if (emk != null) {
            byte[] newValue = CardCryptography.encryptPersonalCardField((byte[])value.getBytes("UTF-16LE"), (byte[])emk.getSalt(), (byte[])emk.getInitVector(), (byte[])emk.getPinCode());
            val = CardCryptography.encodeBase64((byte[])newValue, (int)1);
        } else {
            val = value;
        }
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.claimList_.getSingleValuedAttribute(typeURI).addSimpleValue(null, (Object)val);
    }

    private String getClaimValue(String type, EncryptedMasterKey emk) throws CardException {
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        String value = null;
        String dirtyVal = (String)this.getSimpleValueData(this.claimList_, typeURI);
        if (emk != null) {
            if (dirtyVal == null || dirtyVal.trim().length() == 0) {
                value = "";
            } else {
                byte[] encryptedData = CardCryptography.decodeBase64((String)dirtyVal);
                byte[] decryptedData = CardCryptography.decryptPersonalCardField((byte[])encryptedData, (EncryptedMasterKey)emk);
                try {
                    value = new String(decryptedData, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e);
                    throw new CardException(e.getMessage());
                }
            }
        } else {
            value = dirtyVal;
        }
        return value;
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
        ArrayList<ClaimValue> claimValueList = new ArrayList<ClaimValue>();
        if (this.claimList_ == null) {
            return;
        }
        EncryptedMasterKey emk = this.getEncryptedMasterKey(credential);
        ArrayList suppportedTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = suppportedTypes.size();
        for (int i = 0; i < size; ++i) {
            Object obj = suppportedTypes.get(i);
            if (!(obj instanceof ClaimType)) {
                throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$common$ClaimType == null ? (class$org$eclipse$higgins$icard$common$ClaimType = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.common.ClaimType")) : class$org$eclipse$higgins$icard$common$ClaimType).getName() + " expected instead of " + obj.getClass().getName());
            }
            ClaimType cType = (ClaimType)obj;
            String type = cType.getType();
            String val = this.getClaimValue(type, emk);
            ClaimValue cValue = new ClaimValue((ISimpleClaimType)cType, val, (ICard)this);
            claimValueList.add(cValue);
        }
        this.setClaims(claimValueList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EncryptedMasterKey getEncryptedMasterKey(ICredential credential) throws AuthenticationException {
        EncryptedMasterKey emk = null;
        if (this.pinDigest_ == null) return emk;
        if (credential == null) throw new AuthenticationException();
        if (!(credential instanceof IPinCodeCredential)) throw new AuthenticationException();
        IPinCodeCredential pc = (IPinCodeCredential)credential;
        try {
            byte[] pin = pc.getPinCode();
            String pinCode = new String(pin);
            byte[] digest = CardCryptography.getPinDigest((String)pinCode);
            if (!Arrays.equals(this.pinDigest_, digest)) return emk;
            return new EncryptedMasterKey(this.masterKey_, pin);
        }
        catch (CardException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

