/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.personal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.IdASContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.PersonalCardTemplateHelper;
import org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.personal.ProviderConfiguration;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterTypeAssertion;
import org.eclipse.higgins.idas.api.NoSuchSubjectException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdASBasedPersonalCardProvider
implements ICardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCardProvider = IdASBasedPersonalCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCardProvider));
    private static final String CONTEXT_ID = "context.id";
    private static final String DEFAULT_IMAGE_FILE = "defaultImage.file";
    private static final String DEFAULT_IMAGE_TYPE = "defaultImage.type";
    private IdASRegistry reg_ = IdASRegistry.getInstance();
    private ProviderConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.cardspace.personal";
    private String name_ = "CardSpace-compatable personal I-Card Provider Plug-in";
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCardProvider;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IPersonalInformationCard;

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    private IContext getContext(UserCredentials credentials) throws CardException {
        IContext ctx = null;
        if (this.config_ != null) {
            String contextID = this.getConfiguration().getProperty(CONTEXT_ID);
            if (contextID == null) {
                throw new CardException("Can not get \"context.id\" configuration property.");
            }
            try {
                ctx = this.reg_.createContext(contextID);
                AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, credentials.getName(), credentials.getPassword());
                ctx.open((Object)credential);
                return ctx;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return null;
    }

    public Iterator getICards(CallbackHandler authHandler, IPolicy policy) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        ArrayList<IdASBasedPersonalCard> cards = new ArrayList<IdASBasedPersonalCard>();
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                IFilter filter = ctx.buildFilter();
                filter.setOperator("urn:eclipse.higgins.idas.OP_AND");
                IFilterTypeAssertion typeAssertion = ctx.buildTypeAssertion();
                typeAssertion.setAssertionValue(IdASContext.ICARD_PersonalInformationCard);
                filter.addFilter((IFilterAssertion)typeAssertion);
                Iterator subjList = ctx.getSubjects(filter);
                while (subjList.hasNext()) {
                    IDigitalSubject subj = (IDigitalSubject)subjList.next();
                    if (!IdASContext.ICARD_PersonalInformationCard.equals(subj.getType())) continue;
                    IdASBasedPersonalCard card = new IdASBasedPersonalCard(this, authHandler, subj);
                    if (policy == null) {
                        cards.add(card);
                        continue;
                    }
                    if (!policy.isSatisfiedBy((ICard)card)) continue;
                    cards.add(card);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cards.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element card = CardCryptography.getCardFromSignedEnvelop((InputStream)is);
            UserCredentials credentials = this.authenticate(authHandler);
            IContext ctx = this.getContext(credentials);
            if (ctx != null) {
                IdASBasedPersonalCard pic = new IdASBasedPersonalCard(this, authHandler, ctx, card);
                return pic;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<IdASBasedPersonalCard> cardsList = new ArrayList<IdASBasedPersonalCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        UserCredentials credentials = this.authenticate(authHandler);
        IContext ctx = this.getContext(credentials);
        if (ctx != null) {
            for (int i = 0; i < newCards.getLength(); ++i) {
                Node nd = newCards.item(i);
                if (nd.getNodeType() != 1) continue;
                Element elm = (Element)nd;
                try {
                    IdASBasedPersonalCard crd = new IdASBasedPersonalCard(this, authHandler, ctx, elm);
                    cardsList.add(crd);
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null && card instanceof IdASBasedPersonalCard) {
            try {
                IdASBasedPersonalCard crd = (IdASBasedPersonalCard)card;
                String subjId = crd.getCardSubject().getSubjectID();
                IDigitalSubject subj = ctx.getSubject(subjId);
                subj.remove();
                String claimId = crd.getClaimListSubject().getSubjectID();
                IDigitalSubject claimList = ctx.getSubject(claimId);
                claimList.remove();
                ctx.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                try {
                    ctx.cancelUpdates();
                }
                catch (Exception e1) {
                    this.log.error((Object)e1);
                    throw new CardException((Throwable)e1);
                }
                throw new CardException((Throwable)e);
            }
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        if (authHandler == null) {
            this.log.info((Object)"Can not create card. Parameter \"authHandler\" is null.");
            return false;
        }
        if (id == null) {
            this.log.info((Object)"Can not create card. Parameter \"id\" is null.");
            return false;
        }
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                try {
                    ctx.getSubject(id);
                    this.log.info((Object)("Can not create card. Card with ID = " + id + " already exists."));
                    return false;
                }
                catch (NoSuchSubjectException e) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (id == null) {
            throw new CardException("Parameter \"id\" is null");
        }
        URI cardID = null;
        try {
            cardID = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null) {
            return new IdASBasedPersonalCard(this, authHandler, ctx, cardID, null, null, null, null);
        }
        throw new CardException("Can not initialize the IdAS context.");
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable personal I-Card provider";
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IPersonalInformationCard == null ? (class$org$eclipse$higgins$icard$IPersonalInformationCard = IdASBasedPersonalCardProvider.class$("org.eclipse.higgins.icard.IPersonalInformationCard")) : class$org$eclipse$higgins$icard$IPersonalInformationCard};
    }

    public boolean canImportICard(CallbackHandler authHandler, Element card) {
        IdASBasedPersonalCard crd = new IdASBasedPersonalCard();
        try {
            crd.initFromXML(card);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    public void exportICard(CallbackHandler authHandler, ICard card, Element root) throws CardException {
        Document doc = root.getOwnerDocument();
        if (!(card instanceof IInformationCard)) {
            throw new CardException("Can not export card. This card is not an instance of IInformationCard.");
        }
        IInformationCard icard = (IInformationCard)card;
        Element roamingCard = icard.toXML(doc);
        root.appendChild(roamingCard);
    }

    public ICard importICard(CallbackHandler authHandler, Element card) throws CardException {
        try {
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop((Element)card) : card;
            UserCredentials credentials = this.authenticate(authHandler);
            IContext ctx = this.getContext(credentials);
            if (ctx != null) {
                IdASBasedPersonalCard mic = new IdASBasedPersonalCard(this, authHandler, ctx, crd);
                return mic;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                IDigitalSubject subj = ctx.getSubject(CUID2);
                IdASBasedPersonalCard card = new IdASBasedPersonalCard(this, authHandler, subj);
                return card;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByCUID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        String password = new String(pc.getPassword());
        pc.clearPassword();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new CardException("Empty password.");
        }
        return new UserCredentials(userName, password);
    }

    public String getPictureMIMEType(byte[] picure) {
        return "image/jpeg";
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        String picStr;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        String cardName = null;
        ITemplateValue nameTV = template.getTemplateValueByID("cardName");
        if (nameTV != null) {
            cardName = nameTV.getValue();
        }
        byte[] picture = null;
        String pictureType = null;
        ITemplateValue pictureTV = template.getTemplateValueByID("cardPicture");
        if (pictureTV != null && (picStr = pictureTV.getValue()) != null) {
            picture = CardCryptography.decodeBase64((String)picStr);
            pictureType = this.getPictureMIMEType(picture);
        }
        ArrayList claims = PersonalCardTemplateHelper.getClaimsFromCardTemplate((ICardTemplate)template);
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null) {
            return new IdASBasedPersonalCard(this, authHandler, ctx, URI.create("urn:" + String.valueOf(System.currentTimeMillis())), cardName, claims, picture, pictureType);
        }
        throw new CardException("Can not initialize the IdAS context.");
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return new ICardTemplate[]{PersonalCardTemplateHelper.getCardTemplate((ICardProvider)this)};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserCredentials {
        private String name_;
        private String password_;

        public UserCredentials(String name, String password) {
            this.password_ = password;
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public String getPassword() {
            return this.password_;
        }
    }
}

