/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.personal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;
import org.eclipse.higgins.icard.common.utils.DateConvertor;
import org.eclipse.higgins.icard.common.utils.IdASContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.EncryptedMasterKey;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCardProvider;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.w3c.dom.Element;

public class IdASBasedPersonalCard
extends PersonalCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.provider.cardspace.personal.IdASBasedPersonalCard")) : class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard));
    private IEntity card_ = null;
    private IEntity claimList_ = null;
    private boolean editMode = false;
    private EncryptedMasterKey currentMasterKey_ = null;
    private ArrayList tmpClaimValueList_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$personal$IdASBasedPersonalCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ISimpleClaim;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$ClaimType;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback;

    public IdASBasedPersonalCard() {
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, IContext ctx, URI cardId, String cardName, ArrayList claims, byte[] image, String imageMimeType) throws CardException {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (cardId == null) {
            throw new CardException("Parameter \"cardId\" is null");
        }
        this.provider_ = provider;
        this.id_ = cardId;
        this.description_ = "cardspace_type";
        this.isSelfIssued_ = true;
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.issuerName_ = "Self";
        this.version_ = "1";
        this.timeIssued_ = new Date();
        this.supportedTokenTypes_ = new ArrayList();
        this.supportedTokenTypes_.add(URI.create("urn:oasis:names:tc:SAML:1.0:assertion"));
        this.supportedTokenTypes_.add(URI.create("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1"));
        this.name_ = cardName != null ? cardName : "Selfish";
        this.masterKey_ = SecureRandom.getSeed(32);
        this.hashSalt_ = SecureRandom.getSeed(32);
        if (image != null && imageMimeType != null) {
            this.image_ = image;
            this.imageMimeType_ = imageMimeType;
        }
        this.claimTypes_ = SelfIssuedCardClaims.getSupportedClaimTypeList();
        this.tmpClaimValueList_ = claims != null ? claims : new ArrayList();
        try {
            try {
                this.card_ = ctx.getEntity(this.id_.toString());
                throw new CardException("Couldn't create card. Card with id = " + cardId + " already exists.");
            }
            catch (NoSuchEntityException e) {
                this.card_ = ctx.addEntity(IdASContext.ICARD_PersonalInformationCard, this.id_.toString());
                this.initClaimListSubject(true);
                this.saveCard();
                ctx.applyUpdates();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                ctx.cancelUpdates();
            }
            catch (IdASException e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, IEntity card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.provider_ = provider;
        this.card_ = card;
        this.description_ = "cardspace_type";
        this.issuerName_ = "Self";
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.initClaimListSubject(false);
        this.initFromDS(this.card_, this.claimList_);
    }

    public IdASBasedPersonalCard(IdASBasedPersonalCardProvider provider, IContext ctx, Element card) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.provider_ = provider;
        this.description_ = "cardspace_type";
        this.issuerName_ = "Self";
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.initFromXML(card);
        try {
            try {
                this.card_ = ctx.getEntity(this.id_.toString());
            }
            catch (NoSuchEntityException e) {
                this.card_ = ctx.addEntity(IdASContext.ICARD_PersonalInformationCard, this.id_.toString());
            }
            this.initClaimListSubject(true);
            this.saveCard();
            ctx.applyUpdates();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                ctx.cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException(e1.getMessage());
            }
            throw new CardException(e.getMessage());
        }
    }

    private IEntity createClaimListSubject() throws IdASException, CardException {
        if (this.card_ == null) {
            throw new CardException("Variable \"card_\" is null.");
        }
        IContext ctx = this.card_.getContext();
        String clamListSubjectID = String.valueOf(System.currentTimeMillis());
        IEntity claimList = ctx.addEntity(IdASContext.ICARD_ClaimList, clamListSubjectID);
        IComplexAttrValue cv = claimList.getSingleValuedAttribute(IdASContext.ICARD_cardReference).addComplexValue(null);
        cv.getSingleValuedAttribute(IdASContext.ICARD_subjectCardReference).addSimpleValue(null, (Object)this.card_.getEntityID());
        cv.getSingleValuedAttribute(IdASContext.ICARD_contextCardReference).addSimpleValue(null, (Object)ctx.getContextID());
        return claimList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initClaimListSubject(boolean createNew) throws IdASException, CardException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_claimValueListRef);
        IAttributeValue val = attr.getValue();
        if (val != null) {
            IEntity claimList;
            if (val.isSimple()) throw new CardException("Attribute " + IdASContext.ICARD_claimValueListRef + " should be complex");
            String subjID = null;
            IComplexAttrValue listRef = (IComplexAttrValue)val;
            Object subj = this.getSimpleValueData(listRef, IdASContext.ICARD_claimValueListSubject);
            if (subj != null) {
                subjID = subj.toString();
            }
            if ((claimList = this.card_.getContext().getEntity(subjID)) == null) {
                throw new CardException("Couldn't get the claim list subject reference for card with ID = " + this.card_.getEntityID() + " .");
            }
            this.claimList_ = claimList;
            return;
        } else {
            if (!createNew) {
                throw new CardException("Couldn't get the claim list reference for card with ID = " + this.card_.getEntityID() + ". This card doesn't have any value with type" + IdASContext.ICARD_claimValueListRef + ".");
            }
            this.claimList_ = this.createClaimListSubject();
            IComplexAttrValue cv = attr.addComplexValue(null);
            cv.getSingleValuedAttribute(IdASContext.ICARD_claimValueListSubject).addSimpleValue(null, (Object)this.claimList_.getEntityID());
            cv.getSingleValuedAttribute(IdASContext.ICARD_claimValueListContext).addSimpleValue(null, (Object)this.claimList_.getContext().getContextID().toString());
        }
    }

    public void initFromDS(IEntity card, IEntity claimList) throws Exception {
        this.initIsSelfIssued(card);
        this.initLanguage(card);
        this.initCardId(card);
        this.initCardVersion(card);
        this.initCardName(card);
        this.initCardImage(card);
        this.initCardImageType(card);
        this.initTimeIssued(card);
        this.initTimeExpires(card);
        this.initSupportedTokenTypes(card);
        this.initClaimTypes(card);
        this.initHashSalt(card);
        this.initTimeLastUpdated(card);
        this.initMasterKey(card);
        this.initPinDigest(card);
    }

    private void initIsSelfIssued(IEntity card) throws IdASException, CardException, ClassCastException {
        this.isSelfIssued_ = true;
        Boolean issi = (Boolean)this.getSimpleValueData(card, IdASContext.ICARD_isSelfIssued);
        if (issi != null && !issi.booleanValue()) {
            throw new CardException("Can not init managed card with Entity storing data of self-issued (Personal) card");
        }
    }

    private void initLanguage(IEntity card) throws IdASException, CardException, ClassCastException {
        this.language_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_language);
    }

    private void initCardId(IEntity card) throws IdASException, CardException, ClassCastException {
        String id = (String)this.getSimpleValueData(card, IdASContext.HIGGINS_uniqueIdentifier);
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private void initCardVersion(IEntity card) throws IdASException, CardException, ClassCastException {
        this.version_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_version);
    }

    private void initCardName(IEntity card) throws IdASException, CardException, ClassCastException {
        this.name_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_name);
    }

    private void initCardImage(IEntity card) throws IdASException, CardException, ClassCastException {
        this.image_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_image);
    }

    private void initCardImageType(IEntity card) throws IdASException, CardException, ClassCastException {
        this.imageMimeType_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_imageMimeType);
    }

    private void initTimeIssued(IEntity card) throws IdASException, CardException {
        this.timeIssued_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeIssued);
        if (obj != null) {
            this.timeIssued_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeExpires(IEntity card) throws IdASException, CardException {
        this.timeExpires_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_expiredTime);
        if (obj != null) {
            this.timeExpires_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initSupportedTokenTypes(IEntity card) throws IdASException, CardException {
        this.supportedTokenTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple()) {
                Object obj;
                ISimpleAttrValue sv = (ISimpleAttrValue)val;
                if (sv == null || (obj = sv.getData()) == null) continue;
                if (obj instanceof URI) {
                    this.supportedTokenTypes_.add(obj);
                    continue;
                }
                try {
                    this.supportedTokenTypes_.add(new URI(obj.toString()));
                    continue;
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            throw new CardException("Attribute " + IdASContext.ICARD_supportedTokenType + " contains non simple value");
        }
    }

    private void initClaimTypes(IEntity card) throws IdASException, CardException {
        this.claimTypes_ = SelfIssuedCardClaims.getSupportedClaimTypeList();
    }

    private void initHashSalt(IEntity card) throws IdASException, CardException, ClassCastException {
        this.hashSalt_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_hashSalt);
    }

    private void initTimeLastUpdated(IEntity card) throws IdASException, CardException {
        this.timeLastUpdated_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeLastUpdated);
        if (obj != null) {
            this.timeLastUpdated_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initMasterKey(IEntity card) throws IdASException, CardException, ClassCastException {
        this.masterKey_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_masterKey);
    }

    private void initPinDigest(IEntity card) throws IdASException, CardException, ClassCastException {
        this.pinDigest_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_pinDigest);
    }

    public void setName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name.trim();
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (image == null) {
            throw new CardException("Couldn't set null card image.");
        }
        if (imageMimeType == null) {
            throw new CardException("Couldn't set null card image MIME type.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String oldName = this.issuerName_;
        try {
            this.issuerName_ = name.trim();
            this.saveIssuerName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.issuerName_ = oldName;
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(Date date) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws IdASException, CardException {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveSupportedTokenTypes();
        this.saveClaims();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
        this.savePinDigest();
    }

    private void saveIsSelfIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_isSelfIssued);
        attr.addSimpleValue(null, (Object)this.isSelfIssued_);
    }

    private void saveLanguage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_language);
        attr.addSimpleValue(null, (Object)this.language_);
    }

    private void saveCardId() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.HIGGINS_uniqueIdentifier);
        attr.addSimpleValue(null, (Object)this.id_);
    }

    private void saveCardVersion() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_version);
        attr.addSimpleValue(null, (Object)this.version_);
    }

    private void saveCardName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
        attr.addSimpleValue(null, (Object)this.name_);
    }

    private void saveCardImage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
        attr.addSimpleValue(null, (Object)this.image_);
    }

    private void saveCardImageType() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
        attr.addSimpleValue(null, (Object)this.imageMimeType_);
    }

    private void saveIssuer() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuer);
        attr.addSimpleValue(null, (Object)this.issuer_);
    }

    private void saveIssuerName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
        attr.addSimpleValue(null, (Object)this.issuerName_);
    }

    private void saveTimeIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeIssued);
        attr.addSimpleValue(null, (Object)this.timeIssued_);
    }

    private void saveTimeExpires() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
        attr.addSimpleValue(null, (Object)this.timeExpires_);
    }

    private void saveSupportedTokenTypes() throws IdASException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            attr.addSimpleValue(null, (Object)uri);
        }
    }

    private void saveHashSalt() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_hashSalt);
        attr.addSimpleValue(null, (Object)this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws IdASException {
        this.timeLastUpdated_ = new Date();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeLastUpdated);
        attr.addSimpleValue(null, (Object)this.timeLastUpdated_);
    }

    private void saveMasterKey() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_masterKey);
        attr.addSimpleValue(null, (Object)this.masterKey_);
    }

    private void savePinDigest() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_pinDigest);
        attr.addSimpleValue(null, (Object)this.pinDigest_);
    }

    private void saveClaims() throws IdASException, CardException {
        Hashtable claims = SelfIssuedCardClaims.getSupportedTypesHash();
        Iterator values = this.tmpClaimValueList_.iterator();
        while (values.hasNext()) {
            ClaimValue claimValue = (ClaimValue)values.next();
            String val = claimValue.getValue();
            String type = claimValue.getType().getType();
            if (type == null) {
                throw new CardException("Claim type is null.");
            }
            if (claims.containsKey(type)) {
                if (val == null) continue;
                claims.put(type, val);
                continue;
            }
            throw new CardException("Unsupported claim type : " + type);
        }
        Enumeration keys = claims.keys();
        while (keys.hasMoreElements()) {
            String type = (String)keys.nextElement();
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) continue;
            String value = (String)claims.get(type);
            URI typeURI = null;
            try {
                typeURI = new URI(type);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException("Wrong claim type URI : \n" + e.getMessage());
            }
            ISingleValuedAttribute sa = this.claimList_.getSingleValuedAttribute(typeURI);
            if (value.trim().length() == 0) {
                sa.remove();
                continue;
            }
            sa.addSimpleValue(null, (Object)value.trim());
        }
    }

    public IEntity getCardSubject() throws CardException {
        return this.card_;
    }

    public IEntity getClaimListSubject() throws CardException {
        return this.claimList_;
    }

    public ICardProvider getProvider() {
        return this.provider_;
    }

    private Object getSimpleValueData(IComplexAttrValue val, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = val.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(IEntity subj, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(ISingleValuedAttribute attr) throws IdASException, CardException {
        IAttributeValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getAttrID() != null ? attr.getAttrID().toString() : "") + " contains non simple value");
        }
        return null;
    }

    private byte[] convertUTF8ToUTF16(byte[] utf8) throws CardException {
        byte[] utf16 = null;
        if (utf8 != null) {
            try {
                String strUTF8 = new String(utf8, "UTF-8");
                utf16 = strUTF8.getBytes("UTF-16LE");
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException(e.getMessage());
            }
        }
        return utf16;
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
        byte[] decryptedMasterKey;
        byte[] newInitVector;
        byte[] newSalt;
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldPinDigest = null;
        byte[] oldMasterKey = null;
        EncryptedMasterKey oldEmk = null;
        byte[] newPinCodeUTF8 = pinCodeCredential != null ? pinCodeCredential.getPinCode() : null;
        byte[] newPinCodeUTF16 = this.convertUTF8ToUTF16(newPinCodeUTF8);
        oldPinDigest = this.pinDigest_;
        if (oldPinDigest == null) {
            if (newPinCodeUTF8 == null) {
                this.log.debug((Object)"Attempt to reset pin code for unprotected card. Nothing to do.");
                return;
            }
            newSalt = CardCryptography.getRandomBytes((int)16);
            newInitVector = CardCryptography.getRandomBytes((int)16);
            decryptedMasterKey = this.masterKey_;
            oldMasterKey = this.masterKey_;
        } else {
            if (!this.isClaimsRetrieved()) {
                throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
            }
            oldEmk = this.currentMasterKey_;
            newSalt = oldEmk.getSalt();
            newInitVector = oldEmk.getInitVector();
            decryptedMasterKey = oldEmk.getDecryptedMasterKey();
            oldMasterKey = oldEmk.getEncryptedMasterKey();
        }
        try {
            this.pinDigest_ = newPinCodeUTF16 != null ? CardCryptography.getPinDigest((byte[])newPinCodeUTF16) : null;
            this.savePinDigest();
            if (newPinCodeUTF8 != null) {
                this.currentMasterKey_ = new EncryptedMasterKey(decryptedMasterKey, newSalt, newInitVector, newPinCodeUTF8);
                this.masterKey_ = this.currentMasterKey_.getEncryptedMasterKey();
            } else {
                this.currentMasterKey_ = null;
                this.masterKey_ = decryptedMasterKey;
            }
            this.saveMasterKey();
            Hashtable supportedClaimTypes = SelfIssuedCardClaims.getSupportedTypesHash();
            Enumeration claimTypes = supportedClaimTypes.keys();
            while (claimTypes.hasMoreElements()) {
                String claimType = (String)claimTypes.nextElement();
                String value = this.getClaimValue(claimType, oldEmk);
                this.setClaimValue(claimType, value, this.currentMasterKey_);
            }
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.masterKey_ = oldMasterKey;
            this.pinDigest_ = oldPinDigest;
            this.currentMasterKey_ = oldEmk;
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public byte[] getMasterKey() throws CardException {
        if (this.pinDigest_ != null) {
            if (!this.isClaimsRetrieved()) {
                throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
            }
            if (this.currentMasterKey_ != null) {
                return this.currentMasterKey_.getDecryptedMasterKey();
            }
            throw new CardException("Claims for this pin-protected card were retrieved but currentMasterKey is null.");
        }
        return this.masterKey_;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().applyUpdates();
            this.editMode = false;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    private void reinitCard() throws InvalidStateException {
        try {
            this.initFromDS(this.card_, this.claimList_);
            this.initClaims();
        }
        catch (Exception e) {
            new InvalidStateException(e.getMessage());
        }
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().cancelUpdates();
            this.reinitCard();
            this.editMode = false;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new InvalidStateException(e.getMessage());
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return true;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new UnsupportedOperationException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (copyFrom == null) {
            throw new InvalidClaimException("Passed claim is null.");
        }
        if (!(copyFrom instanceof ISimpleClaim)) {
            throw new InvalidClaimException("Provider \"" + this.getProvider().getName() + "\" supports only claims with type " + (class$org$eclipse$higgins$icard$ISimpleClaim == null ? (class$org$eclipse$higgins$icard$ISimpleClaim = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.ISimpleClaim")) : class$org$eclipse$higgins$icard$ISimpleClaim).getName());
        }
        ISimpleClaim simpleClaim = (ISimpleClaim)copyFrom;
        List lst = simpleClaim.getValues();
        if (lst == null) {
            throw new InvalidClaimException("Passed claim does not contain the values list.");
        }
        String obj = lst.size() != 0 ? (String)lst.get(0) : null;
        String value = obj != null ? obj.toString() : "";
        IClaimType cType = simpleClaim.getType();
        if (cType == null) {
            throw new InvalidTypeException("Claim type is null.");
        }
        String type = cType.getType();
        ClaimType newCT = SelfIssuedCardClaims.getClaimType((String)type);
        if (newCT == null) {
            throw new CardException("Personal card does not support claim type :" + type);
        }
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return new ClaimValue((ISimpleClaimType)newCT, "", (ICard)this);
        }
        byte[] pinDigest = this.getPinDigest();
        if (pinDigest != null && !this.isClaimsRetrieved()) {
            throw new CardException("Claims for this pin-protected card should be retrieved to get pin code.");
        }
        ClaimValue cv = new ClaimValue((ISimpleClaimType)newCT, value, (ICard)this);
        try {
            this.setClaimValue(type, value, this.currentMasterKey_);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cv;
    }

    private void setClaimValue(String type, String value, EncryptedMasterKey emk) throws CardException, UnsupportedEncodingException, IdASException {
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return;
        }
        String val = null;
        if (value != null && value.length() != 0) {
            if (emk != null) {
                byte[] newValue = CardCryptography.encryptPersonalCardField((byte[])value.getBytes("UTF-16LE"), (byte[])emk.getSalt(), (byte[])emk.getInitVector(), (byte[])emk.getPinCode());
                val = CardCryptography.encodeBase64((byte[])newValue, (int)1);
            } else {
                val = value;
            }
        }
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.claimList_.getSingleValuedAttribute(typeURI).addSimpleValue(null, (Object)val);
        this.saveTimeLastUpdated();
    }

    private String getClaimValue(String type, EncryptedMasterKey emk) throws CardException {
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) {
            return "";
        }
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        String value = null;
        String dirtyVal = (String)this.getSimpleValueData(this.claimList_, typeURI);
        if (emk != null) {
            if (dirtyVal == null || dirtyVal.trim().length() == 0) {
                value = "";
            } else {
                byte[] encryptedData = CardCryptography.decodeBase64((String)dirtyVal);
                byte[] decryptedData = CardCryptography.decryptPersonalCardField((byte[])encryptedData, (EncryptedMasterKey)emk);
                try {
                    value = new String(decryptedData, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e);
                    throw new CardException(e.getMessage());
                }
            }
        } else {
            value = dirtyVal;
        }
        return value;
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
        if (this.claimList_ == null) {
            return;
        }
        this.currentMasterKey_ = this.getEncryptedMasterKey(credential);
        this.initClaims();
    }

    private void initClaims() throws CardException {
        ArrayList<ClaimValue> claimValueList = new ArrayList<ClaimValue>();
        ArrayList suppportedTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
        int size = suppportedTypes.size();
        for (int i = 0; i < size; ++i) {
            Object obj = suppportedTypes.get(i);
            if (!(obj instanceof ClaimType)) {
                throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$common$ClaimType == null ? (class$org$eclipse$higgins$icard$common$ClaimType = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.common.ClaimType")) : class$org$eclipse$higgins$icard$common$ClaimType).getName() + " expected instead of " + obj.getClass().getName());
            }
            ClaimType cType = (ClaimType)obj;
            String type = cType.getType();
            String val = this.getClaimValue(type, this.currentMasterKey_);
            ClaimValue cValue = new ClaimValue((ISimpleClaimType)cType, val, (ICard)this);
            claimValueList.add(cValue);
        }
        this.setClaims(claimValueList);
    }

    private EncryptedMasterKey getEncryptedMasterKey(ICredential credential) throws AuthenticationException {
        EncryptedMasterKey emk = null;
        if (this.pinDigest_ != null) {
            if (credential == null) {
                throw new AuthenticationException("Parameter \"credential\" is required for pin protected card.");
            }
            Callback[] cbacks = credential.getCallbacks();
            int size = cbacks.length;
            PinCodeCallback pcc = null;
            for (int i = 0; i < size; ++i) {
                Callback cback = cbacks[i];
                if (!(cback instanceof PinCodeCallback)) continue;
                pcc = (PinCodeCallback)cback;
                break;
            }
            if (pcc != null) {
                try {
                    byte[] pin = pcc.getPin();
                    byte[] digest = CardCryptography.getPinDigest((byte[])this.convertUTF8ToUTF16(pin));
                    if (!Arrays.equals(this.pinDigest_, digest)) {
                        throw new AuthenticationException("Wrong pin code.");
                    }
                    emk = new EncryptedMasterKey(this.masterKey_, pin);
                }
                catch (CardException e) {
                    this.log.error((Object)e);
                    throw new AuthenticationException((Throwable)e);
                }
            } else {
                throw new AuthenticationException("Passed credential does not contain pin code callback (" + (class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback == null ? (class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback = IdASBasedPersonalCard.class$("org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback")) : class$org$eclipse$higgins$icard$common$auth$callback$PinCodeCallback).getName() + ")");
            }
        }
        return emk;
    }

    public void lock(IPinCodeCredential credential) throws Exception {
    }

    public void unlock(IPinCodeCredential credential) throws Exception {
    }

    public boolean validatePINCode(String pinCode) throws Exception {
        return false;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        throw new CardException("Not implemented");
    }

    public IInformationCardExtension[] getExtensions() {
        return null;
    }

    public boolean hasExtensions() {
        return false;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        throw new CardException("Not implemented");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

