/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.ITokenType;
import org.eclipse.higgins.cardstore.schemas._2005._02.trust.impl.TokenType;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ICardImage;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardMetaData;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardReference;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IPrivacyNoticeLocation;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRequireAppliesTo;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ISupportedClaimType;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ITokenService;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.CardImage;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.InformationCardReference;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.PrivacyNoticeLocation;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.RequireAppliesTo;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.SupportedClaimType;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.TokenService;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.DateUtil;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InformationCardMetaData
implements IInformationCardMetaData {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private IInformationCardReference _infoCardRef = null;
    private Element _infoCardMetaDataElement = null;
    private String _cardName = null;
    private ICardImage _cardImage = null;
    private String _issuer = null;
    private Date _timeIssued = null;
    private Date _timeExpires = null;
    private ITokenType[] _supportedTokenTypes = null;
    private ISupportedClaimType[] _supportedClaimTypes = null;
    private ITokenService[] _tokenServices = null;
    private boolean _isSelfIssue = false;
    private boolean _isSetSelfIssue = false;
    private byte[] _hashSalt = null;
    private Date _timeLastUpdated = null;
    private byte[] _issuerId = null;
    private String _issuerName = null;
    private int _backGroundColor = 0;
    private boolean _isBackgroundColorSet = false;
    private byte[] _pinDigest = null;
    private IRequireAppliesTo _requireAppliesTo = null;
    private IPrivacyNoticeLocation _privacyNotice = null;
    private Locale _lang = null;
    Object _parentNode = null;

    public Object getParent() {
        return this._parentNode;
    }

    public void setParent(Object parentNode) {
        this._parentNode = parentNode;
    }

    public int getBackgroundColor() {
        return this._backGroundColor;
    }

    public byte[] getHashSalt() {
        return this._hashSalt;
    }

    public byte[] getIssuerId() {
        return this._issuerId;
    }

    public String getIssuerName() {
        return this._issuerName;
    }

    public byte[] getPinDigest() {
        return this._pinDigest;
    }

    public Date getTimeLastUpdated() {
        return this._timeLastUpdated;
    }

    public boolean isIsSelfIssued() {
        return this._isSelfIssue;
    }

    public boolean isSetBackgroundColor() {
        return this._isBackgroundColorSet;
    }

    public boolean isSetIsSelfIssued() {
        return this._isSetSelfIssue;
    }

    public void setBackgroundColor(int value) {
        this._backGroundColor = value;
        this._isBackgroundColorSet = true;
    }

    public void setHashSalt(byte[] value) {
        this._hashSalt = value;
    }

    public void setIsSelfIssued(boolean value) {
        this._isSelfIssue = value;
        this._isSetSelfIssue = true;
    }

    public void setIssuerId(byte[] value) {
        this._issuerId = value;
    }

    public void setIssuerName(String value) {
        this._issuerName = value;
    }

    public void setPinDigest(byte[] value) {
        this._pinDigest = value;
    }

    public void setTimeLastUpdated(Date timeLastUpdated) {
        this._timeLastUpdated = timeLastUpdated;
    }

    public void unsetBackgroundColor() {
        this._backGroundColor = 0;
        this._isBackgroundColorSet = false;
    }

    public void unsetIsSelfIssued() {
        this._isSelfIssue = false;
        this._isSetSelfIssue = false;
    }

    public ICardImage getCardImage() {
        return this._cardImage;
    }

    public String getCardName() {
        return this._cardName;
    }

    public IInformationCardReference getInformationCardReference() {
        return this._infoCardRef;
    }

    public String getIssuer() {
        return this._issuer;
    }

    public Locale getLang() {
        return this._lang;
    }

    public IPrivacyNoticeLocation getPrivacyNotice() {
        return this._privacyNotice;
    }

    public IRequireAppliesTo getRequireAppliesTo() {
        return this._requireAppliesTo;
    }

    public ISupportedClaimType[] getSupportedClaimTypeList() {
        return this._supportedClaimTypes;
    }

    public ITokenType[] getSupportedTokenTypeList() {
        return this._supportedTokenTypes;
    }

    public Date getTimeExpires() {
        return this._timeExpires;
    }

    public Date getTimeIssued() {
        return this._timeIssued;
    }

    public ITokenService[] getTokenServiceList() {
        return this._tokenServices;
    }

    public void setCardImage(ICardImage value) {
        this._cardImage = value;
    }

    public void setCardName(String value) {
        this._cardName = value;
    }

    public void setInformationCardReference(IInformationCardReference value) {
        this._infoCardRef = value;
    }

    public void setIssuer(String value) {
        this._issuer = value;
    }

    public void setLang(Locale locale) {
        this._lang = locale;
    }

    public void setPrivacyNotice(IPrivacyNoticeLocation value) {
        this._privacyNotice = value;
    }

    public void setRequireAppliesTo(IRequireAppliesTo value) {
        this._requireAppliesTo = value;
    }

    public void setSupportedClaimTypeList(ISupportedClaimType[] value) {
        this._supportedClaimTypes = value;
    }

    public void setSupportedTokenTypeList(ITokenType[] value) {
        this._supportedTokenTypes = value;
    }

    public void setTimeExpires(Date timeExpires) {
        this._timeExpires = timeExpires;
    }

    public void setTimeIssued(Date timeIssued) {
        this._timeIssued = timeIssued;
    }

    public void setTokenServiceList(ITokenService[] tokenServices) {
        this._tokenServices = tokenServices;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        Element privacyNoticeElement;
        Element requireAppliesToElement;
        String s;
        Element pinDigestElement;
        String s2;
        Element backGroundColorElement;
        String s3;
        String s4;
        Element timeLastUpdatedElement;
        Element hashSaltElement;
        String s5;
        Element isSelfIssuedElement;
        Element tokenServicesList;
        Element supportedClaimTypeList;
        Element supportedTokenTypeList;
        String s6;
        Element timeExpiredElement;
        String s7;
        Element timeIssuedElement;
        String s8;
        Element issuerElement;
        String s9;
        this._infoCardMetaDataElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._infoCardMetaDataElement, "InformationCardMetaData", "http://schemas.xmlsoap.org/ws/2005/05/identity") || this._infoCardMetaDataElement == null) {
            this._infoCardMetaDataElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://schemas.xmlsoap.org/ws/2005/05/identity:InformationCardMetaData"}));
        }
        String lang = this._infoCardMetaDataElement.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang != null && lang.length() > 0) {
            try {
                this._lang = this.buildLocale(lang);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._infoCardRef = new InformationCardReference();
        XmlUtils.buildObjectFromXml(this, this._infoCardRef, this._infoCardMetaDataElement, "InformationCardReference", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        Element cardNameElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "CardName", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (cardNameElement != null && (s9 = XmlUtils.retrieveAllTextFromChildTextNodes(cardNameElement)) != null && s9.length() > 0) {
            this.setCardName(s9);
        }
        this._cardImage = new CardImage();
        XmlUtils.buildObjectFromXml(this, this._cardImage, this._infoCardMetaDataElement, "CardImage", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (lang == null || lang.length() <= 0) {
            this._infoCardMetaDataElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "en-us");
        }
        if ((issuerElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "Issuer", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s8 = XmlUtils.retrieveAllTextFromChildTextNodes(issuerElement)) != null && s8.length() > 0) {
            this.setIssuer(s8);
        }
        if ((timeIssuedElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "TimeIssued", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s7 = XmlUtils.retrieveAllTextFromChildTextNodes(timeIssuedElement)) != null && s7.length() > 0) {
            this.setTimeIssued(DateUtil.getDateFromIso8601(s7));
        }
        if ((timeExpiredElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "TimeExpires", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s6 = XmlUtils.retrieveAllTextFromChildTextNodes(timeExpiredElement)) != null && s6.length() > 0) {
            this.setTimeExpires(DateUtil.getDateFromIso8601(s6));
        }
        if ((supportedTokenTypeList = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "SupportedTokenTypeList", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._supportedTokenTypes = new TokenType[XmlUtils.numberOfChildElementsOfType(supportedTokenTypeList, "TokenType", "http://schemas.xmlsoap.org/ws/2005/02/trust")];
            NodeList nl = supportedTokenTypeList.getChildNodes();
            int numOfTokenTypes = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || n.getNodeType() != 1 || !XmlUtils.isElementType((Element)n, "TokenType", "http://schemas.xmlsoap.org/ws/2005/02/trust")) continue;
                this._supportedTokenTypes[numOfTokenTypes] = new TokenType();
                this._supportedTokenTypes[numOfTokenTypes].fromXml(n);
                this._supportedTokenTypes[numOfTokenTypes].setParent(this);
                ++numOfTokenTypes;
            }
        }
        if ((supportedClaimTypeList = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "SupportedClaimTypeList", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._supportedClaimTypes = new SupportedClaimType[XmlUtils.numberOfChildElementsOfType(supportedClaimTypeList, "SupportedClaimType", "http://schemas.xmlsoap.org/ws/2005/05/identity")];
            NodeList nl = supportedClaimTypeList.getChildNodes();
            int numOfSupportClaimTypes = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || n.getNodeType() != 1 || !XmlUtils.isElementType((Element)n, "SupportedClaimType", "http://schemas.xmlsoap.org/ws/2005/05/identity")) continue;
                this._supportedClaimTypes[numOfSupportClaimTypes] = new SupportedClaimType();
                this._supportedClaimTypes[numOfSupportClaimTypes].fromXml(n);
                ++numOfSupportClaimTypes;
            }
        }
        if ((tokenServicesList = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "TokenServiceList", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._tokenServices = new TokenService[XmlUtils.numberOfChildElementsOfType(tokenServicesList, "TokenService", "http://schemas.xmlsoap.org/ws/2005/05/identity")];
            NodeList nl = tokenServicesList.getChildNodes();
            int numOfTokenServices = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || n.getNodeType() != 1 || !XmlUtils.isElementType((Element)n, "TokenService", "http://schemas.xmlsoap.org/ws/2005/05/identity")) continue;
                this._tokenServices[numOfTokenServices] = new TokenService();
                this._tokenServices[numOfTokenServices].fromXml(n);
                ++numOfTokenServices;
            }
        }
        if ((isSelfIssuedElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "IsSelfIssued", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s5 = XmlUtils.retrieveAllTextFromChildTextNodes(isSelfIssuedElement)) != null && s5.length() > 0) {
            this.setIsSelfIssued(Boolean.valueOf(s5));
        }
        if ((hashSaltElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "HashSalt", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            String s10 = XmlUtils.retrieveAllTextFromChildTextNodes(hashSaltElement);
            if (s10 != null && s10.length() > 0) {
                this.setHashSalt(Base64Utility.decode(s10));
            }
            if (this._hashSalt.length > 16) {
                byte[] temp = new byte[16];
                System.arraycopy(this._hashSalt, 1, temp, 0, temp.length);
                this.setHashSalt(temp);
                Document doc = hashSaltElement.getOwnerDocument();
                Text value = doc.createTextNode(Base64Utility.encode(temp));
                Element hsE = (Element)hashSaltElement.cloneNode(false);
                hsE.appendChild(value);
                this._infoCardMetaDataElement.replaceChild(hsE, hashSaltElement);
            }
        }
        if ((timeLastUpdatedElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "TimeLastUpdated", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s4 = XmlUtils.retrieveAllTextFromChildTextNodes(timeLastUpdatedElement)) != null && s4.length() > 0) {
            this.setTimeLastUpdated(DateUtil.getDateFromIso8601(s4));
        }
        Element issuerIdElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "IssuerId", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        String s1 = null;
        if (issuerIdElement != null && (s1 = XmlUtils.retrieveAllTextFromChildTextNodes(issuerIdElement)) != null && s1.length() > 0) {
            this.setIssuerId(Base64Utility.decode(s1));
        }
        if (issuerIdElement == null || s1 == null || s1.length() == 0) {
            byte[] bval = new SecureRandom().generateSeed(32);
            this.setIssuerId(bval);
            Document root = this._infoCardMetaDataElement.getOwnerDocument();
            Text value = root.createTextNode(Base64Utility.encode(bval));
            Element newIssuerIdElement = null;
            if (issuerIdElement == null) {
                issuerIdElement = newIssuerIdElement = root.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
            } else {
                NodeList nl = issuerIdElement.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    issuerIdElement.removeChild(nl.item(i));
                }
            }
            issuerIdElement.appendChild(value);
            if (newIssuerIdElement != null) {
                this._infoCardMetaDataElement.appendChild(issuerIdElement);
            }
        }
        s1 = null;
        Element issuerNameElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "IssuerName", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (issuerNameElement != null && (s3 = XmlUtils.retrieveAllTextFromChildTextNodes(issuerNameElement)) != null && s3.length() > 0) {
            this.setIssuerName(s3);
        }
        if ((backGroundColorElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "BackgroundColor", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s2 = XmlUtils.retrieveAllTextFromChildTextNodes(backGroundColorElement)) != null && s2.length() > 0) {
            try {
                int bc = Integer.parseInt(s2, 10);
                this.setBackgroundColor(bc);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((pinDigestElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "PinDigest", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null && (s = XmlUtils.retrieveAllTextFromChildTextNodes(pinDigestElement)) != null && s.length() > 0) {
            this.setPinDigest(Base64Utility.decode(s));
        }
        if ((requireAppliesToElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "RequireAppliesTo", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._requireAppliesTo = new RequireAppliesTo();
            this._requireAppliesTo.fromXml(requireAppliesToElement);
        }
        if ((privacyNoticeElement = XmlUtils.retrieveFirstChildMatchOfType(this._infoCardMetaDataElement, "PrivacyNotice", "http://schemas.xmlsoap.org/ws/2005/05/identity")) != null) {
            this._privacyNotice = new PrivacyNoticeLocation();
            this._privacyNotice.fromXml(privacyNoticeElement);
        }
    }

    private Locale buildLocale(String lang) {
        Locale result = null;
        if (lang != null && (lang.indexOf(45) != -1 || lang.indexOf(95) != -1)) {
            if (lang.indexOf(45) != -1) {
                String[] split = lang.split("-");
                if (split.length == 2) {
                    String l = split[0].toLowerCase();
                    String country = split[1].toUpperCase();
                    result = new Locale(l, country);
                } else {
                    result = new Locale(lang.toLowerCase());
                }
            } else if (lang.indexOf(95) != -1) {
                String[] split = lang.split("_");
                if (split.length == 2) {
                    String l = split[0].toLowerCase();
                    String country = split[1].toUpperCase();
                    result = new Locale(l, country);
                } else {
                    result = new Locale(lang.toLowerCase());
                }
            } else {
                result = new Locale(lang.toLowerCase());
            }
        } else if (lang != null) {
            result = new Locale(lang.toLowerCase());
        }
        return result;
    }

    public Object toXml() {
        return this._infoCardMetaDataElement;
    }
}

