/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.securestorage.PasswordHandler;
import org.eclipse.higgins.icard.provider.securestorage.ProviderConfiguration;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageICardProvider;
import org.eclipse.higgins.icard.provider.securestorage.SecureStorageStrategy;

public class testSecureStorageProvider
extends TestCase {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$securestorage$test$testSecureStorageProvider == null ? (class$org$eclipse$higgins$icard$provider$securestorage$test$testSecureStorageProvider = testSecureStorageProvider.class$("org.eclipse.higgins.icard.provider.securestorage.test.testSecureStorageProvider")) : class$org$eclipse$higgins$icard$provider$securestorage$test$testSecureStorageProvider));
    public final boolean CONSOLE_LOG = true;
    public final boolean FILE_LOG = false;
    public final String CARD_STORAGE_ORI = "config/test/3cards_ori.crds";
    public final String CARD_STORAGE = "config/test/3cards.crds";
    public final String CRD_FILE = "config/test/abhi0-card.crd";
    public final String PASSWD = "passw0rd";
    private final Properties default_logging;
    CallbackHandler handler = new CallbackHandler(){

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
                PasswordCallback p = (PasswordCallback)callbacks[i];
                p.setPassword("passw0rd".toCharArray());
            }
        }
    };
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$securestorage$test$testSecureStorageProvider;

    void copyFile(String src, String dest) throws IOException {
        FileInputStream fis = new FileInputStream(new File(src));
        FileOutputStream fos = new FileOutputStream(new File(dest));
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public testSecureStorageProvider() throws Exception {
        this.default_logging = new Properties();
        this.default_logging.put("log4j.rootLogger", "error");
        this.default_logging.put("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        this.default_logging.put("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        this.default_logging.put("log4j.appender.stdout.layout.ConversionPattern", "%5p [%t] (%F:%L) - %m%n");
        this.default_logging.put("log4j.rootLogger", "trace, stdout");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.copyFile("config/test/3cards_ori.crds", "config/test/3cards.crds");
    }

    public void testReadStorage() throws Exception {
        SecureStorageStrategy secureStorageStrategy = new SecureStorageStrategy();
        ProviderConfiguration provider = new ProviderConfiguration("Testcase Configuration");
        Properties prop = new Properties();
        provider.setProperties(prop);
        PasswordHandler pwdH = new PasswordHandler("passw0rd");
        SecureStorageICardProvider cardProvider = new SecureStorageICardProvider();
        secureStorageStrategy.initialize(this.handler, cardProvider, "config/test/3cards.crds", pwdH, provider);
        cardProvider.setStrategy(secureStorageStrategy);
        Iterator iter = cardProvider.getICards(null, null);
        while (iter.hasNext()) {
            Object o = iter.next();
            InformationCard card = (InformationCard)o;
            this.log.info((Object)("return card ID:" + card.getID() + "\n"));
            this.log.info(o);
        }
    }

    public void testImportCard() throws Exception {
        SecureStorageStrategy secureStorageStrategy = new SecureStorageStrategy();
        ProviderConfiguration provider = new ProviderConfiguration("Testcase Configuration");
        Properties prop = new Properties();
        provider.setProperties(prop);
        PasswordHandler pwdH = new PasswordHandler("passw0rd");
        SecureStorageICardProvider cardProvider = new SecureStorageICardProvider();
        secureStorageStrategy.initialize(this.handler, cardProvider, "config/test/3cards.crds", pwdH, provider);
        cardProvider.setStrategy(secureStorageStrategy);
        Iterator iter = cardProvider.getICards(null, null);
        int old_count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            this.log.info((Object)("return card ID:" + ((InformationCard)o).getID() + "\n"));
            ++old_count;
        }
        cardProvider.importCard(null, "config/test/abhi0-card.crd");
        iter = cardProvider.getICards(null, null);
        int new_count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            this.log.info((Object)("return card ID:" + ((InformationCard)o).getID() + "\n"));
            ++new_count;
        }
        testSecureStorageProvider.assertEquals((int)(old_count + 1), (int)new_count);
    }

    public void testRemoveCard() throws Exception {
        SecureStorageStrategy secureStorageStrategy = new SecureStorageStrategy();
        ProviderConfiguration provider = new ProviderConfiguration("Testcase Configuration");
        Properties prop = new Properties();
        provider.setProperties(prop);
        PasswordHandler pwdH = new PasswordHandler("passw0rd");
        SecureStorageICardProvider cardProvider = new SecureStorageICardProvider();
        secureStorageStrategy.initialize(this.handler, cardProvider, "config/test/3cards.crds", pwdH, provider);
        cardProvider.setStrategy(secureStorageStrategy);
        Iterator iter = cardProvider.getICards(null, null);
        ICard card2delete = null;
        int old_count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            card2delete = (ICard)o;
            this.log.info((Object)("return card ID:" + ((InformationCard)card2delete).getID() + "\n"));
            ++old_count;
        }
        this.log.info((Object)("deleting card [" + card2delete.getCUID() + "]"));
        cardProvider.deleteCard(null, card2delete);
        iter = cardProvider.getICards(null, null);
        int new_count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            ICard card = (ICard)o;
            testSecureStorageProvider.assertFalse((boolean)card.getID().equals(card2delete.getID()));
            testSecureStorageProvider.assertFalse((boolean)card.getCUID().equals((Object)card2delete.getCUID()));
            this.log.info((Object)("return card ID:" + ((InformationCard)o).getID() + "\n"));
            ++new_count;
        }
        testSecureStorageProvider.assertEquals((int)(old_count - 1), (int)new_count);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

