/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.logging.impl;

import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cardstore.Constants;

public class LoggerApacheCommonsImpl implements org.eclipse.higgins.cardstore.logging.Log {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private org.apache.commons.logging.Log _log = null;
	private Class _callerClass = null;
	
	public LoggerApacheCommonsImpl(Class klass)
	{
		_log = LogFactory.getLog(klass);
		_callerClass = klass;
	}
	
	public void enterMethod(String method, Object[] params) {
		String prefix = _callerClass.getName() + " " + method + " ENTER ";
			
		StringBuffer sb = new StringBuffer();
		if (params != null)
		{
			for(int i = 0; i < params.length; i++)
			{
				if (i > 0)
				{
					sb.append(" ");
				}
				sb.append(params[i]);
			}			
		}
		
		_log.trace(prefix + "[" + sb.toString() + "]");		
	}

	public void enterMethod(String method) {
		String prefix = _callerClass.getName() + " " + method + " ENTER";
		_log.trace(prefix);		
	}

	public void exitMethod(String method, Object result) {
		String prefix = _callerClass.getName() + " " + method + " RETURN ";
		
		_log.trace(prefix + "[" + result + "]");
	}

	public void exitMethod(String method) {
		String prefix = _callerClass.getName() + " " + method + " RETURN";
		
		_log.trace(prefix);
	}

	public void throwing(String method, Throwable thrown) {
		if (thrown != null)
		{
			_log.trace("Exception thrown: " + method + ": " + thrown.getMessage());
			thrown.printStackTrace();
		}		
	}

	public void debug(Object arg0) {
		_log.debug(arg0);		
	}

	public void debug(Object arg0, Throwable arg1) {
		_log.debug(arg0, arg1);		
	}

	public void error(Object arg0) {
		_log.error(arg0);		
	}

	public void error(Object arg0, Throwable arg1) {
		_log.error(arg0, arg1);		
	}

	public void fatal(Object arg0) {
		_log.fatal(arg0);		
	}

	public void fatal(Object arg0, Throwable arg1) {
		_log.fatal(arg0, arg1);		
	}

	public void info(Object arg0) {
		_log.info(arg0);		
	}

	public void info(Object arg0, Throwable arg1) {
		_log.info(arg0, arg1);		
	}

	public boolean isDebugEnabled() {		
		return _log.isDebugEnabled();
	}

	public boolean isErrorEnabled() {
		return _log.isErrorEnabled();
	}

	public boolean isFatalEnabled() {		
		return _log.isFatalEnabled();
	}

	public boolean isInfoEnabled() {
		return _log.isInfoEnabled();
	}

	public boolean isTraceEnabled() {
		return _log.isTraceEnabled();
	}

	public boolean isWarnEnabled() {
		return _log.isWarnEnabled();
	}

	public void trace(String method, Object arg0) {
		String prefix = _callerClass.getName() + " " + method + " ";
		
		_log.trace(prefix + arg0);		
	}

	public void trace(String method, Object arg0, Throwable thrown) {
		String traceMsg = _callerClass.getName() + " " + method + " " + arg0 + " ";
		
		if (thrown != null)
		{
			traceMsg = traceMsg + thrown.getMessage();
		}
		
		_log.trace(traceMsg, thrown);
	}

	public void warn(Object arg0) {
		_log.warn(arg0);		
	}

	public void warn(Object arg0, Throwable arg1) {
		_log.warn(arg0, arg1);
	}

}
