/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IKeyInfo;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IX509Data;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class X509Data implements IX509Data {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private static Log _log = LogHelper.getLogger(X509Data.class);
	
	private Element _x509DataElement = null;
	
	private X509Certificate _x509Certificate = null;
	
	Object _parent = null;
	
	public void setParent(Object parentNode)
	{
		_parent = parentNode;
	}
	
	public Object getParent()
	{
		return _parent;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		
		_x509DataElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_x509DataElement, 
				LocalElementNames.DS_X509_DATA, 
				Constants.NSURI_DS_2000_09) || _x509DataElement == null)
		{
			_x509DataElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_DS_2000_09 + ":" + LocalElementNames.DS_X509_DATA}));			
			
		}
		
		Element _x509CertificateElement = XmlUtils.retrieveFirstChildMatchOfType(
				_x509DataElement, 
				LocalElementNames.DS_X509_CERTIFICATE, 
				Constants.NSURI_DS_2000_09);
		
		if (_x509CertificateElement != null)
		{
			String s = XmlUtils.retrieveAllTextFromChildTextNodes(_x509CertificateElement);
			
			if (s != null && s.length() > 0)
			{
				byte[] certBytes = Base64Utility.decode(s);
				
				if (certBytes != null && certBytes.length > 0)
				{
					try {
						CertificateFactory cf = CertificateFactory.getInstance("X.509");						
						ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
						setX509Certificate((X509Certificate)cf.generateCertificate(bais));
					} catch (Exception e) {
						_log.error(null, e);
					}
				}
			} 
		}
	}

	public Object toXml() {
		return _x509DataElement;
	}

	public X509Certificate getX509Certificate() {
		return _x509Certificate;
	}

	public void setX509Certificate(X509Certificate cert) {
		_x509Certificate = cert;		
	}

}
