/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ISelfIssuedCredential;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IUserCredential;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IUsernamePasswordCredential;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IX509V3Credential;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class UserCredential implements IUserCredential {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _userCredentialElement = null;
	
	private boolean _isKerberosV5Credential = false;
	
	private String _displayCredentialHint = null;
	
	private IUsernamePasswordCredential _usernamePasswordCredential = null;
	
	private IX509V3Credential _x509v3Credential = null;
	
	private ISelfIssuedCredential _selfIssuedCredential = null;

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public String getDisplayCredentialHint() {
		return _displayCredentialHint;
	}

	public ISelfIssuedCredential getSelfIssuedCredential() {
		return _selfIssuedCredential;
	}

	public IUsernamePasswordCredential getUsernamePasswordCredential() {
		return _usernamePasswordCredential;
	}

	public IX509V3Credential getX509V3Credential() {
		return _x509v3Credential;
	}

	public boolean isKerberosV5Credential() {
		return _isKerberosV5Credential;
	}

	public void setDisplayCredentialHint(String value) {
		_displayCredentialHint = value;
	}

	public void setIsKerberosV5Credential(boolean bool) {
		_isKerberosV5Credential = bool;
	}

	public void setSelfIssuedCredential(ISelfIssuedCredential value) {
		_selfIssuedCredential = value;
	}

	public void setUsernamePasswordCredential(IUsernamePasswordCredential value) {
		_usernamePasswordCredential = value;
	}

	public void setX509V3Credential(IX509V3Credential value) {
		_x509v3Credential = value;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		
		_userCredentialElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_USER_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05) || _userCredentialElement == null)
		{
			_userCredentialElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_USER_CREDENTIAL}));			
			
		}
		
		Element kerbElement = XmlUtils.retrieveFirstChildMatchOfType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_KERBEROS_V5_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05);

		if (kerbElement != null)
		{
			setIsKerberosV5Credential(true);
		}

		Element displayCredentialHint = XmlUtils.retrieveFirstChildMatchOfType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_DISPLAY_CREDENTIAL_HINT, 
				Constants.NSURI_IDENTITY_2005_05);

		if (displayCredentialHint != null)
		{
			setDisplayCredentialHint(XmlUtils.retrieveAllTextFromChildTextNodes(displayCredentialHint));
		}

		Element usernamePasswordCredentialElement = XmlUtils.retrieveFirstChildMatchOfType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_USERNAME_PASSWORD_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05);

		if (usernamePasswordCredentialElement != null)
		{
			_usernamePasswordCredential = new UsernamePasswordCredential();
			_usernamePasswordCredential.fromXml(usernamePasswordCredentialElement);
			((UsernamePasswordCredential)_usernamePasswordCredential).setParent(this);
		}

		Element x509v3CredentialElement = XmlUtils.retrieveFirstChildMatchOfType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_X509_V3_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05);

		if (x509v3CredentialElement != null)
		{
			_x509v3Credential = new X509V3Credential();
			_x509v3Credential.fromXml(x509v3CredentialElement);
			((X509V3Credential)_x509v3Credential).setParent(this);
		}
		
		Element selfIssuedCredentialElement = XmlUtils.retrieveFirstChildMatchOfType(
				_userCredentialElement, 
				LocalElementNames.IDENTITY_SELF_ISSUED_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05);

		if (selfIssuedCredentialElement != null)
		{
			_selfIssuedCredential = new SelfIssedCredential();
			_selfIssuedCredential.fromXml(selfIssuedCredentialElement);
			((SelfIssedCredential)_selfIssuedCredential).setParent(this);
		}

	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
