/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.logging;

import org.eclipse.higgins.cardstore.Constants;

/**
 * This interface extended org.apache.commons.logging.Log for code servicablity
 * reasons.
 * 
 * @author pwardrop
 *
 */
public interface Log {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	public void enterMethod(String method, Object[] params);
	
	public void enterMethod(String method);
	
	public void exitMethod(String method, Object result);
	
	public void exitMethod(String method);
	
	public void throwing(String method, Throwable thrown);
	
	public void debug(Object arg0);

	public void debug(Object arg0, Throwable arg1);

	public void error(Object arg0);

	public void error(Object arg0, Throwable arg1);

	public void fatal(Object arg0);

	public void fatal(Object arg0, Throwable arg1);

	public void info(Object arg0);

	public void info(Object arg0, Throwable arg1);

	public boolean isDebugEnabled();		

	public boolean isErrorEnabled();

	public boolean isFatalEnabled();		

	public boolean isInfoEnabled();

	public boolean isTraceEnabled();

	public boolean isWarnEnabled();

	public void trace(String method, Object arg0);

	public void trace(String method, Object arg0, Throwable thrown);

	public void warn(Object arg0);

	public void warn(Object arg0, Throwable arg1);
	
}
