/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;

public interface XMLSerializer {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent;
	public Object toXml();
	
	public Object getParent();
	public void setParent(Object parent);
}
