/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.logging.impl;

import org.eclipse.higgins.cardstore.Constants;


/**
 * This class should only be used for testing purposes.  
 * <p/>
 * This is a simple logger that will output to System.out and
 * System.err.
 * 
 * @author pwardrop
 *
 */
public class LoggerConsoleImpl implements org.eclipse.higgins.cardstore.logging.Log {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Class _callerClass = null;
	
	public LoggerConsoleImpl(Class klass)
	{
		_callerClass = klass;
	}
	
	public void enterMethod(String method, Object[] params) {
		String prefix = _callerClass.getName() + " " + method + " ENTER ";
			
		StringBuffer sb = new StringBuffer();
		if (params != null)
		{
			for(int i = 0; i < params.length; i++)
			{
				if (i > 0)
				{
					sb.append(" ");
				}
				sb.append(params[i]);
			}			
		}
		
		System.out.println(prefix + "[" + sb.toString() + "]");		
	}

	public void enterMethod(String method) {
		String prefix = _callerClass.getName() + " " + method + " ENTER";
		System.out.println(prefix);		
	}

	public void exitMethod(String method, Object result) {
		String prefix = _callerClass.getName() + " " + method + " RETURN ";
		
		System.out.println(prefix + "[" + result+ "]");
	}

	public void exitMethod(String method) {
		String prefix = _callerClass.getName() + " " + method + " RETURN";
		
		System.out.println(prefix);
	}

	public void throwing(String method, Throwable thrown) {
		if (thrown != null)
		{
			System.out.println("Exception thrown: " + method + ": " + thrown.getMessage());
			thrown.printStackTrace();
		}		
	}

	public void debug(Object arg0) {
		System.out.println(arg0);		
	}

	public void debug(Object arg0, Throwable arg1) {		
		System.out.println(arg0);		
		arg1.printStackTrace();
	}

	public void error(Object arg0) {
		System.err.println(arg0);		
	}

	public void error(Object arg0, Throwable arg1) {
		System.err.println(arg0);	
		arg1.printStackTrace();
	}

	public void fatal(Object arg0) {
		System.err.println(arg0);		
	}

	public void fatal(Object arg0, Throwable arg1) {
		System.err.println(arg0);	
		arg1.printStackTrace();
	}

	public void info(Object arg0) {
		System.out.println(arg0);		
	}

	public void info(Object arg0, Throwable arg1) {
		System.out.println(arg0);	
		arg1.printStackTrace();
	}

	public boolean isDebugEnabled() {		
		return true;
	}

	public boolean isErrorEnabled() {
		return true;
	}

	public boolean isFatalEnabled() {		
		return true;
	}

	public boolean isInfoEnabled() {
		return true;
	}

	public boolean isTraceEnabled() {
		return true;
	}

	public boolean isWarnEnabled() {
		return true;
	}

	public void trace(String method, Object arg0) {
		String prefix = _callerClass.getName() + " " + method + " ";
		
		System.out.println(prefix + arg0);		
	}

	public void trace(String method, Object arg0, Throwable thrown) {
		String traceMsg = _callerClass.getName() + " " + method + " " + arg0 + " ";
		
		if (thrown != null)
		{
			traceMsg = traceMsg + thrown.getMessage();
		}
		
		System.out.println(traceMsg);
		thrown.printStackTrace();
	}

	public void warn(Object arg0) {
		System.out.println(arg0);		
	}

	public void warn(Object arg0, Throwable arg1) {
		System.out.println(arg0);
		arg1.printStackTrace();
	}
	

}
