/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IPrivacyNoticeLocation;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class PrivacyNoticeLocation implements IPrivacyNoticeLocation {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _privacyNoticeElement = null;
	
	private String _location = null;
	
	private long _version = 0;
	
	private boolean _isVersionSet = false;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public String getValue() {
		return _location;
	}

	public long getVersion() {
		return _version;
	}

	public boolean isSetVersion() {
		return _isVersionSet;
	}

	public void setValue(String value) {
		_location = value;
	}

	public void setVersion(long value) {
		_version = value;
		_isVersionSet = true;
	}

	public void unsetVersion() {
		_version = 0;
		_isVersionSet = false;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_privacyNoticeElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_privacyNoticeElement, 
				LocalElementNames.IDENTITY_PRIVACY_NOTICE, 
				Constants.NSURI_IDENTITY_2005_05) || _privacyNoticeElement == null)
		{
			_privacyNoticeElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_PRIVACY_NOTICE}));
			
		}

		String s = XmlUtils.retrieveAllTextFromChildTextNodes(_privacyNoticeElement);

		if (s != null && s.length() > 0)
		{
			setValue(s);
		}
		
		String version = _privacyNoticeElement.getAttribute("Version");
		
		if (version != null && version.length() > 0)
		{
			try {
				setVersion(Long.parseLong(version, 10));
			} catch (Exception e) {
				// ignore
			}
		}

	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
