/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IUsernamePasswordCredential;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class UsernamePasswordCredential implements IUsernamePasswordCredential {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _usernamePasswordCredentialElement = null;
	
	private String _username = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public String getUsername() {
		return _username;
	}

	public void setUsername(String userid) {
		_username = userid;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_usernamePasswordCredentialElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_usernamePasswordCredentialElement, 
				LocalElementNames.IDENTITY_USERNAME_PASSWORD_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05) || _usernamePasswordCredentialElement == null)
		{
			_usernamePasswordCredentialElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_USERNAME_PASSWORD_CREDENTIAL}));			
			
		}
		
		Element usernameElement = XmlUtils.retrieveFirstChildMatchOfType(
				_usernamePasswordCredentialElement, 
				LocalElementNames.IDENTITY_USERNAME, 
				Constants.NSURI_IDENTITY_2005_05);
		
		if (usernameElement != null)
		{
			setUsername(XmlUtils.retrieveAllTextFromChildTextNodes(usernameElement));
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
