/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._08.addressing.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.IEndpointReference;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.IMetaData;
import org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.IIdentity;
import org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.impl.Identity;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class EndpointReference implements IEndpointReference {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	Element _endpointReferenceElement = null;
	
	String _address = null;
	
	IIdentity _identity = null;
	
	IMetaData _metaData = null;

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public String getAddress() {
		return _address;
	}

	public IIdentity getIdentity() {
		return _identity;
	}

	public IMetaData getMetaData() {
		return _metaData;
	}

	public void setAddress(String address) {
		_address = address;
	}

	public void setIdentity(IIdentity identity) {
		_identity = identity;
	}

	public void setMetaData(IMetaData metaData) {
		_metaData = metaData;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_endpointReferenceElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_endpointReferenceElement, 
				LocalElementNames.ADDRESSING_ENDPOINT_REFERENCE, 
				Constants.NSURI_ADDRESSING_2005_08) || _endpointReferenceElement == null)
		{
			_endpointReferenceElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_ADDRESSING_2005_08 + ":" + LocalElementNames.ADDRESSING_ENDPOINT_REFERENCE}));			
			
		}

		Element addressElement = XmlUtils.retrieveFirstChildMatchOfType(
				_endpointReferenceElement, 
				LocalElementNames.ADDRESSING_ADDRESS, 
				Constants.NSURI_ADDRESSING_2005_08);
		
		if (addressElement != null)
		{
			String s = XmlUtils.retrieveAllTextFromChildTextNodes(addressElement);
			
			if (s != null && s.length() > 0)
			{
				setAddress(s);
			}
		}
		
		Element identityElement = XmlUtils.retrieveFirstChildMatchOfType(
				_endpointReferenceElement, 
				LocalElementNames.ADDRESSINGIDENTITY_IDENTITY, 
				Constants.NSURI_ADDRESSINGIDENTITY_2006_02);
		
		if (identityElement != null)
		{
			_identity = new Identity();
			_identity.fromXml(identityElement);
			((Identity)_identity).setParent(this);
		}

		Element metaDataElement = XmlUtils.retrieveFirstChildMatchOfType(
				_endpointReferenceElement, 
				LocalElementNames.ADDRESSING_METADATA, 
				Constants.NSURI_ADDRESSING_2005_08);
		
		if (metaDataElement != null)
		{
			_metaData = new MetaData();
			_metaData.fromXml(metaDataElement);
			((MetaData)_metaData).setParent(this);
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
