/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ICardImage;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ILogoImage;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class CardImage
implements ICardImage {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private Element _cardImageElement = null;
    private byte[] _value = null;
    private boolean _isMimeTypeSet = false;
    private ILogoImage _mimeType = null;
    Object _parentNode = null;

    public Object getParent() {
        return this._parentNode;
    }

    public void setParent(Object parentNode) {
        this._parentNode = parentNode;
    }

    public ILogoImage getMimeType() {
        return this._mimeType;
    }

    public byte[] getValue() {
        return this._value;
    }

    public boolean isSetMimeType() {
        return this._isMimeTypeSet;
    }

    public void setMimeType(ILogoImage value) {
        this._mimeType = value;
        this._isMimeTypeSet = true;
    }

    public void setValue(byte[] value) {
        this._value = value;
    }

    public void unsetMimeType() {
        this._mimeType = null;
        this._isMimeTypeSet = false;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        String mimeTypeLiteral;
        this._cardImageElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._cardImageElement, "CardImage", "http://schemas.xmlsoap.org/ws/2005/05/identity") || this._cardImageElement == null) {
            this._cardImageElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://schemas.xmlsoap.org/ws/2005/05/identity:CardImage"}));
        }
        String valueTextBase64encoded = XmlUtils.retrieveAllTextFromChildTextNodes(this._cardImageElement);
        if (valueTextBase64encoded != null && valueTextBase64encoded.length() > 0) {
            this.setValue(Base64Utility.decode(valueTextBase64encoded));
        }
        if ((mimeTypeLiteral = this._cardImageElement.getAttribute("MimeType")) != null) {
            this.setMimeType(ILogoImage.getByLiteral(mimeTypeLiteral));
        }
    }

    public Object toXml() {
        return null;
    }
}

