/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.utils;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtils {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public static Element retrieveElementFromObject(Object obj) throws UnsupportedObjectModel {
        Element result = null;
        if (obj != null && obj instanceof Node) {
            Node n = (Node)obj;
            if (n.getNodeType() == 1) {
                result = (Element)n;
            } else if (n.getNodeType() == 9) {
                result = ((Document)n).getDocumentElement();
            }
        }
        if (result == null) {
            throw new UnsupportedObjectModel("This implementation only supports " + (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XmlUtils.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).getPackage().getName() + " objects.");
        }
        return result;
    }

    public static boolean isElementType(Element el, String nodeName, String namespaceUri) {
        boolean result = false;
        result = el != null && nodeName != null && namespaceUri != null && el.getNamespaceURI() != null && el.getNamespaceURI().equals(namespaceUri) && el.getNodeName() != null && el.getNodeName().equals(nodeName);
        return result;
    }

    public static int numberOfChildElementsOfType(Element parent, String nodeName, String namespaceUri) {
        int result = 0;
        if (parent == null || nodeName == null || namespaceUri == null) {
            return result;
        }
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !XmlUtils.isElementType((Element)n, nodeName, namespaceUri)) continue;
            ++result;
        }
        return result;
    }

    public static Element retrieveFirstChildMatchOfType(Element parent, String nodeName, String namespaceUri) {
        Element result = null;
        if (parent == null || nodeName == null || namespaceUri == null) {
            return result;
        }
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !XmlUtils.isElementType((Element)n, nodeName, namespaceUri)) continue;
            result = (Element)n;
            break;
        }
        return result;
    }

    public static String retrieveAllTextFromChildTextNodes(Element parent) {
        StringBuffer result = new StringBuffer();
        if (parent != null) {
            NodeList nl = parent.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n == null || n.getNodeType() != 3) continue;
                Text text = (Text)n;
                result.append(text.getData());
            }
        }
        return result.toString();
    }

    public static void buildObjectFromXml(Object parentObj, XMLSerializer obj, Element parent, String nodeName, String namespaceUri) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        Element childEl = XmlUtils.retrieveFirstChildMatchOfType(parent, nodeName, namespaceUri);
        if (childEl != null) {
            obj.fromXml(childEl);
            obj.setParent(parentObj);
        } else {
            obj = null;
        }
    }

    public static Document getDocumentRootFromParent(XMLSerializer child) {
        Object parent = child.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Document) {
            return (Document)parent;
        }
        if (parent instanceof XMLSerializer) {
            return XmlUtils.getDocumentRootFromParent((XMLSerializer)parent);
        }
        return null;
    }

    public static String getString(Node node) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

