/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CardStorePersonalCard
extends PersonalCard {
    public CardStorePersonalCard() throws IOException, Exception {
        this.description_ = "CardStore CardSpace-interoperable personal I-Card";
        this.provider_ = null;
        this.isSelfIssued_ = true;
        this.issuer_ = ISSUER_SELF;
        this.issuerName_ = "Self";
    }

    public CardStorePersonalCard(CardStorePersonalCard card2copy) {
        this.description_ = card2copy.description_;
        this.provider_ = card2copy.provider_;
        this.isSelfIssued_ = card2copy.isSelfIssued_;
        this.issuer_ = card2copy.issuer_;
        this.issuerName_ = card2copy.issuerName_;
        this.id_ = card2copy.id_;
        this.name_ = card2copy.name_;
        this.masterKey_ = card2copy.masterKey_;
        this.image_ = card2copy.image_;
        this.imageMimeType_ = card2copy.imageMimeType_;
        this.timeLastUpdated_ = new Date();
    }

    public CardStorePersonalCard(ICardProvider provider, Element element) throws IOException, Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Parameter \"element\" is null");
        }
        this.description_ = "CardStore CardSpace-interoperable personal I-Card";
        this.provider_ = provider;
        super.initFromXML(element);
    }

    public void setIId(URI id) {
        this.id_ = id;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public void setClaimList(List claims) throws CardException {
        super.setClaims(claims);
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
    }

    public void applyUpdates() throws InvalidStateException, CardException {
    }

    public void beginUpdates() throws InvalidStateException {
    }

    public void cancelUpdates() throws InvalidStateException {
    }

    public boolean isEditMode() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public void setImage(byte[] newImage, String newImageType) throws CardException {
        this.image_ = newImage;
        this.imageMimeType_ = newImageType;
    }

    public void setIssuerName(String name) throws CardException {
        this.issuerName_ = name;
    }

    public void setName(String newName) throws CardException {
        this.name_ = newName;
    }

    public void setTimeIssued(Date date) throws CardException {
        this.timeIssued_ = date;
    }

    public void setTimeExpires(Date date) throws CardException {
        this.timeExpires_ = date;
    }

    public void setTimeLastUpdate(Date date) throws CardException {
        this.timeLastUpdated_ = date;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
        if (this.claimValues_ == null) {
            this.claimValues_ = new LinkedHashMap();
        }
        if (credential != null && credential instanceof IPinCodeCredential) {
            IPinCodeCredential ipc = (IPinCodeCredential)credential;
            byte[] pinCode = ipc.getPinCode();
            try {
                byte[] key = this.makeKey(pinCode);
                Set claimTypeUris = this.dirtyClaimValueMap_.keySet();
                Object[] claimTypeStrs = claimTypeUris.toArray();
                for (int i = 0; claimTypeStrs != null && i < claimTypeStrs.length; ++i) {
                    ClaimValue cv = (ClaimValue)this.dirtyClaimValueMap_.get(claimTypeStrs[i]);
                    byte[] value = Base64Utility.decode(cv.getValue());
                    byte[] decrypted_value = this.decryptField(key, value);
                    String decrypted_str = new String(decrypted_value, "UTF-16LE");
                    ArrayList<String> vl = new ArrayList<String>();
                    vl.add(decrypted_str);
                    cv.setValues(vl);
                    this.claimValues_.put(claimTypeStrs[i], cv);
                }
                byte[] masterKeyValue = new byte[this.masterKey_.length - 37];
                System.arraycopy(this.masterKey_, 37, masterKeyValue, 0, this.masterKey_.length - 37);
                byte[] tmp = this.decryptField(key, masterKeyValue);
                this.masterKey_ = (byte[])tmp.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Set claimTypeUris = this.dirtyClaimValueMap_.keySet();
            Object[] claimTypeStrs = claimTypeUris.toArray();
            for (int i = 0; claimTypeStrs != null && i < claimTypeStrs.length; ++i) {
                this.claimValues_.put(claimTypeStrs[i], this.dirtyClaimValueMap_.get(claimTypeStrs[i]));
            }
        }
    }

    public void setPinCode(String pinCode) throws CardException {
    }

    public void setSupportedTokenTypeList(List supportedTokenTypes) {
        this.supportedTokenTypes_ = supportedTokenTypes;
    }

    public void setClaimsTypeList(List claimType) {
        this.claimTypes_ = claimType;
    }

    public void setMasterKey(byte[] key) {
        this.masterKey_ = key;
    }

    private void addTokenServiceList(Document doc, Element informationCardMetaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        informationCardMetaData.appendChild(tokenServiceList);
        Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
        tokenServiceList.appendChild(tokenService);
        Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
        tokenService.appendChild(endpointReference);
        Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
        Element metaData = doc.createElementNS("http://www.w3.org/2005/08/addressing", "MetaData");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
    }

    private byte[] makeKey(byte[] userInputBytes) throws CardException, NoSuchAlgorithmException {
        byte[] master_key = this.getMasterKey();
        byte[] salt = new byte[16];
        System.arraycopy(master_key, 1, salt, 0, 16);
        byte[] iter_count = new byte[4];
        System.arraycopy(master_key, 17, iter_count, 0, 4);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(userInputBytes);
        sha256.update(salt);
        byte[] digestBytes = sha256.digest();
        for (int i = 1; i < 1000; ++i) {
            sha256.update(digestBytes);
            digestBytes = sha256.digest();
        }
        sha256.reset();
        return digestBytes;
    }

    private byte[] decryptField(byte[] derivedKey, byte[] field) throws CardException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] master_key = this.getMasterKey();
        byte[] iv = new byte[16];
        System.arraycopy(master_key, 21, iv, 0, 16);
        SecretKeySpec encKey = new SecretKeySpec(derivedKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(iv);
        cipher.init(2, (Key)encKey, ips);
        byte[] out = cipher.doFinal(field);
        return out;
    }
}

