/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardStoreException;
import org.eclipse.higgins.icard.CardStoreStrategy;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.securestorage.CardStoreManagedCard;
import org.eclipse.higgins.icard.provider.securestorage.PasswordHandler;
import org.eclipse.higgins.icard.provider.securestorage.ProviderConfiguration;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Element;

public class SecureStorageICardProvider
extends BasicCardProvider {
    public static final String FILENAME = "store.filename";
    public static final String PASSWORD = "store.password";
    protected static String ID = "org.eclipse.higgins.icard.provider.securestorage";
    private static final String CLASS_NAME = (class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider == null ? (class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider = SecureStorageICardProvider.class$("org.eclipse.higgins.icard.provider.securestorage.SecureStorageICardProvider")) : class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider).getName();
    private static final String _name = "Secure Cardspace I-Card Provider";
    private static final String _description = "Stores Cardspace-based ICard in a secure storage. The actual strategy for storing and retrieving cards can be configured.";
    private static final Class DEFAULT_CARD_STORE_STRATEGY = class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy == null ? (class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy = SecureStorageICardProvider.class$("org.eclipse.higgins.icard.provider.securestorage.SecureStorageStrategy")) : class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy;
    public static final String DS_NS = "http://www.w3.org/2000/09/xmldsig#";
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider == null ? (class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider = SecureStorageICardProvider.class$("org.eclipse.higgins.icard.provider.securestorage.SecureStorageICardProvider")) : class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider));
    protected ProviderConfiguration config = new ProviderConfiguration(ID);
    protected Map _icards;
    private CardStoreStrategy _strategy;
    private boolean _lazy_synch = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageICardProvider;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IInformationCard;

    public SecureStorageICardProvider() {
        this(DEFAULT_CARD_STORE_STRATEGY);
    }

    public SecureStorageICardProvider(Class strategyClass) {
        CardStoreStrategy strategy;
        Constructor strategyConstructor;
        this.log.info((Object)"Create a new SecureStorageICardProvider");
        if (strategyClass == null) {
            throw new IllegalArgumentException("Strategy may not be null.");
        }
        try {
            strategyConstructor = strategyClass.getConstructor(null);
        }
        catch (Exception e) {
            this.log.error((Object)(strategyClass + "::Reflect invocation of strategy constructor failed Strategie class: [" + strategyClass + "] )."));
            throw new UnsupportedOperationException(strategyClass + "::ICardStoreStrategy cannot be instantiated (Strategie class: [" + strategyClass + "] ).");
        }
        try {
            strategy = (CardStoreStrategy)strategyConstructor.newInstance(null);
        }
        catch (Exception e) {
            this.log.error((Object)(strategyClass + "::Reflect invocation of strategy constructor failed Strategie class: [" + strategyClass + "] )."));
            throw new UnsupportedOperationException(strategyClass + "::ICardStoreStrategy cannot be instantiated (Strategie class: [" + strategyClass + "] ).");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy may not be null.");
        }
        this._icards = new HashMap();
        String filename = this.config.getProperty("cardstore.file");
        String password = this.config.getProperty("cardstore.password");
        this.log.info((Object)("Cardstore file: [" + filename + "]"));
        if (filename != null && password != null) {
            this.log.trace((Object)("filename=" + filename));
            PasswordHandler passwordHandler = new PasswordHandler(password);
            try {
                strategy.initialize(null, (ICardProvider)this, filename, (PasswordCallback)passwordHandler, (IConfiguration)this.config);
            }
            catch (CardStoreException e) {
                this.log.error((Object)"Problem when initializing the Strategy", (Throwable)e);
            }
        }
        this._strategy = strategy;
    }

    public SecureStorageICardProvider(CardStoreStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy may not be null.");
        }
        this._icards = new HashMap();
        this._strategy = strategy;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        this.log.trace((Object)(CLASS_NAME + "::canCreateCard(): ConnectiveId:" + id));
        throw new UnsupportedOperationException(CLASS_NAME + "::canCreateCard() not supported.");
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) {
        this.log.trace((Object)("createCards ConnectiveId:" + id));
        throw new UnsupportedOperationException(CLASS_NAME + "::createCard() not supported.");
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::deleteCard(): card=" + card));
        if (!this._icards.containsKey(card.getID())) {
            this.log.error((Object)("card [" + card.getName() + "] not found"));
            Iterator allCards = this._icards.values().iterator();
            while (allCards.hasNext()) {
                ICard card1 = (ICard)allCards.next();
                this.log.error((Object)("found card [" + card1.getName() + "]"));
            }
            throw new CardException("Card not existing:" + card.getID());
        }
        this._icards.remove(card.getID());
        if (!this._lazy_synch) {
            this._strategy.synchFromMap(authHandler, this._icards);
        }
    }

    public void clear(CallbackHandler authHandler) {
        this.log.trace((Object)(CLASS_NAME + "::clear()"));
        this._icards.clear();
    }

    public void addCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (card == null) {
            throw new CardException("ICard to be added is null.");
        }
        this._icards.put(card.getID(), card);
        if (!this._lazy_synch) {
            this._strategy.synchFromMap(authHandler, this._icards);
        }
    }

    public boolean containsCard(CallbackHandler authHandler, String id) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::containsCard(): ConnectiveId=" + id));
        if (!this._lazy_synch) {
            this._strategy.synchFromStore(authHandler, this._icards);
        }
        return this._icards.containsKey(id);
    }

    public boolean containsCard(CallbackHandler authHandler, ICard icard) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::containsCard(): by ICard, ConnectiveId=" + icard.getID()));
        if (!this._lazy_synch) {
            this._strategy.synchFromStore(authHandler, this._icards);
        }
        return this._icards.containsValue(icard);
    }

    public void exportCards(CallbackHandler authHandler, Iterator cards, OutputStream out) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::exportCards(): cards=" + cards));
        this._strategy.exportCards(authHandler, cards, out);
    }

    public String getDescription() {
        this.log.trace((Object)(CLASS_NAME + "::getDescription()"));
        return _description;
    }

    public ICard getICardByID(CallbackHandler authHandler, String ID) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::getICardByID(): ID=" + ID));
        if (!this._lazy_synch) {
            this._strategy.synchFromStore(authHandler, this._icards);
        }
        if (!this._icards.containsKey(ID)) {
            throw new CardException(CLASS_NAME + "::getICardByID(): ICard with index not found, ID=" + ID);
        }
        return (ICard)this._icards.get(ID);
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        if (!this._lazy_synch) {
            this._strategy.synchFromStore(authHandler, this._icards);
        }
        Iterator allCards = this._icards.values().iterator();
        return allCards;
    }

    public String getName() {
        this.log.trace((Object)(CLASS_NAME + "::getName()"));
        return _name;
    }

    public String getType() {
        String type = "cardspace_type";
        this.log.trace((Object)("return -> [" + type + "]"));
        return type;
    }

    public void changePassword(char[] oldPassword, char[] newPassword) throws CardException {
        if (!this._strategy.isPasswordProtected()) {
            throw new CardException("The ICardStoreStrategy does not support passwords.");
        }
        this._strategy.changePassword(oldPassword, newPassword);
    }

    public void changePassword(CallbackHandler authHandler) throws CardException {
        UIDChangePasswordTriple uid_pass = this.getChangePasswordCallback(authHandler);
        this.changePassword(uid_pass.getPassword(), uid_pass.getNewPassword());
    }

    public void importStore(CallbackHandler authHandler, String asciiStore) throws CardException {
        Map newCards;
        this._icards = newCards = this._strategy.importStore(authHandler, asciiStore);
        this._strategy.synchFromMap(authHandler, this._icards);
    }

    public ICard importCard(CallbackHandler authHandler, ICard icard) throws CardStoreException {
        this._icards.put(icard.getID(), icard);
        if (!this._lazy_synch) {
            this._strategy.synchFromMap(authHandler, this._icards);
        }
        return icard;
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::importCard(): filename: " + filename));
        File file = new File(filename);
        if (file.isDirectory()) {
            this.importCardsFromDirectory(authHandler, filename);
            return null;
        }
        if (file.getName().endsWith(".crds")) {
            this.importCardsFromCRDS(authHandler, filename);
            return null;
        }
        return this.importCardFromCRD(authHandler, filename);
    }

    protected ICard importCardFromCRD(CallbackHandler authHandler, String filename) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::importCard(): filename: " + filename));
        ICard icard = null;
        icard = this.retrieveICardString(filename);
        if (icard == null) {
            throw new CardException(CLASS_NAME + ":: the ICard XML representation could not be parsed. Parsing returned null. Filename=" + filename);
        }
        this._icards.put(icard.getID(), icard);
        if (!this._lazy_synch) {
            this._strategy.synchFromMap(authHandler, this._icards);
        }
        return icard;
    }

    public Map importCardsFromDirectory(CallbackHandler authHandler, String filename) throws CardException {
        throw new CardException("Import of whole directories not supported. Filename=" + filename);
    }

    public Map importCardsFromCRDS(CallbackHandler authHandler, String filename) throws CardException {
        throw new CardException("Import of whole directories not supported. Filename=" + filename);
    }

    private ICard retrieveICardString(String filename) throws CardException {
        File file = new File(filename);
        byte[] crdBytes = new byte[(int)file.length()];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(crdBytes);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)(CLASS_NAME + "::importCard(): ICard file not found. Filename=" + filename));
            throw new CardException(CLASS_NAME + "::importCard(): ICard file not found. Filename=" + filename, (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)(CLASS_NAME + "::importCard(): IOException while reading the imported ICard."));
            throw new CardException(CLASS_NAME + "::importCard(): IOException while reading the imported ICard.", (Throwable)e);
        }
        String strIcard = new String(crdBytes);
        CardStoreManagedCard icard = null;
        try {
            byte[] bom = new byte[]{-17, -69, -65};
            String BOM = new String(bom);
            if (strIcard.startsWith(BOM)) {
                strIcard = strIcard.substring(BOM.length());
            }
            Element element = null;
            element = XMLHelper.toDOM((String)strIcard);
            element = XMLUtils.getChildElement((Element)element, (String)DS_NS, (String)"Object");
            element = XMLUtils.getChildElement((Element)element, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCard");
            icard = new CardStoreManagedCard((ICardProvider)this, element);
        }
        catch (Exception e) {
            this.log.error((Object)(CLASS_NAME + "::importCard(): The ICard under filename=\"" + filename + "\" could not be parsed."));
            throw new CardException(CLASS_NAME + "::importCard(): The ICard under filename=\"" + filename + "\" could not be parsed.", (Throwable)e);
        }
        if (icard == null) {
            throw new CardException(CLASS_NAME + "::importCard(): The ICard file under filename=\"" + filename + "\" does not contains any ICards.");
        }
        return icard;
    }

    public IConfiguration getConfiguration() {
        this.log.trace((Object)(CLASS_NAME + "::getConfiguration()"));
        return this.config;
    }

    public String getID() {
        this.log.trace((Object)(CLASS_NAME + "::getID()"));
        return ID;
    }

    public void setID(String id) throws Exception {
        this.log.trace((Object)(CLASS_NAME + "::setID()"));
        ID = id;
    }

    public CardStoreStrategy getStrategy() {
        return this._strategy;
    }

    public void setStrategy(CardStoreStrategy _strategy) {
        this._strategy = _strategy;
    }

    public boolean isLazySynchronizing() {
        return this._lazy_synch;
    }

    public void setLazySynchronizing(boolean _lazy_synch) {
        this._lazy_synch = _lazy_synch;
    }

    protected UIDPasswordPair getUIDCallback(CallbackHandler authHandler) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::getUIDCallback()"));
        if (authHandler != null) {
            NameCallback nc = new NameCallback("User Number: ");
            PasswordCallback pc = new PasswordCallback("Password: ", false);
            Callback[] callbacks = new Callback[]{nc, pc};
            try {
                this.log.trace((Object)(CLASS_NAME + "::getUIDCallback(): send callbacks to authHandler."));
                authHandler.handle(callbacks);
                String username = nc.getName();
                char[] password = pc.getPassword();
                if (username == null || password == null) {
                    throw new CardException("Username or password were null.");
                }
                if (username.equals("")) {
                    throw new CardException("Username may not be empty.");
                }
                UIDPasswordPair uid_pass = new UIDPasswordPair(username, password);
                return uid_pass;
            }
            catch (IOException e) {
                throw new CardException((Throwable)e);
            }
            catch (UnsupportedCallbackException e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new IllegalArgumentException(CLASS_NAME + "::getUIDCallback: authHandler parameter cannot be null");
    }

    protected UIDChangePasswordTriple getChangePasswordCallback(CallbackHandler authHandler) throws CardException {
        this.log.trace((Object)(CLASS_NAME + "::getChangePasswordCallback()"));
        if (authHandler != null) {
            NameCallback nc = new NameCallback("User Number: ");
            PasswordCallback pc = new PasswordCallback("Old Password: ", false);
            PasswordCallback npc = new PasswordCallback("New Password: ", false);
            Callback[] callbacks = new Callback[]{nc, pc, npc};
            try {
                this.log.trace((Object)(CLASS_NAME + "::getChangePasswordCallback(): send callbacks to authHandler."));
                authHandler.handle(callbacks);
                String username = nc.getName();
                char[] password = pc.getPassword();
                char[] newPassword = npc.getPassword();
                if (username == null || password == null || newPassword == null) {
                    throw new CardException("Username or password were null.");
                }
                if (username.equals("")) {
                    throw new CardException("Username may not be empty.");
                }
                UIDChangePasswordTriple uid_pass = new UIDChangePasswordTriple(username, password, newPassword);
                return uid_pass;
            }
            catch (IOException e) {
                throw new CardException((Throwable)e);
            }
            catch (UnsupportedCallbackException e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new IllegalArgumentException(CLASS_NAME + "::getUIDCallback: authHandler parameter cannot be null");
    }

    public void synchToStorage(CallbackHandler authHandler) throws CardStoreException {
        this._strategy.synchFromMap(authHandler, this._icards);
    }

    public void synchFromStorage(CallbackHandler authHandler) throws CardStoreException {
        this._strategy.synchFromStore(authHandler, this._icards);
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement card) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        return null;
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, String CUID2) throws CardException {
        return this.getICardByCUID(authHandler, new CUID(CUID2));
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        this.log.info((Object)("getICardByCUID(" + cuid + ")"));
        Set set = this._icards.keySet();
        Iterator iter = set.iterator();
        if (iter.hasNext()) {
            this.log.info((Object)("first key of the map:" + iter.next()));
        }
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.info((Object)("Mysmatch: Current Provider[" + this.getID() + "]  Asked Provider [" + cuid.getProviderID() + "]"));
            return null;
        }
        ICard icard = (ICard)this._icards.get(cuid.getCardID());
        this.log.info((Object)("retrieving card(" + cuid.getCardID() + ") -> " + icard));
        return icard;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        return this.getICardByCUID(authHandler, cuid);
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IInformationCard == null ? (class$org$eclipse$higgins$icard$IInformationCard = SecureStorageICardProvider.class$("org.eclipse.higgins.icard.IInformationCard")) : class$org$eclipse$higgins$icard$IInformationCard};
    }

    public ICard importICard(CallbackHandler authHandler, IElement card) throws CardException {
        return null;
    }

    public String getFilename() {
        return this.config.getProperty("cardstore.file");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class UIDChangePasswordTriple {
        private final String UID;
        private final char[] password;
        private final char[] newPassword;

        UIDChangePasswordTriple(String UID, char[] password, char[] newPassword) {
            this.UID = UID;
            this.password = password;
            this.newPassword = newPassword;
        }

        String getUID() {
            return this.UID;
        }

        char[] getPassword() {
            return this.password;
        }

        char[] getNewPassword() {
            return this.newPassword;
        }
    }

    public class UIDPasswordPair {
        private final String UID;
        private final char[] password;

        UIDPasswordPair(String UID, char[] password) {
            this.UID = UID;
            this.password = password;
        }

        String getUID() {
            return this.UID;
        }

        char[] getPassword() {
            return this.password;
        }
    }
}

