/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardReference;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class InformationCardReference
implements IInformationCardReference {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private Element _cardReferenceElement = null;
    private String _cardId = null;
    private long _cardVersion = 0L;
    private boolean _isVersionSet = false;
    Object _parentNode = null;

    public Object getParent() {
        return this._parentNode;
    }

    public void setParent(Object parentNode) {
        this._parentNode = parentNode;
    }

    public String getCardId() {
        return this._cardId;
    }

    public long getCardVersion() {
        return this._cardVersion;
    }

    public boolean isSetCardVersion() {
        return this._isVersionSet;
    }

    public void setCardId(String cardId) {
        this._cardId = cardId;
    }

    public void setCardVersion(long value) {
        this._cardVersion = value;
        this._isVersionSet = true;
    }

    public void unsetCardVersion() {
        this._cardVersion = 0L;
        this._isVersionSet = false;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        String versionText;
        this._cardReferenceElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._cardReferenceElement, "InformationCardReference", "http://schemas.xmlsoap.org/ws/2005/05/identity") || this._cardReferenceElement == null) {
            this._cardReferenceElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://schemas.xmlsoap.org/ws/2005/05/identity:InformationCardReference"}));
        }
        Element cardIdElement = XmlUtils.retrieveFirstChildMatchOfType(this._cardReferenceElement, "CardId", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        Element cardVersionElement = XmlUtils.retrieveFirstChildMatchOfType(this._cardReferenceElement, "CardVersion", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        if (cardIdElement != null) {
            this.setCardId(XmlUtils.retrieveAllTextFromChildTextNodes(cardIdElement));
        }
        if (cardVersionElement != null && (versionText = XmlUtils.retrieveAllTextFromChildTextNodes(cardVersionElement)) != null && versionText.length() > 0) {
            try {
                long version = Long.parseLong(versionText);
                this.setCardVersion(version);
            }
            catch (Exception exception) {}
        }
    }

    public Object toXml() {
        return null;
    }
}

