/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.cardstore.exceptions.DuplicateCardIdException;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.logging.Log;
import org.eclipse.higgins.cardstore.logging.LogHelper;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingInformationCard;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.RoamingInformationCard;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RoamingStore
implements IRoamingStore {
    public static String copyright = "Licensed Materials - Property of IBM\n(C) Copyright IBM Corporation 2004, 2005, 2007. All Rights Reserved.\nU.S. Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n";
    private static Log _log;
    private Element _roamingStoreElement = null;
    private List _roamingInfomationCardsList = new ArrayList();
    private Map _mapOfInfoCards = new HashMap();
    Object _parentNode = null;
    boolean _hasChanges = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.RoamingStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = LogHelper.getLogger(clazz);
    }

    public Object getParent() {
        return this._parentNode;
    }

    public void setParent(Object parentNode) {
        this._parentNode = parentNode;
    }

    public IRoamingInformationCard getRoamingInformationCardByCardId(String id) {
        if (this._mapOfInfoCards != null) {
            return (IRoamingInformationCard)this._mapOfInfoCards.get(id);
        }
        return null;
    }

    public IRoamingInformationCard[] getRoamingInformationCards() {
        IRoamingInformationCard[] cards = null;
        if (this._roamingInfomationCardsList != null) {
            cards = new IRoamingInformationCard[this._roamingInfomationCardsList.size()];
            this._roamingInfomationCardsList.toArray(cards);
        } else {
            cards = new IRoamingInformationCard[]{};
        }
        return cards;
    }

    public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
        this._roamingStoreElement = XmlUtils.retrieveElementFromObject(obj);
        if (!XmlUtils.isElementType(this._roamingStoreElement, "RoamingStore", "http://schemas.xmlsoap.org/ws/2005/05/identity")) {
            this._roamingStoreElement = null;
            throw new ExpectedObjectNotPresent(MessageHelper.getMessage("expected_object_not_present", new Object[]{"http://schemas.xmlsoap.org/ws/2005/05/identity:RoamingStore"}));
        }
        this._roamingInfomationCardsList = new ArrayList();
        NodeList nl = this._roamingStoreElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && XmlUtils.isElementType((Element)n, "RoamingInformationCard", "http://schemas.xmlsoap.org/ws/2005/05/identity")) {
                RoamingInformationCard card = new RoamingInformationCard();
                card.fromXml((Element)n);
                card.setParent(this);
                try {
                    this.addRoamingInformationCard(card);
                }
                catch (Exception e) {
                    _log.error(null, e);
                }
            }
            ++i;
        }
        this._hasChanges = false;
    }

    private void addInfoCardToMap(IRoamingInformationCard card) {
        if (card != null && card.getInformationCardMetaData() != null && card.getInformationCardMetaData().getInformationCardReference() != null && card.getInformationCardMetaData().getInformationCardReference().getCardId() != null) {
            this._mapOfInfoCards.put(card.getInformationCardMetaData().getInformationCardReference().getCardId(), card);
        }
    }

    public Object toXml() {
        if (this._hasChanges || this._roamingStoreElement == null) {
            Document doc = XmlUtils.getDocumentRootFromParent(this);
            try {
                if (doc == null) {
                    doc = XmlUtils.newDocument();
                }
            }
            catch (Exception e) {
                throw new Error("Error when creating a new RoamingStore DOC", e);
            }
            Element roamingStoreElement = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingStore");
            roamingStoreElement.setAttribute("xmlns", "http://schemas.xmlsoap.org/ws/2005/05/identity");
            if (this._roamingInfomationCardsList != null) {
                int i = 0;
                while (i < this._roamingInfomationCardsList.size()) {
                    try {
                        Element cardElement;
                        IRoamingInformationCard card = (IRoamingInformationCard)this._roamingInfomationCardsList.get(i);
                        if (card != null && (cardElement = (Element)card.toXml()) != null) {
                            cardElement = (Element)doc.importNode(cardElement, true);
                            roamingStoreElement.appendChild(cardElement);
                        }
                    }
                    catch (Exception e) {
                        _log.error(null, e);
                    }
                    ++i;
                }
            }
            this._roamingStoreElement = roamingStoreElement;
        }
        return this._roamingStoreElement;
    }

    public void addRoamingInformationCard(IRoamingInformationCard card) throws DuplicateCardIdException {
        if (card != null && card.getInformationCardMetaData() != null && card.getInformationCardMetaData().getInformationCardReference() != null && card.getInformationCardMetaData().getInformationCardReference().getCardId() != null) {
            String id = card.getInformationCardMetaData().getInformationCardReference().getCardId();
            if (id != null && this._mapOfInfoCards.get(id) == null) {
                this._roamingInfomationCardsList.add(card);
                this.addInfoCardToMap(card);
            } else {
                throw new DuplicateCardIdException(MessageHelper.getMessage("dup_cardid_could_not_be_added", new Object[]{id}));
            }
        }
        this._hasChanges = true;
    }

    public IRoamingInformationCard removeRoamingInformationCardByCardId(String id) {
        int index;
        IRoamingInformationCard result = this.getRoamingInformationCardByCardId(id);
        if (result != null && (result = (IRoamingInformationCard)this._roamingInfomationCardsList.remove(index = this._roamingInfomationCardsList.indexOf(result))) != null) {
            this._hasChanges = true;
        }
        return result;
    }
}

