/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardReference;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class InformationCardReference implements IInformationCardReference {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _cardReferenceElement = null;
	
	private String _cardId = null;
	private long _cardVersion = 0;
	private boolean _isVersionSet = false;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}	
	
	
	public String getCardId() {
		return _cardId;
	}

	public long getCardVersion() {
		return _cardVersion;
	}

	public boolean isSetCardVersion() {
		return _isVersionSet;
	}

	public void setCardId(String cardId) {
		_cardId = cardId;		
	}

	public void setCardVersion(long value) {
		_cardVersion = value;
		_isVersionSet = true;
	}

	public void unsetCardVersion() {
		_cardVersion = 0;
		_isVersionSet = false;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {

		_cardReferenceElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_cardReferenceElement, 
				LocalElementNames.IDENTITY_INFORMATION_CARD_REFERENCE, 
				Constants.NSURI_IDENTITY_2005_05) || _cardReferenceElement == null)
		{
			_cardReferenceElement = null;

			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_INFORMATION_CARD_REFERENCE}));
			
		}

		Element cardIdElement = XmlUtils.retrieveFirstChildMatchOfType(
				_cardReferenceElement, 
				LocalElementNames.IDENTITY_CARD_ID, 
				Constants.NSURI_IDENTITY_2005_05);

		Element cardVersionElement = XmlUtils.retrieveFirstChildMatchOfType(
				_cardReferenceElement, 
				LocalElementNames.IDENTITY_CARD_VERSION, 
				Constants.NSURI_IDENTITY_2005_05);
		
		if (cardIdElement != null)
		{
			setCardId(XmlUtils.retrieveAllTextFromChildTextNodes(cardIdElement));
		}

		if (cardVersionElement != null)
		{
			String versionText = XmlUtils.retrieveAllTextFromChildTextNodes(cardVersionElement);
			
			if (versionText != null && versionText.length() > 0)
			{
				try {					
					long version = Long.parseLong(versionText);
					setCardVersion(version);
				} catch (Exception e) {
					// ignore.
				}
			}
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
