/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardMetaData;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardPrivateData;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingInformationCard;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class RoamingInformationCard implements IRoamingInformationCard {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _roamingInfoCardElement = null;
	
	private IInformationCardMetaData _metaData = null;
	
	private IInformationCardPrivateData _privateData = null;

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public void fromXml(Object obj) throws UnsupportedObjectModel, ExpectedObjectNotPresent {
		_roamingInfoCardElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_roamingInfoCardElement, 
				LocalElementNames.IDENTITY_ROAMING_INFORMATION_CARD, 
				Constants.NSURI_IDENTITY_2005_05) || _roamingInfoCardElement == null)
		{
			_roamingInfoCardElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_ROAMING_INFORMATION_CARD}));
			
		}
		
		Element metaDataElement = XmlUtils.retrieveFirstChildMatchOfType(
				_roamingInfoCardElement, 
				LocalElementNames.IDENTITY_INFORMATION_CARD_META_DATA, 
				Constants.NSURI_IDENTITY_2005_05);
		
		Element privateDataElement = XmlUtils.retrieveFirstChildMatchOfType(
				_roamingInfoCardElement, 
				LocalElementNames.IDENTITY_INFORMATION_CARD_PRIVATE_DATA, 
				Constants.NSURI_IDENTITY_2005_05);
		
		if (metaDataElement != null)
		{
			_metaData = new InformationCardMetaData();
			_metaData.fromXml(metaDataElement);
			_metaData.setParent(this);
		}
		
		if (privateDataElement != null)
		{
			_privateData = new InformationCardPrivateData();
			_privateData.fromXml(privateDataElement);			
		}
	}

	public Object toXml() {
		//TODO need to complete
		return _roamingInfoCardElement;
	}

	public IInformationCardMetaData getInformationCardMetaData() {
		return _metaData;
	}

	public IInformationCardPrivateData getInformationCardPrivateData() {
		return _privateData;
	}

	public void setInformationCardMetaData(IInformationCardMetaData value) {
		 _metaData = value; 		
	}

	public void setInformationCardPrivateData(IInformationCardPrivateData value) {
		_privateData = value;		
	}

}
