/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ITokenService;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IUserCredential;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.IEndpointReference;
import org.eclipse.higgins.cardstore.schemas._2005._08.addressing.impl.EndpointReference;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class TokenService implements ITokenService {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	Element _tokenServiceElement = null;
	
	IEndpointReference _endpointReference = null;
	
	IUserCredential _userCredential = null;

	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		

	public IEndpointReference getEndpointReference() {
		return _endpointReference;
	}

	public IUserCredential getUserCredential() {
		return _userCredential;
	}

	public void setEndpointReference(IEndpointReference value) {
		_endpointReference = value;
	}

	public void setUserCredential(IUserCredential value) {
		_userCredential = value;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_tokenServiceElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_tokenServiceElement, 
				LocalElementNames.IDENTITY_TOKEN_SERVICE, 
				Constants.NSURI_IDENTITY_2005_05) || _tokenServiceElement == null)
		{
			_tokenServiceElement = null;

			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_TOKEN_SERVICE}));			
			
		}
		
		Element endpointReferenceElement = XmlUtils.retrieveFirstChildMatchOfType(
				_tokenServiceElement, 
				LocalElementNames.ADDRESSING_ENDPOINT_REFERENCE, 
				Constants.NSURI_ADDRESSING_2005_08);
		
		if (endpointReferenceElement != null)
		{
			_endpointReference = new EndpointReference();
			_endpointReference.fromXml(endpointReferenceElement);
			((EndpointReference)_endpointReference).setParent(this);
		}

		Element userCredentialElement = XmlUtils.retrieveFirstChildMatchOfType(
				_tokenServiceElement, 
				LocalElementNames.IDENTITY_USER_CREDENTIAL, 
				Constants.NSURI_IDENTITY_2005_05);
		
		if (userCredentialElement != null)
		{
			_userCredential = new UserCredential();
			_userCredential.fromXml(userCredentialElement);
		}
	}

	public Object toXml() {
	    return _tokenServiceElement;
	}

}
